/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.prism;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class JStachePrism {
    private String _path;
    private String _template;
    private String _adapterName;
    private TypeMirror _contentType;
    private TypeMirror _formatter;
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static JStachePrism getInstanceOn(Element e) {
        AnnotationMirror m = JStachePrism.getMirror("io.jstach.jstache.JStache", e);
        if (m == null) {
            return null;
        }
        return JStachePrism.getInstance(m);
    }

    public static JStachePrism getInstance(AnnotationMirror mirror) {
        return new JStachePrism(mirror);
    }

    private JStachePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._path = this.getValue("path", String.class);
        this._template = this.getValue("template", String.class);
        this._adapterName = this.getValue("adapterName", String.class);
        this._contentType = this.getValue("contentType", TypeMirror.class);
        this._formatter = this.getValue("formatter", TypeMirror.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String path() {
        return this._path;
    }

    public String template() {
        return this._template;
    }

    public String adapterName() {
        return this._adapterName;
    }

    public TypeMirror contentType() {
        return this._contentType;
    }

    public TypeMirror formatter() {
        return this._formatter;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = JStachePrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = JStachePrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : JStachePrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return null;
            }
            return result;
        }
        return null;
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue path() {
            return this.values.get("path");
        }

        public AnnotationValue template() {
            return this.values.get("template");
        }

        public AnnotationValue adapterName() {
            return this.values.get("adapterName");
        }

        public AnnotationValue contentType() {
            return this.values.get("contentType");
        }

        public AnnotationValue formatter() {
            return this.values.get("formatter");
        }
    }
}

