/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.FragmentTokenProcessor;
import io.jstach.apt.NamedReader;
import io.jstach.apt.TemplateCompiler;
import io.jstach.apt.TemplateCompilerLike;
import io.jstach.apt.TextFileObject;
import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.CodeAppendable;
import io.jstach.apt.internal.FormatterTypes;
import io.jstach.apt.internal.FragmentNotFoundException;
import io.jstach.apt.internal.NamedTemplate;
import io.jstach.apt.internal.ProcessingConfig;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.context.RenderingCodeGenerator;
import io.jstach.apt.internal.context.TemplateCompilerContext;
import io.jstach.apt.internal.context.TemplateStack;
import io.jstach.apt.internal.context.VariableContext;
import io.jstach.apt.internal.util.ClassRef;
import io.jstach.apt.prism.Prisms;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;

class CodeWriter {
    private final CodeAppendable writer;
    private final RenderingCodeGenerator codeGenerator;
    private final Map<String, NamedTemplate> partials;
    private final ProcessingConfig config;

    CodeWriter(CodeAppendable writer, RenderingCodeGenerator codeGenerator, Map<String, NamedTemplate> partials, ProcessingConfig config) {
        this.writer = writer;
        this.codeGenerator = codeGenerator;
        this.partials = partials;
        this.config = config;
    }

    TemplateCompilerContext createTemplateContext(NamedTemplate template, TypeElement element, String rootExpression, VariableContext variableContext, Set<Prisms.Flag> flags) throws AnnotatedException {
        ClassRef modelClass = ClassRef.of(element);
        return this.codeGenerator.createTemplateCompilerContext(TemplateStack.ofRoot(modelClass, template, flags), element, rootExpression, variableContext);
    }

    void setFormatCallType(FormatterTypes.FormatCallType formatCallType) {
        this.codeGenerator.setFormatCallType(formatCallType);
    }

    void println(String s) {
        try {
            this.writer.append(s).append("\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void compileTemplate(TextFileObject resource, TemplateCompilerContext context) throws IOException, ProcessingException {
        TemplateStack stack = context.getTemplateStack();
        String templateName = stack.getTemplateName();
        if (!(stack instanceof TemplateStack.RootTemplateStack)) {
            throw new IllegalStateException("Expected root template");
        }
        TemplateStack.RootTemplateStack rt = (TemplateStack.RootTemplateStack)stack;
        NamedTemplate rootTemplate = rt.template();
        TemplateCompilerLike.TemplateLoader templateLoader = name -> {
            NamedTemplate nt = name.equals(templateName) ? rootTemplate : this.partials.get(name);
            if (nt == null) {
                try {
                    URI uri = new URI(name);
                    if (uri.getPath() == null || uri.getPath().isBlank()) {
                        throw new URISyntaxException(name, "Template is missing URI path.");
                    }
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
                nt = new NamedTemplate.FileTemplate(name, name, stack.elementToLog(), stack.annotationToLog());
            }
            if (nt instanceof NamedTemplate.FileTemplate) {
                URI uri;
                NamedTemplate.FileTemplate ft = (NamedTemplate.FileTemplate)nt;
                try {
                    uri = this.config.pathConfig().resolveTemplatePath(rootTemplate, ft);
                }
                catch (URISyntaxException e) {
                    throw new IOException(String.format("Resolved Template path \"%s\" is not a valid URI", ft.path()), e);
                }
                return this.reader(resource, name, uri);
            }
            if (nt instanceof NamedTemplate.InlineTemplate) {
                NamedTemplate.InlineTemplate it = (NamedTemplate.InlineTemplate)nt;
                String template = it.template();
                StringReader sr = new StringReader(template);
                return new NamedReader(sr, name, "INLINE");
            }
            throw new IllegalStateException();
        };
        try (TemplateCompiler templateCompiler = TemplateCompiler.createCompiler(templateName, templateLoader, this.writer, context, this.config.flags());){
            templateCompiler.run();
        }
    }

    private NamedReader reader(TextFileObject resource, String name, URI uri) throws IOException {
        String fragment = uri.getFragment();
        String path = uri.getPath();
        if (path == null || path.isBlank()) {
            throw new IOException("Path is blank or null for template. name: " + name + "  uri: " + uri);
        }
        if (fragment == null || fragment.isBlank()) {
            return this.fileReader(resource, name, path);
        }
        try {
            return this.fragmentReader(resource, name, path, fragment);
        }
        catch (ProcessingException e) {
            throw new IOException("Fragment parsing failure for path: \"" + path + "\"", e);
        }
    }

    private NamedReader fileReader(TextFileObject resource, String name, String path) throws IOException {
        try {
            return new NamedReader(new InputStreamReader((InputStream)new BufferedInputStream(resource.openInputStream(path)), resource.charset()), name, path);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Failed to read template \"" + name + "\" for path \"" + path + "\"", e);
        }
    }

    private NamedReader fragmentReader(TextFileObject resource, String name, String path, String fragment) throws IOException, ProcessingException {
        NamedReader reader = this.fileReader(resource, name, path);
        FragmentTokenProcessor processor = new FragmentTokenProcessor(fragment, this.config);
        String result = processor.run(reader);
        if (!processor.wasFound()) {
            throw new FragmentNotFoundException(path, fragment);
        }
        StringReader sr = new StringReader(result);
        return new NamedReader(sr, name, path + "#" + fragment);
    }

    public ProcessingConfig getConfig() {
        return this.config;
    }
}

