/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.CatalogClassWriter;
import io.jstach.apt.CodeWriter;
import io.jstach.apt.DeclarationException;
import io.jstach.apt.ServicesFiles;
import io.jstach.apt.TemplateClassWriter;
import io.jstach.apt.TextFileObject;
import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.CodeAppendable;
import io.jstach.apt.internal.FormatterTypes;
import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.NamedTemplate;
import io.jstach.apt.internal.Position;
import io.jstach.apt.internal.ProcessingConfig;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.RenderingCodeGenerator;
import io.jstach.apt.internal.meta.ElementMessage;
import io.jstach.apt.internal.util.ClassRef;
import io.jstach.apt.internal.util.Throwables;
import io.jstach.apt.prism.JStacheCatalogPrism;
import io.jstach.apt.prism.JStacheConfigPrism;
import io.jstach.apt.prism.JStacheContentTypePrism;
import io.jstach.apt.prism.JStacheFlagsPrism;
import io.jstach.apt.prism.JStacheFormatterPrism;
import io.jstach.apt.prism.JStacheFormatterTypesPrism;
import io.jstach.apt.prism.JStacheInterfacesPrism;
import io.jstach.apt.prism.JStachePartialPrism;
import io.jstach.apt.prism.JStachePartialsPrism;
import io.jstach.apt.prism.JStachePathPrism;
import io.jstach.apt.prism.JStachePrism;
import io.jstach.apt.prism.Prisms;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Inherited;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

@SupportedOptions(value={"jstache.resourcesPath", "jstache.incremental", "jstache.debug", "jstache.no_inverted_broken_chain", "jstache.no_null_checking", "jstache.claim_annotations", "jstache.gradle_incremental"})
public class GenerateRendererProcessor
extends AbstractProcessor
implements Prisms {
    static final String JSTACHE_GRADLE_INCREMENTAL = "jstache.gradle_incremental";
    static final String JSTACHE_CLAIM_ANNOTATIONS = "jstache.claim_annotations";
    private GradleIncremental gradleIncremental = GradleIncremental.disable;
    Set<JStacheRef> rendererClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    Set<CatalogRef> catalogClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<ElementMessage> errors = new ArrayList<ElementMessage>();
    boolean globalDebug = false;
    boolean catalogGenerated = false;
    boolean generateServiceFiles = true;
    boolean claimAnnotations = false;
    static Map<String, Prisms.Flag> processorOptionNames;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private static String formatErrorMessage(Position position, @Nullable String message) {
        message = message == null ? "" : message;
        String formatString = "%s:%d: error: %s%n%s%n%s%nsymbol: mustache directive%nlocation: mustache template";
        @Nullable Object @NonNull [] fields = new Object[]{position.fileName(), position.row(), message, position.currentLine().replace('\t', ' '), GenerateRendererProcessor.columnPositioningString(position.col())};
        return String.format(formatString, fields);
    }

    private static String columnPositioningString(int col) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < col - 1; ++i) {
            builder.append(' ');
        }
        builder.append('^');
        return builder.toString();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Map<String, String> opts = processingEnv.getOptions();
        this.claimAnnotations = Boolean.parseBoolean(opts.get(JSTACHE_CLAIM_ANNOTATIONS));
        boolean incremental = Boolean.parseBoolean(opts.get("jstache.incremental"));
        GradleIncremental gradleIncremental = Optional.ofNullable(opts.get(JSTACHE_GRADLE_INCREMENTAL)).map(GradleIncremental::valueOf).orElse(null);
        if (gradleIncremental == null) {
            gradleIncremental = incremental ? GradleIncremental.isolating : GradleIncremental.disable;
        }
        this.gradleIncremental = gradleIncremental;
        this.globalDebug = this.resolveFlags(opts, null).contains((Object)Prisms.Flag.DEBUG);
        LoggingSupport.RootLogging rootLogging = new LoggingSupport.RootLogging(processingEnv.getMessager(), this.globalDebug);
        if (this.globalDebug) {
            for (Map.Entry<String, String> e : opts.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (!k.startsWith("jstache.")) continue;
                rootLogging.debug(k + " = " + v);
            }
        }
        if (gradleIncremental == GradleIncremental.isolating) {
            this.generateServiceFiles = false;
            rootLogging.info("Incremental is turned on so catalogs and service provider files will not be (re)generated!");
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.copyOf(Prisms.ANNOTATIONS);
    }

    @Override
    public Set<String> getSupportedOptions() {
        if (this.gradleIncremental != GradleIncremental.disable) {
            Object gradleFlag = this.gradleIncremental.name();
            gradleFlag = "org.gradle.annotation.processing." + (String)gradleFlag;
            return Stream.concat(Stream.of(gradleFlag), super.getSupportedOptions().stream()).collect(Collectors.toSet());
        }
        return super.getSupportedOptions();
    }

    @Override
    public boolean process(Set<? extends TypeElement> processAnnotations, RoundEnvironment roundEnv) {
        try {
            this._process(roundEnv);
            return this.claimAnnotations;
        }
        catch (AnnotatedException e) {
            e.report(this.processingEnv.getMessager());
            return this.claimAnnotations;
        }
    }

    private void _process(RoundEnvironment roundEnv) throws AnnotatedException {
        JavaLanguageModel.createInstance(this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils(), this.processingEnv.getMessager());
        Map<String, String> options = this.processingEnv.getOptions();
        LoggingSupport.RootLogging rootLogging = new LoggingSupport.RootLogging(this.processingEnv.getMessager(), this.globalDebug);
        if (roundEnv.processingOver()) {
            for (ElementMessage error : this.errors) {
                TypeElement element = this.processingEnv.getElementUtils().getTypeElement(error.qualifiedElementName());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error.message(), element);
            }
            ClassRef serviceClass = ClassRef.ofBinaryName("io.jstach.jstachio.spi.TemplateProvider");
            Stream<ClassRef> renderers = this.rendererClasses.stream().filter(jr -> jr.jstachio() && jr.pub()).map(jr -> jr.classRef());
            Stream<ClassRef> catalogs = this.catalogClasses.stream().filter(c -> c.flags().contains((Object)Prisms.CatalogFlag.GENERATE_PROVIDER_META_INF_SERVICE)).map(c -> c.classRef());
            if (this.generateServiceFiles) {
                ServicesFiles.writeServicesFile(this.processingEnv.getFiler(), rootLogging, serviceClass, Stream.concat(catalogs, renderers).toList());
                ClassRef classRef = ClassRef.ofBinaryName("io.jstach.jstachio.spi.JStachioExtension");
                List<ClassRef> list = this.catalogClasses.stream().filter(c -> c.flags().contains((Object)Prisms.CatalogFlag.GENERATE_FINDER_META_INF_SERVICE)).map(c -> c.classRef()).toList();
                ServicesFiles.writeServicesFile(this.processingEnv.getFiler(), rootLogging, classRef, list);
            }
            if (!this.catalogGenerated) {
                this.generateCatalog();
            }
            return;
        }
        boolean found = false;
        TypeElement jstacheCatalogElement = this.processingEnv.getElementUtils().getTypeElement("io.jstach.jstache.JStacheCatalog");
        for (Element element : roundEnv.getElementsAnnotatedWith(jstacheCatalogElement)) {
            PackageElement packageElement = (PackageElement)element;
            JStacheCatalogPrism jstacheCatalog = JStacheCatalogPrism.getInstanceOn(packageElement);
            if (jstacheCatalog == null) {
                throw new IllegalStateException("This might be a bug. JStacheCatalogPrism failed.");
            }
            String catalogName = jstacheCatalog.name();
            ClassRef classRef = ClassRef.of(packageElement, catalogName);
            this.catalogClasses.add(new CatalogRef(jstacheCatalog, classRef, packageElement));
            found = true;
        }
        TypeElement jstacheElement = this.processingEnv.getElementUtils().getTypeElement("io.jstach.jstache.JStache");
        for (Element element : roundEnv.getElementsAnnotatedWith(jstacheElement)) {
            TypeElement classElement = (TypeElement)element;
            JStachePrism jstache = JStachePrism.getInstanceOn(classElement);
            if (jstache == null) {
                throw new IllegalStateException("This might be a bug. JStachePrism failed.");
            }
            @Nullable JStacheRef ref = this.writeRenderableAdapterClass(classElement, jstache, options);
            if (ref != null) {
                this.rendererClasses.add(ref);
            }
            found = true;
        }
        if (!found) {
            this.generateCatalog();
        }
    }

    private void generateCatalog() {
        if (this.catalogGenerated || !this.generateServiceFiles) {
            return;
        }
        this.catalogGenerated = true;
        for (CatalogRef cat : this.catalogClasses) {
            ClassRef cc = cat.classRef();
            CatalogClassWriter cw = new CatalogClassWriter(cc.getPackageName(), cc.getSimpleName());
            cw.addAll(this.rendererClasses.stream().filter(js -> js.jstachio() && (js.pub() || js.classRef().isSamePackage(cc))).map(js -> js.classRef()).toList());
            cw.write(this.processingEnv.getFiler(), cat.logging());
        }
    }

    @Nullable JStachePathPrism pathInstanceOn(Element element) {
        JStachePathPrism prism = JStachePathPrism.getInstanceOn(element);
        if (prism != null) {
            return prism;
        }
        JStacheConfigPrism config = JStacheConfigPrism.getInstanceOn(element);
        if (config == null || config.pathing() == null || config.pathing().isEmpty()) {
            return null;
        }
        return config.pathing().get(0);
    }

    private ProcessingConfig.PathConfig resolvePathConfig(TypeElement element) {
        JStachePathPrism prism = this.findPrisms(element, this::pathInstanceOn).findFirst().orElse(null);
        String defaultPrefix = "";
        String defaultSuffix = "";
        if (prism == null) {
            return new ProcessingConfig.PathConfig("", "", true, true);
        }
        String prefix = prism.prefix();
        String suffix = prism.suffix();
        boolean prefixUnspecified = "*".equals(prefix);
        boolean suffixUnspecified = "*".equals(suffix);
        prefix = prefixUnspecified ? "" : prefix;
        suffix = suffixUnspecified ? "" : suffix;
        return new ProcessingConfig.PathConfig(prefix, suffix, prefixUnspecified, suffixUnspecified);
    }

    @Nullable JStacheInterfacesPrism interfacesInstanceOn(Element element) {
        JStacheInterfacesPrism prism = JStacheInterfacesPrism.getInstanceOn(element);
        if (prism != null) {
            return prism;
        }
        JStacheConfigPrism config = JStacheConfigPrism.getInstanceOn(element);
        if (config == null || config.interfacing() == null || config.interfacing().isEmpty()) {
            return null;
        }
        return config.interfacing().get(0);
    }

    private InterfacesConfig resolveBaseInterfaces(TypeElement element) throws AnnotatedException {
        List<JStacheInterfacesPrism> prisms = this.findPrisms(element, this::interfacesInstanceOn).toList();
        List<String> templateInterfaces = prisms.stream().map(JStacheInterfacesPrism::templateImplements).flatMap(faces -> faces.stream()).map(tm -> this.getTypeName((TypeMirror)tm, element)).toList();
        List<String> templateAnnotions = prisms.stream().map(JStacheInterfacesPrism::templateAnnotations).flatMap(faces -> faces.stream()).map(tm -> this.getTypeName((TypeMirror)tm)).toList();
        TypeElement extendsElement = prisms.stream().map(JStacheInterfacesPrism::templateExtends).map(tm -> this.toTypeElement((TypeMirror)tm)).findFirst().orElse(null);
        List modelInterfaces = prisms.stream().map(JStacheInterfacesPrism::modelImplements).flatMap(faces -> faces.stream()).toList();
        for (TypeMirror mi : modelInterfaces) {
            if (JavaLanguageModel.getInstance().isSubtype(element.asType(), mi)) continue;
            throw new AnnotatedException(element, "per package declaration of @io.jstach.jstache.JStacheInterfaces model required to implement " + mi.toString());
        }
        return new InterfacesConfig(templateInterfaces, templateAnnotions, extendsElement);
    }

    private <T> Stream<@NonNull T> findPrisms(TypeElement element, Function<Element, @Nullable T> prismSupplier) {
        return this.findPrisms(this.expandUsing(GenerateRendererProcessor.enclosing(element)), prismSupplier);
    }

    private <T> Stream<T> findPrisms(Stream<? extends Element> elements, Function<Element, @Nullable T> prismSupplier) {
        return elements.filter(e -> e != null).map(prismSupplier).flatMap(p -> Stream.ofNullable(p));
    }

    private static Stream<Element> enclosing(final Element e) {
        Spliterators.AbstractSpliterator<Element> split = new Spliterators.AbstractSpliterator<Element>(Long.MAX_VALUE, 16){
            @Nullable Element current;
            {
                super(est, additionalCharacteristics);
                this.current = e;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Element> action) {
                Element c = this.current;
                if (c == null) {
                    return false;
                }
                this.current = c.getEnclosingElement();
                action.accept(c);
                return true;
            }
        };
        return StreamSupport.stream(split, false);
    }

    private Stream<Element> expandUsing(Stream<Element> e) {
        return e.flatMap(this::expandUsing);
    }

    private Stream<Element> expandUsing(Element e) {
        DeclaredType dt;
        Element element;
        JStacheConfigPrism config = JStacheConfigPrism.getInstanceOn(e);
        if (config == null) {
            return Stream.of(e);
        }
        TypeMirror using = config.using();
        if (!using.toString().equals(Void.TYPE.getCanonicalName()) && using instanceof DeclaredType && (element = (dt = (DeclaredType)using).asElement()) instanceof TypeElement) {
            TypeElement te = (TypeElement)element;
            return Stream.of(e, te);
        }
        return Stream.of(e);
    }

    private Map<String, NamedTemplate> resolvePartials(TypeElement element) {
        LinkedHashMap<String, NamedTemplate> paths = new LinkedHashMap<String, NamedTemplate>();
        List<JStachePartialsPrism> prisms = this.findPrisms(element, JStachePartialsPrism::getInstanceOn).toList();
        for (JStachePartialsPrism prism : prisms) {
            List<JStachePartialPrism> tps = prism.value();
            for (JStachePartialPrism tp : tps) {
                String path = tp.path();
                String name = tp.name();
                assert (name != null);
                String template = tp.template();
                NamedTemplate nt = GenerateRendererProcessor.resolveNamedTemplate(name, path, template, element, prism.mirror);
                paths.putIfAbsent(name, nt);
            }
        }
        return paths;
    }

    private static NamedTemplate resolveNamedTemplate(String name, @Nullable String path, @Nullable String template, TypeElement element, AnnotationMirror annotationMirror) {
        assert (name != null);
        Record nt = path != null && !path.isBlank() ? new NamedTemplate.FileTemplate(name, path, element, annotationMirror) : (template != null && !template.isEmpty() ? new NamedTemplate.InlineTemplate(name, template, element, annotationMirror) : new NamedTemplate.FileTemplate(name, name, element, annotationMirror));
        return nt;
    }

    private Set<Prisms.Flag> resolveFlags(Map<String, String> options, @Nullable TypeElement element) {
        EnumSet<Prisms.Flag> flags = EnumSet.noneOf(Prisms.Flag.class);
        Stream.ofNullable(element).flatMap(e -> this.findPrisms((TypeElement)e, JStacheFlagsPrism::getInstanceOn)).filter(p -> !this.isFlagsUnspecified((JStacheFlagsPrism)p)).limit(1L).flatMap(p -> p.flags().stream()).map(Prisms.Flag::valueOf).forEach(flags::add);
        for (Map.Entry<String, String> e2 : options.entrySet()) {
            @Nullable Prisms.Flag flag = processorOptionNames.get(e2.getKey());
            if (flag == null) continue;
            if (Boolean.parseBoolean(e2.getValue())) {
                flags.add(flag);
                continue;
            }
            flags.remove((Object)flag);
        }
        return Collections.unmodifiableSet(flags);
    }

    boolean isFlagsUnspecified(JStacheFlagsPrism prism) {
        for (String f : prism.flags()) {
            if (!Prisms.Flag.UNSPECIFIED.name().equals(f)) continue;
            return true;
        }
        return false;
    }

    private String resolveNullableAnnotation(TypeElement element) {
        String defaultNullableName = Inherited.class.getName();
        @Nullable Object annotation = this.findPrisms(element, JStacheFlagsPrism::getInstanceOn).map(p -> p.nullableAnnotation().toString()).filter(tm -> !tm.equals(defaultNullableName)).findFirst().orElse(null);
        annotation = annotation == null ? "/* @Nullable */" : "@" + (String)annotation;
        return annotation;
    }

    TypeElement toTypeElement(TypeMirror tm) {
        Element e = ((DeclaredType)tm).asElement();
        return (TypeElement)e;
    }

    private String getTypeName(TypeMirror tm) {
        TypeElement te = this.toTypeElement(tm);
        return te.getQualifiedName().toString();
    }

    private String getTypeName(TypeMirror tm, TypeElement modelElement) {
        DeclaredType dt = (DeclaredType)tm;
        Element e = dt.asElement();
        TypeElement te = (TypeElement)e;
        String name = te.getQualifiedName().toString();
        List<? extends TypeParameterElement> tas = te.getTypeParameters();
        if (tas.isEmpty()) {
            return name;
        }
        if (tas.size() == 1) {
            return name + "<" + modelElement.getQualifiedName().toString() + ">";
        }
        return name;
    }

    private FormatterTypes resolveFormatterTypes(TypeElement element, @Nullable TypeElement formatterElement) {
        List<JStacheFormatterTypesPrism> prisms = this.findPrisms(element, JStacheFormatterTypesPrism::getInstanceOn).toList();
        List classNames = prisms.stream().flatMap(p -> p.types().stream()).map(tm -> this.getTypeName((TypeMirror)tm)).collect(Collectors.toCollection(ArrayList::new));
        List patterns = prisms.stream().flatMap(p -> p.patterns().stream()).collect(Collectors.toCollection(ArrayList::new));
        Stream<Object> formatterSupers = formatterElement == null ? Stream.empty() : JavaLanguageModel.getInstance().supers(formatterElement);
        List<JStacheFormatterTypesPrism> formatterTypesOnFormatter = this.findPrisms(formatterSupers, JStacheFormatterTypesPrism::getInstanceOn).toList();
        classNames.addAll(formatterTypesOnFormatter.stream().flatMap(p -> p.types().stream()).map(tm -> this.getTypeName((TypeMirror)tm)).toList());
        patterns.addAll(formatterTypesOnFormatter.stream().flatMap(p -> p.patterns().stream()).toList());
        if (classNames.isEmpty() && patterns.isEmpty()) {
            return FormatterTypes.acceptOnlyKnownTypes();
        }
        return new FormatterTypes.ConfiguredFormatterTypes(classNames, patterns);
    }

    private RendererModel model(TypeElement element, JStachePrism jstache, Map<String, String> options) throws DeclarationException, AnnotatedException, DeclarationException {
        if (!element.getTypeParameters().isEmpty()) {
            throw new DeclarationException("Can't generate renderer for class with type variables: " + element.getQualifiedName());
        }
        JStachePrism gp = jstache;
        FormatterTypes.FormatCallType formatCallType = this.resolveFormatCallType(element);
        Charset charset = this.resolveCharset(element);
        @Nullable TypeElement contentTypeElement = this.resolveContentType(element);
        if (contentTypeElement == null && formatCallType != FormatterTypes.FormatCallType.STACHE) {
            throw new AnnotatedException(element, "Content Type provider class is missing which usually is a classpath issue or the JStache type was supposed to be zero dep (JStacheType.STACHE)");
        }
        @Nullable TypeElement formatterElement = this.resolveFormatter(element);
        if (formatterElement == null && formatCallType != FormatterTypes.FormatCallType.STACHE) {
            throw new AnnotatedException(element, "Formatter provider class is missing which usually is a classpath issue or the JStache type was supposed to be zero dep (JStacheType.STACHE)");
        }
        AnnotationMirror annotationMirror = gp.mirror;
        String path = gp.path();
        ProcessingConfig.PathConfig pathConfig = this.resolvePathConfig(element);
        String template = gp.template();
        assert (template != null);
        InterfacesConfig ifaces = this.resolveBaseInterfaces(element);
        ClassRef rendererClassRef = this.resolveRendererClassRef(element, gp);
        FormatterTypes formatterTypes = this.resolveFormatterTypes(element, formatterElement);
        Map<String, NamedTemplate> partials = this.resolvePartials(element);
        Set<Prisms.Flag> flags = this.resolveFlags(options, element);
        String nullableAnnotation = this.resolveNullableAnnotation(element);
        RendererModel model = new RendererModel(formatCallType, element, annotationMirror, rendererClassRef, path, pathConfig, template, charset, Optional.ofNullable(contentTypeElement), formatterTypes, Optional.ofNullable(formatterElement), partials, ifaces, nullableAnnotation, flags, options);
        return model;
    }

    private FormatterTypes.FormatCallType resolveFormatCallType(TypeElement element) {
        Prisms.JStacheType type = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).map(config -> Prisms.JStacheType.valueOf(config.type())).filter(t -> !Prisms.JStacheType.UNSPECIFIED.equals(t)).findFirst().orElseGet(() -> Prisms.JStacheType.UNSPECIFIED);
        FormatterTypes.FormatCallType formatCallType = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Prisms.JStacheType.UNSPECIFIED -> FormatterTypes.FormatCallType.JSTACHIO;
            case Prisms.JStacheType.STACHE -> FormatterTypes.FormatCallType.STACHE;
            case Prisms.JStacheType.JSTACHIO -> FormatterTypes.FormatCallType.JSTACHIO;
        };
        return formatCallType;
    }

    private Charset resolveCharset(TypeElement element) {
        @Nullable String cs = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).map(config -> config.charset()).filter(c -> !c.isBlank()).findFirst().orElse(null);
        cs = cs == null ? "" : cs;
        Charset charset = cs.isBlank() ? StandardCharsets.UTF_8 : Charset.forName(cs);
        return charset;
    }

    private ClassRef resolveRendererClassRef(TypeElement element, JStachePrism gp) {
        String rendererClassSimpleName = this.resolveAdapterName(element, gp);
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(element);
        assert (packageElement != null);
        ClassRef rendererClassRef = ClassRef.of(packageElement, rendererClassSimpleName);
        return rendererClassRef;
    }

    private @Nullable TypeElement resolveContentType(TypeElement element) throws DeclarationException {
        Throwables.SneakyFunction f;
        JavaLanguageModel lm = JavaLanguageModel.getInstance();
        TypeElement autoContentTypeElement = lm.getElements().getTypeElement("io.jstach.jstache.JStacheContentType.UnspecifiedContentType");
        Stream<TypeMirror> contentTypeProviderTypes = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).map(p -> p.contentType());
        @Nullable TypeElement contentTypeProviderElement = contentTypeProviderTypes.map(f = this::contentTypeElement).filter(e -> !lm.isSameType(autoContentTypeElement.asType(), e.asType())).findFirst().orElse(null);
        if (contentTypeProviderElement == null) {
            contentTypeProviderElement = lm.getElements().getTypeElement("io.jstach.jstachio.escapers.Html");
        }
        return contentTypeProviderElement;
    }

    private @Nullable TypeElement resolveFormatter(TypeElement element) throws DeclarationException {
        Throwables.SneakyFunction f;
        JavaLanguageModel lm = JavaLanguageModel.getInstance();
        TypeElement autoFormatElement = lm.getElements().getTypeElement("io.jstach.jstache.JStacheFormatter.UnspecifiedFormatter");
        Stream<TypeMirror> formatterProviderTypes = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).map(p -> p.formatter());
        @Nullable TypeElement formatterProviderElement = formatterProviderTypes.map(f = this::formatterElement).filter(e -> !lm.isSameType(autoFormatElement.asType(), e.asType())).findFirst().orElse(null);
        if (formatterProviderElement == null) {
            formatterProviderElement = lm.getElements().getTypeElement("io.jstach.jstachio.formatters.DefaultFormatter");
        }
        return formatterProviderElement;
    }

    private TypeElement formatterElement(TypeMirror templateFormatType) throws DeclarationException {
        TypeElement formatElement = null;
        if (!(templateFormatType instanceof DeclaredType)) {
            throw new ClassCastException("Expecting DeclaredType for formatter " + templateFormatType);
        }
        DeclaredType dt = (DeclaredType)templateFormatType;
        formatElement = (TypeElement)dt.asElement();
        JStacheFormatterPrism formatterPrism = JStacheFormatterPrism.getInstanceOn(formatElement);
        if (formatterPrism == null) {
            throw new DeclarationException(formatElement.getQualifiedName() + " class is used as a formatter, but not marked with io.jstach.jstache.JStacheFormatter annotation");
        }
        return formatElement;
    }

    private TypeElement contentTypeElement(TypeMirror templateContentType) throws DeclarationException {
        TypeElement contentTypeElement = null;
        if (!(templateContentType instanceof DeclaredType)) {
            throw new ClassCastException("Expecting DeclaredType for content type " + templateContentType);
        }
        DeclaredType dt = (DeclaredType)templateContentType;
        contentTypeElement = (TypeElement)dt.asElement();
        JStacheContentTypePrism formatterPrism = JStacheContentTypePrism.getInstanceOn(contentTypeElement);
        if (formatterPrism == null) {
            throw new DeclarationException(contentTypeElement.getQualifiedName() + " class is used as a contentType, but not marked with io.jstach.jstache.JStacheContentType annotation");
        }
        return contentTypeElement;
    }

    private String resolveAdapterName(TypeElement element, JStachePrism gp) {
        Object adapterClassSimpleName;
        String directiveAdapterName = gp.name();
        if (directiveAdapterName.isBlank()) {
            JStacheConfigPrism.JStacheName name = this.findPrisms(element, JStacheConfigPrism::getInstanceOn).flatMap(config -> config.naming().stream()).findFirst().orElse(null);
            String prefix = name == null ? "*" : name.prefix();
            String suffix = name == null ? "*" : name.suffix();
            prefix = prefix.equals("*") ? "" : prefix;
            suffix = suffix.equals("*") ? "Renderer" : suffix;
            ClassRef ref = ClassRef.of(element);
            adapterClassSimpleName = prefix + ref.getSimpleName() + suffix;
        } else {
            adapterClassSimpleName = directiveAdapterName;
        }
        return adapterClassSimpleName;
    }

    private @Nullable JStacheRef writeRenderableAdapterClass(TypeElement element, JStachePrism jstache, Map<String, String> options) throws AnnotatedException {
        LoggingSupport config = null;
        try {
            RendererModel model = this.model(element, jstache, options);
            config = model;
            StringBuilder stringWriter = new StringBuilder();
            CodeAppendable.StringCodeAppendable codeAppendable = new CodeAppendable.StringCodeAppendable(stringWriter);
            TextFileObject templateResource = new TextFileObject((ProcessingConfig)config, Objects.requireNonNull(this.processingEnv));
            JavaLanguageModel javaModel = JavaLanguageModel.getInstance();
            RenderingCodeGenerator codeGenerator = RenderingCodeGenerator.createInstance(javaModel, model.formatterTypes(), model.formatCallType());
            CodeWriter codeWriter = new CodeWriter(codeAppendable, codeGenerator, model.partials(), (ProcessingConfig)config);
            TemplateClassWriter writer = new TemplateClassWriter(codeWriter, templateResource, model.formatCallType());
            writer.writeRenderableAdapterClass(model);
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(model.rendererClassRef().requireCanonicalName(), element);
            try (OutputStream stream = sourceFile.openOutputStream();
                 OutputStreamWriter outputWriter = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
                ((Writer)outputWriter).append(stringWriter.toString());
            }
            boolean pub = element.getModifiers().contains((Object)Modifier.PUBLIC);
            boolean jstachio = switch (model.formatCallType()) {
                default -> throw new IncompatibleClassChangeError();
                case FormatterTypes.FormatCallType.JSTACHIO -> true;
                case FormatterTypes.FormatCallType.STACHE -> false;
                case FormatterTypes.FormatCallType.JSTACHIO_BYTE -> throw new IllegalStateException();
            };
            return new JStacheRef(model.rendererClassRef(), pub, jstachio);
        }
        catch (ProcessingException ex) {
            if (config != null) {
                config.debug(ex);
            }
            String errorMessage = GenerateRendererProcessor.formatErrorMessage(ex.position(), ex.getMessage());
            this.errors.add(ElementMessage.of(element, errorMessage));
        }
        catch (DeclarationException ex) {
            this.errors.add(ElementMessage.of(element, ex.toString()));
        }
        catch (IOException ex) {
            this.errors.add(ElementMessage.of(element, Throwables.render(ex)));
        }
        catch (RuntimeException ex) {
            this.errors.add(ElementMessage.of(element, Throwables.render(ex)));
        }
        return null;
    }

    static {
        LinkedHashMap<CallSite, Prisms.Flag> m = new LinkedHashMap<CallSite, Prisms.Flag>();
        for (Prisms.Flag f : Prisms.Flag.values()) {
            String name1 = "jstache." + f.name().toLowerCase(Locale.ENGLISH);
            String name2 = "jstache." + f.name();
            m.put((CallSite)((Object)name1), f);
            m.put((CallSite)((Object)name2), f);
        }
        processorOptionNames = Map.copyOf(m);
    }

    private static enum GradleIncremental {
        isolating,
        aggregating,
        disable;

    }

    record CatalogRef(JStacheCatalogPrism prism, ClassRef classRef, Element element) {
        EnumSet<Prisms.CatalogFlag> flags() {
            EnumSet<Prisms.CatalogFlag> flags = EnumSet.noneOf(Prisms.CatalogFlag.class);
            flags.addAll(this.prism.flags().stream().map(f -> Prisms.CatalogFlag.valueOf(f)).toList());
            return flags;
        }

        LoggingSupport.MessagerLogging logging() {
            return new LoggingSupport.AdHocMessager("[JSTACHIO CATALOG] ", false, this.element, this.prism.mirror);
        }
    }

    record JStacheRef(ClassRef classRef, boolean pub, boolean jstachio) {
    }

    record InterfacesConfig(List<String> templateInterfaces, List<String> templateAnnotations, @Nullable TypeElement extendsElement) {
    }

    record RendererModel(FormatterTypes.FormatCallType formatCallType, TypeElement element, AnnotationMirror annotationMirror, ClassRef rendererClassRef, String path, ProcessingConfig.PathConfig pathConfig, String template, Charset charset, Optional<TypeElement> contentTypeElement, FormatterTypes formatterTypes, Optional<TypeElement> formatterTypeElement, Map<String, NamedTemplate> partials, InterfacesConfig ifaces, String nullableAnnotation, Set<Prisms.Flag> flags, Map<String, String> options) implements ProcessingConfig
    {
        public NamedTemplate namedTemplate() {
            Object name;
            Object path = this.path();
            String template = null;
            if (!((String)path).isBlank()) {
                name = path;
            } else if (!this.template().isEmpty()) {
                name = this.element.getQualifiedName().toString() + "#template";
                template = this.template();
            } else {
                PackageElement pe = JavaLanguageModel.getInstance().getElements().getPackageOf(this.element);
                String folder = pe == null ? "" : pe.getQualifiedName().toString().replace('.', '/');
                Object object = path = folder.isEmpty() ? this.element.getQualifiedName().toString() : folder + "/" + this.element.getSimpleName();
                if (this.pathConfig.suffixUnspecified()) {
                    path = (String)path + ".mustache";
                }
                name = path;
            }
            return GenerateRendererProcessor.resolveNamedTemplate((String)name, (String)path, template, this.element, this.annotationMirror);
        }

        @Override
        public List<String> resourcesPaths() {
            String path = this.options.get("jstache.resourcesPath");
            if (path != null) {
                return Stream.of(path.split(",")).filter(p -> !p.isBlank()).toList();
            }
            return List.of();
        }

        @Override
        public boolean fallbackToFilesystem() {
            String path = this.options.get("jstache.resourcesPath");
            return path == null || !path.isBlank();
        }

        @Override
        public @Nullable AnnotationMirror annotationToLog() {
            return null;
        }

        @Override
        public TypeElement elementToLog() {
            return this.element;
        }

        @Override
        public Messager messager() {
            return JavaLanguageModel.getInstance().getMessager();
        }
    }
}

