/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.NamedReader;
import io.jstach.apt.Section;
import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.Position;
import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import io.jstach.apt.internal.token.MustacheTagKind;
import io.jstach.apt.internal.token.MustacheTokenizer;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

class PartialParameterProcessor
implements TokenProcessor<PositionedToken<MustacheToken>>,
LoggingSupport.LoggingSupplier {
    private final String partialName;
    private final LoggingSupport logging;
    private final Map<String, Block> blocks = new LinkedHashMap<String, Block>();
    private Position position;
    private final Deque<Section<Integer>> sectionStack;
    private boolean done = false;
    private final StringBuilder endContent = new StringBuilder();
    private final List<PositionedToken<MustacheToken>> endTokens = new ArrayList<PositionedToken<MustacheToken>>();

    PartialParameterProcessor(String partialName, LoggingSupport logging) {
        this.partialName = partialName;
        this.position = Position.noPosition();
        this.logging = logging;
        this.sectionStack = new ArrayDeque<Section<Integer>>();
    }

    public Map<String, Block> getBlocks() {
        return this.blocks;
    }

    public String getEndContent() {
        return this.endContent.toString();
    }

    @Override
    public void debug(CharSequence message) {
        this.logging().debug("[parameter_processor] " + message);
    }

    public List<PositionedToken<MustacheToken>> getEndTokens() {
        return this.endTokens;
    }

    public void run(NamedReader reader) throws ProcessingException, IOException {
        int readResult;
        TokenProcessor<@Nullable Character> processor = MustacheTokenizer.createInstance(reader.name(), this);
        while (!this.done && (readResult = reader.read()) >= 0) {
            try {
                processor.processToken(Character.valueOf((char)readResult));
            }
            catch (ProcessingException e) {
                this.debug(e);
                throw e;
            }
        }
        if (!this.done) {
            throw new ProcessingException(this.position, "parent partial was never closed and reached end of file. parent = " + this.partialName);
        }
    }

    public ProcessorState process(PositionedToken<MustacheToken> token) throws ProcessingException {
        this.processToken(token);
        if (this.done) {
            return ProcessorState.DONE;
        }
        return ProcessorState.PROCESSING;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void processToken(PositionedToken<MustacheToken> token) throws ProcessingException {
        MustacheToken mt = token.innerToken();
        if (this.isDebug()) {
            this.debug("token : " + mt);
        }
        this.position = token.position();
        if (this.done) {
            this.debug("Add end content token: " + mt);
            mt.appendRawText(this.endContent);
            this.endTokens.add(token);
            return;
        }
        int depth = this.sectionStack.size();
        if (depth < 1) {
            MustacheToken.TagToken tt;
            if (mt instanceof MustacheToken.TagToken && (tt = (MustacheToken.TagToken)mt).tagKind() == MustacheTagKind.BEGIN_PARENT_SECTION) {
                Section<Integer> beginSection = new Section<Integer>(tt, this.position, depth);
                this.sectionStack.push(beginSection);
                return;
            }
            throw new IllegalStateException("bug expected begin parent as first token: " + token);
        }
        @Nullable Block currentBlock = this.currentBlock();
        Section<Integer> closedSection = null;
        if (mt instanceof MustacheToken.TagToken) {
            MustacheToken.TagToken tt = (MustacheToken.TagToken)mt;
            String name = tt.name();
            if (tt.tagKind().isBeginSection()) {
                Section<Integer> beginSection = new Section<Integer>(tt, this.position, depth);
                this.sectionStack.push(beginSection);
                if (tt.tagKind() == MustacheTagKind.BEGIN_BLOCK_SECTION && depth == 1) {
                    if (this.blocks.containsKey(name)) {
                        String error = "Duplicate block: " + name;
                        this.debug(error);
                        throw new ProcessingException(this.position, error);
                    }
                    if (currentBlock == null) {
                        this.debug("registering block: " + name);
                        this.blocks.put(name, new Block(beginSection, new ArrayList<PositionedToken<MustacheToken>>()));
                        return;
                    }
                }
            } else if (tt.tagKind().isEndSection()) {
                if (!this.isCurrentSection(tt.name())) {
                    this.debug("sectionStack " + this.sectionStack);
                    String error = "Unexpected end section: \"" + name + "\" expecting: \"" + this.currentSection().name() + "\"";
                    this.debug(error);
                    throw new ProcessingException(this.position, error);
                }
                closedSection = this.sectionStack.pop();
                if (this.sectionStack.isEmpty()) {
                    this.done = true;
                    return;
                }
            }
        }
        if (currentBlock != null && !Objects.equals(closedSection, currentBlock.section())) {
            currentBlock.tokens().add(token);
        }
    }

    private @Nullable Block currentBlock() {
        Iterator<Section<Integer>> it = this.sectionStack.descendingIterator();
        it.next();
        if (!it.hasNext()) {
            return null;
        }
        Section<Integer> maybeBlock = it.next();
        if (maybeBlock.isBlock()) {
            Block block = this.blocks.get(maybeBlock.name());
            if (block == null) {
                throw new IllegalStateException("bug expected block to be registered");
            }
            return block;
        }
        return null;
    }

    private Section<Integer> currentSection() {
        Section<Integer> current = this.sectionStack.peek();
        if (current == null) {
            throw new IllegalStateException("section stack is empty");
        }
        return current;
    }

    private boolean isCurrentSection(String name) {
        return this.currentSection().name().equals(name);
    }

    @Override
    public LoggingSupport logging() {
        return this.logging;
    }

    static enum ProcessorState {
        PROCESSING,
        DONE;


        public boolean isDone() {
            return this == DONE;
        }
    }

    record Block(Section<Integer> section, List<PositionedToken<MustacheToken>> tokens) {
        void appentRaw(StringBuilder sb) {
            for (PositionedToken<MustacheToken> t : this.tokens) {
                t.innerToken().appendRawText(sb);
            }
        }

        public String content() {
            StringBuilder sb = new StringBuilder();
            this.appentRaw(sb);
            return sb.toString();
        }

        public String name() {
            return this.section.token().name();
        }
    }
}

