/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.CodeWriter;
import io.jstach.apt.GenerateRendererProcessor;
import io.jstach.apt.TextFileObject;
import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.CodeAppendable;
import io.jstach.apt.internal.FormatterTypes;
import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.NamedTemplate;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.TemplateCompilerContext;
import io.jstach.apt.internal.context.VariableContext;
import io.jstach.apt.internal.util.ClassRef;
import io.jstach.apt.internal.util.EclipseNonNull;
import io.jstach.apt.internal.util.ToStringTypeVisitor;
import io.jstach.apt.prism.JStacheContentTypePrism;
import io.jstach.apt.prism.JStacheFormatterPrism;
import io.jstach.apt.prism.Prisms;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class TemplateClassWriter
implements LoggingSupport.LoggingSupplier {
    private final CodeWriter codeWriter;
    private final TextFileObject templateLoader;
    private final FormatterTypes.FormatCallType formatCallType;
    final String idt = "\n        ";
    final String _F_Escaper = Function.class.getName() + "<String, String>";
    final String _Appendable = Appendable.class.getName();
    final String _Output = "io.jstach.jstachio.Output";
    final String _OutputStream = OutputStream.class.getName();
    final String _Charset = Charset.class.getName();
    final String _ContextNode = "io.jstach.jstachio.context.ContextNode";
    private static final Map<Charset, String> STANDARD_CHARSETS = Map.of(StandardCharsets.UTF_8, StandardCharsets.class.getName() + ".UTF_8", StandardCharsets.ISO_8859_1, StandardCharsets.class.getName() + ".ISO_8859_1", StandardCharsets.US_ASCII, StandardCharsets.class.getName() + ".US_ASCII", StandardCharsets.UTF_16, StandardCharsets.class.getName() + ".UTF_16", StandardCharsets.UTF_16BE, StandardCharsets.class.getName() + ".UTF_16BE", StandardCharsets.UTF_16LE, StandardCharsets.class.getName() + ".UTF_16LE");

    TemplateClassWriter(CodeWriter compilerManager, TextFileObject templateLoader, FormatterTypes.FormatCallType formatCallType) {
        this.codeWriter = compilerManager;
        this.templateLoader = templateLoader;
        this.formatCallType = formatCallType;
    }

    @Override
    public LoggingSupport logging() {
        return this.codeWriter.getConfig();
    }

    void println(String s) {
        this.codeWriter.println(s);
    }

    void writeRenderableAdapterClass(GenerateRendererProcessor.RendererModel model) throws IOException, ProcessingException, AnnotatedException {
        String templatePath;
        boolean jstachio = this.formatCallType == FormatterTypes.FormatCallType.JSTACHIO;
        TypeElement element = EclipseNonNull.castNonNull(model.element());
        Optional<TypeElement> contentTypeElement = EclipseNonNull.castNonNull(model.contentTypeElement());
        Optional<TypeElement> formatterTypeElement = EclipseNonNull.castNonNull(model.formatterTypeElement());
        GenerateRendererProcessor.InterfacesConfig ifaces = EclipseNonNull.castNonNull(model.ifaces());
        ClassRef renderClassRef = model.rendererClassRef();
        ClassRef modelClassRef = ClassRef.of(element);
        String className = modelClassRef.getCanonicalName();
        if (className == null) {
            throw new AnnotatedException(element, "Anonymous classes can not be used as models");
        }
        String packageName = modelClassRef.getPackageName();
        Optional<JStacheContentTypePrism> contentTypePrism = contentTypeElement.map(JStacheContentTypePrism::getInstanceOn);
        Optional<JStacheFormatterPrism> formatterPrism = formatterTypeElement.map(JStacheFormatterPrism::getInstanceOn);
        boolean preEncode = !model.flags().contains((Object)Prisms.Flag.PRE_ENCODE_DISABLE);
        boolean contextSupport = !model.flags().contains((Object)Prisms.Flag.CONTEXT_SUPPORT_DISABLE);
        ArrayList<Object> interfaces = new ArrayList<Object>();
        if (jstachio) {
            if (preEncode) {
                interfaces.add("io.jstach.jstachio.Template.EncodedTemplate<" + className + ">");
            } else {
                interfaces.add("io.jstach.jstachio.Template<" + className + ">");
            }
            if (contextSupport) {
                interfaces.add("io.jstach.jstachio.context.ContextTemplate<" + className + ">");
            }
            interfaces.add("io.jstach.jstachio.spi.TemplateProvider");
            interfaces.add("io.jstach.jstachio.spi.JStachioFilter.FilterChain");
        }
        interfaces.addAll(EclipseNonNull.castNonNullList(ifaces.templateInterfaces()));
        String implementsString = interfaces.stream().collect(Collectors.joining(",\n    "));
        String rendererAnnotated = ifaces.templateAnnotations().stream().map(ta -> "@" + ta).collect(Collectors.joining("\n"));
        Object rendererImplements = implementsString.isBlank() ? "" : " implements " + implementsString;
        Object rendererExtends = "";
        TypeElement extendsElement = ifaces.extendsElement();
        Set<GeneratedMethod> generatedMethods = Set.of();
        if (extendsElement != null && !Object.class.getName().equals(extendsElement.getQualifiedName().toString())) {
            String name = extendsElement.getQualifiedName().toString();
            Object extendsDeclare = name;
            if (extendsElement.getTypeParameters().size() == 1) {
                extendsDeclare = name + "<" + className + ">";
            }
            rendererExtends = " extends " + (String)extendsDeclare;
            generatedMethods = GeneratedMethod.find(extendsElement).keySet();
        }
        String modifier = element.getModifiers().contains((Object)Modifier.PUBLIC) ? "public " : "";
        String rendererClassSimpleName = renderClassRef.getSimpleName();
        NamedTemplate namedTemplate = model.namedTemplate();
        String templateName = (String)(packageName.isEmpty() ? "" : packageName + ".") + rendererClassSimpleName;
        try {
            templatePath = model.pathConfig().resolveTemplatePath(model.namedTemplate()).toString();
        }
        catch (URISyntaxException e) {
            throw new AnnotatedException("Template path \"" + model.namedTemplate().path() + "\" is not a valid URI: " + e.getMessage(), element);
        }
        String templateString = namedTemplate.template();
        String templateCharsetCode = TemplateClassWriter.resolveCharsetCode(model.charset());
        String templateStringJava = CodeAppendable.stringConcat(templateString);
        String _Appender = "io.jstach.jstachio.Appender";
        String nullable = model.nullableAnnotation() + " ";
        String _F_Formatter = Function.class.getName() + "<" + nullable + "Object, String>";
        String nullable_F_Formatter = this.nullMarkClassRef(Function.class.getName(), nullable) + "<" + nullable + "Object, String>";
        String nullable_F_Escaper = this.nullMarkClassRef(this._F_Escaper, nullable);
        Object _Formatter = jstachio ? "io.jstach.jstachio.Formatter" : _F_Formatter;
        String _Escaper = jstachio ? "io.jstach.jstachio.Escaper" : this._F_Escaper;
        String _EncodedOutput = "<A extends io.jstach.jstachio.Output.EncodedOutput<E>, E extends Exception>";
        String _A = "<A extends io.jstach.jstachio.Output<E>, E extends Exception>";
        String templateFormatterExp = GeneratedMethod.templateFormatter.gen(generatedMethods) ? "this.formatter" : "templateFormatter()";
        String templateEscaperExp = GeneratedMethod.templateEscaper.gen(generatedMethods) ? "this.escaper" : "templateEscaper()";
        String templateAppenderExp = "templateAppender()";
        this.println("package " + packageName + ";");
        this.println("");
        this.println("/**");
        this.println(" * Generated Renderer.");
        this.println(" */");
        this.println("// @javax.annotation.Generated(\"" + GenerateRendererProcessor.class.getName() + "\")");
        if (!rendererAnnotated.isBlank()) {
            this.println(rendererAnnotated);
        }
        this.println(modifier + "class " + rendererClassSimpleName + (String)rendererExtends + (String)rendererImplements + " {");
        this.println("    /**");
        this.println("     * Template path.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    public static final String TEMPLATE_PATH = \"" + templatePath + "\";");
        this.println("");
        this.println("    /**");
        this.println("     * Inline template string copied.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("");
        this.println("    public static final String TEMPLATE_STRING = " + templateStringJava + ";");
        this.println("");
        this.println("    /**");
        this.println("     * Template name. Do not rely on this.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    public static final String TEMPLATE_NAME = \"" + templateName + "\";");
        this.println("");
        this.println("    /**");
        this.println("     * Template charset.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    public static final " + this._Charset + " TEMPLATE_CHARSET = " + templateCharsetCode + ";");
        this.println("");
        if (jstachio) {
            String templateMediaType = contentTypePrism.orElseThrow().mediaType();
            this.println("    /**");
            this.println("     * Template mediaType.");
            this.println("     * @hidden");
            this.println("     */");
            this.println("    public static final String TEMPLATE_MEDIA_TYPE = \"" + templateMediaType + "\";");
            this.println("");
        }
        this.println("    /**");
        this.println("     * The models class. Use {@link #modelClass()} instead.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    public static final Class<?> MODEL_CLASS = " + className + ".class;");
        this.println("");
        this.println("    /**");
        this.println("     * The instance. Use {@link {@link #of()} instead.");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    private static final " + rendererClassSimpleName + " INSTANCE = new " + rendererClassSimpleName + "();");
        this.println("");
        this.println("    /**");
        this.println("     * Formatter. ");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    private final " + (String)_Formatter + " formatter;");
        this.println("");
        this.println("    /**");
        this.println("     * Escaper. ");
        this.println("     * @hidden");
        this.println("     */");
        this.println("    private final " + _Escaper + " escaper;");
        this.println("");
        this.println("    /**");
        this.println("     * Renderer constructor for manual wiring.");
        this.println("     * @param formatter formatter if null the static formatter will be used.");
        this.println("     * @param escaper escaper if null the static escaper will be used");
        this.println("     */");
        this.println("    public " + rendererClassSimpleName + "(");
        this.println("        " + nullable_F_Formatter + " formatter,");
        this.println("        " + nullable_F_Escaper + " escaper) {");
        this.println("        super();");
        this.println("        this.formatter = __formatter(formatter);");
        this.println("        this.escaper = __escaper(escaper);");
        this.println("    }");
        this.println("");
        if (jstachio) {
            String formatterProvideCall = formatterTypeElement.orElseThrow().getQualifiedName() + "." + formatterPrism.orElseThrow().providesMethod() + "()";
            this.println("    private static " + (String)_Formatter + " __formatter(" + nullable_F_Formatter + " formatter) {");
            this.println("        return " + (String)_Formatter + ".of(formatter != null ? formatter : " + formatterProvideCall + ");");
            this.println("    }");
        } else {
            this.println("    private static " + _F_Formatter + " __formatter(" + nullable_F_Formatter + " formatter) {");
            this.println("        return formatter != null ? formatter : (i -> i.toString());");
            this.println("    }");
        }
        this.println("");
        if (jstachio) {
            String contentTypeProvideCall = contentTypeElement.orElseThrow().getQualifiedName() + "." + contentTypePrism.orElseThrow().providesMethod() + "()";
            this.println("    private static " + _Escaper + " __escaper(" + nullable_F_Escaper + " escaper) {");
            this.println("        return " + _Escaper + ".of(escaper != null ? escaper : " + contentTypeProvideCall + ");");
            this.println("    }");
        } else {
            this.println("    private static " + this._F_Escaper + " __escaper(" + nullable_F_Escaper + " escaper) {");
            this.println("        return escaper != null ? escaper : (i -> i);");
            this.println("    }");
        }
        this.println("");
        this.println("    /**");
        this.println("     * Renderer constructor for reflection (use of() instead).");
        this.println("     * For programmatic consider using {@link #of()} for a shared singleton.");
        this.println("     */");
        this.println("    public " + rendererClassSimpleName + "() {");
        this.println("        this(null, null);");
        this.println("    }");
        this.println("");
        if (!jstachio && GeneratedMethod.execute.gen(generatedMethods)) {
            this.println("    /**");
            this.println("     * Renders the passed in model.");
            this.println("     * @param model a model assumed never to be <code>null</code>.");
            this.println("     * @param a the appendable to write to.");
            this.println("     * @throws java.io.IOException if there is an error writing to the appendable");
            this.println("     */");
            this.println("    public void execute(" + className + " model, Appendable a) throws java.io.IOException {");
            this.println("        execute(model, a, " + templateFormatterExp + ", " + templateEscaperExp + ");");
            this.println("    }");
            this.println("");
        }
        if (!jstachio) {
            this.println("    /**");
            this.println("     * Convenience method that directly renders the model as a String.");
            this.println("     * @param model never null.");
            this.println("     * @return the rendered model.");
            this.println("     */");
            this.println("    public String execute(" + className + " model) {");
            this.println("        StringBuilder sb = new StringBuilder();");
            this.println("        try {");
            this.println("            execute(model, sb);");
            this.println("        }");
            this.println("        catch(java.io.IOException e) {");
            this.println("            throw new java.io.UncheckedIOException(e);");
            this.println("        }");
            this.println("        return sb.toString();");
            this.println("    }");
            this.println("");
        }
        if (jstachio && GeneratedMethod.execute.gen(generatedMethods)) {
            this.println("    @Override");
            this.println("    public StringBuilder execute(" + className + " model, StringBuilder sb) {");
            this.println("        render(model, io.jstach.jstachio.Output.of(sb), " + templateFormatterExp + ", " + templateEscaperExp + ", " + templateAppenderExp + ");");
            this.println("        return sb;");
            this.println("    }");
            this.println("");
        }
        if (jstachio) {
            this.println("    @Override");
            this.println("    public " + _A + " A execute(\n        " + className + " model, \n        A a) throws E {");
            this.println("        render(model, a, " + templateFormatterExp + ", " + templateEscaperExp + ", " + templateAppenderExp + ");");
            this.println("        return a;");
            this.println("    }");
            this.println("");
            this.println("    /**");
            this.println("     * Renders the passed in model.");
            this.println("     * @param <A> appendable type.");
            this.println("     * @param <E> error type.");
            this.println("     * @param model a model assumed never to be <code>null</code>.");
            this.println("     * @param a appendable to write to.");
            this.println("     * @param formatter formats variables before they are passed to the escaper");
            this.println("     * @param escaper used to write escaped variables");
            this.println("     * @throws E if an error occurs while writing to the appendable");
            this.println("     */");
            this.println("    protected " + _A + " void execute(\n        " + className + " model, \n        A a, \n        " + (String)_Formatter + " formatter,\n        " + _Escaper + " escaper) throws E {");
            this.println("        render(model, a, formatter, escaper, templateAppender());");
            this.println("    }");
            this.println("");
        } else {
            this.println("    /**");
            this.println("     * Renders the passed in model.");
            this.println("     * @param model a model assumed never to be <code>null</code>.");
            this.println("     * @param a appendable to write to.");
            this.println("     * @param formatter formats variables before they are passed to the escaper");
            this.println("     * @param escaper used to write escaped variables");
            this.println("     * @throws java.io.IOException if an error occurs while writing to the appendable");
            this.println("     */");
            this.println("    protected void execute(\n        " + className + " model, \n        " + this._Appendable + " a, \n        " + (String)_Formatter + " formatter,\n        " + _Escaper + " escaper) throws java.io.IOException {");
            this.println("        render(model, a, formatter, escaper);");
            this.println("    }");
            this.println("");
        }
        if (jstachio && preEncode) {
            this.println("    @Override");
            this.println("    public " + _EncodedOutput + " A write(\n        " + className + " model, \n        A outputStream) throws E {");
            this.println("        encode(model, outputStream, " + templateFormatterExp + ", " + templateEscaperExp + ", " + templateAppenderExp + ");");
            this.println("        return outputStream;");
            this.println("    }");
            this.println("");
        }
        if (jstachio && contextSupport) {
            this.println("    @Override");
            this.println("    public " + _A + " A execute(\n        " + className + " model, \n        io.jstach.jstachio.context.ContextNode context, \n        A a) throws E {");
            this.println("        render(this, model, context, a, " + templateFormatterExp + ", " + templateEscaperExp + ", " + templateAppenderExp + ");");
            this.println("        return a;");
            this.println("    }");
            this.println("");
        }
        if (jstachio && preEncode && contextSupport) {
            this.println("    @Override");
            this.println("    public " + _EncodedOutput + " A write(\n        " + className + " model, \n        io.jstach.jstachio.context.ContextNode context, \n        A outputStream) throws E {");
            this.println("        encode(this, model, context, outputStream, " + templateFormatterExp + ", " + templateEscaperExp + ", " + templateAppenderExp + ");");
            this.println("        return outputStream;");
            this.println("    }");
            this.println("");
        }
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * If this template support the model class");
            this.println("     * @param type model class.");
            this.println("     * @return true if the renderer supports the class");
            this.println("     */");
        }
        this.println("    public boolean supportsType(Class<?> type) {");
        this.println("        return MODEL_CLASS.isAssignableFrom(type);");
        this.println("    }");
        this.println("");
        if (jstachio) {
            this.println("    /**");
            this.println("     * Needed for jstachio runtime.");
            this.println("     * @hidden");
            this.println("     */");
            this.println("    @Override");
            this.println("    public java.util.List<io.jstach.jstachio.Template<?>> provideTemplates(io.jstach.jstachio.TemplateConfig templateConfig ) {");
            this.println("        return java.util.List.of(io.jstach.jstachio.TemplateConfig.empty() == templateConfig ? INSTANCE :  new " + rendererClassSimpleName + "(templateConfig));");
            this.println("    }");
            this.println("");
        }
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Template path.");
            this.println("     * @return template path of resource or pseudo inline path");
            this.println("     */");
        }
        this.println("    public String templatePath() {");
        this.println("        return TEMPLATE_PATH;");
        this.println("    }");
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Logical template name.");
            this.println("     * @return template name");
            this.println("     */");
        }
        this.println("    public String templateName() {");
        this.println("        return TEMPLATE_NAME;");
        this.println("    }");
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Template charset name.");
            this.println("     * @return charset name of template");
            this.println("     */");
        }
        this.println("    public " + this._Charset + " templateCharset() {");
        this.println("        return TEMPLATE_CHARSET;");
        this.println("    }");
        if (jstachio) {
            this.println("    @Override");
            this.println("    public String templateMediaType() {");
            this.println("        return TEMPLATE_MEDIA_TYPE;");
            this.println("    }");
        }
        if (jstachio) {
            this.println("    @Override");
        } else {
            this.println("    /**");
            this.println("     * Template contents or blank if path.");
            this.println("     * @return inline template");
            this.println("     */");
        }
        this.println("    public String templateString() {");
        this.println("        return TEMPLATE_STRING;");
        this.println("    }");
        if (jstachio) {
            this.println("    @Override");
            this.println("    public Class<?> templateContentType() {");
            this.println("        return " + contentTypeElement.orElseThrow().getQualifiedName() + ".class;");
            this.println("    }");
        }
        if (GeneratedMethod.templateEscaper.gen(generatedMethods)) {
            if (jstachio) {
                this.println("    @Override");
            } else {
                this.println("    /**");
                this.println("     * Current escaper.");
                this.println("     * @return escaper");
                this.println("     */");
            }
            this.println("    public  " + _Escaper + " templateEscaper() {");
            this.println("        return this.escaper;");
            this.println("    }");
            this.println("");
        }
        if (GeneratedMethod.templateFormatter.gen(generatedMethods)) {
            if (jstachio) {
                this.println("    @Override");
            } else {
                this.println("    /**");
                this.println("     * Current formatter.");
                this.println("     * @return formatter");
                this.println("     */");
            }
            this.println("    public " + (String)_Formatter + " templateFormatter() {");
            this.println("        return this.formatter;");
            this.println("    }");
            this.println("");
        }
        if (jstachio) {
            this.println("    /**");
            this.println("     * Appender.");
            this.println("     * @return appender for writing unescaped variables.");
            this.println("     */");
            this.println("    public " + _Appender + " templateAppender() {");
            this.println("        return io.jstach.jstachio.Appender.defaultAppender();");
            this.println("    }");
            this.println("");
        }
        this.println("    /**");
        this.println("     * Model class.");
        this.println("     * @return class used as model (annotated with JStache).");
        this.println("     */");
        if (jstachio) {
            this.println("    @Override");
        }
        this.println("    public Class<?> modelClass() {");
        this.println("        return MODEL_CLASS;");
        this.println("    }");
        this.println("");
        if (jstachio) {
            this.println("    /**");
            this.println("     * Needed for jstachio runtime.");
            this.println("     * @hidden");
            this.println("     */");
            this.println("    @Override");
            this.println("    public void process(Object model, io.jstach.jstachio.Output<?> appendable) throws java.lang.Exception {");
            this.println("        execute( (" + className + ") model, appendable);");
            this.println("    }");
            this.println("");
            this.println("    /**");
            this.println("     * Needed for jstachio runtime.");
            this.println("     * @hidden");
            this.println("     */");
            this.println("    @Override");
            this.println("    public boolean isBroken(Object model) {");
            this.println("        return !supportsType(model.getClass());");
            this.println("    }");
            this.println("");
            this.println("    /**");
            this.println("     * Renderer constructor using config.");
            this.println("     * @param templateConfig config that has collaborators");
            this.println("     */");
            this.println("    public " + rendererClassSimpleName + "(io.jstach.jstachio.TemplateConfig templateConfig) {");
            this.println("        this(templateConfig.formatter(), templateConfig.escaper());");
            this.println("    }");
            this.println("");
        }
        this.println("    /**");
        this.println("     * Convience static factory that will reuse the same singleton instance.");
        this.println("     * @return renderer same as calling no-arg constructor but is cached with singleton instance");
        this.println("     */");
        this.println("    public static " + rendererClassSimpleName + " of() {");
        this.println("        return INSTANCE;");
        this.println("    }");
        this.println("");
        this.writeExtendsConstructors(extendsElement, rendererClassSimpleName);
        this.writeRendererDefinitionMethod(model);
        if (preEncode) {
            this.writeRendererDefinitionMethodStream(model);
        }
        this.println("}");
    }

    private void writeExtendsConstructors(@Nullable TypeElement extendsElement, String rendererClassSimpleName) {
        if (extendsElement == null) {
            return;
        }
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(extendsElement.getEnclosedElements()).stream().filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.FINAL) && !e.getParameters().isEmpty()).toList();
        for (ExecutableElement c : constructors) {
            this.writeConstructor(rendererClassSimpleName, c);
        }
    }

    private void writeConstructor(String rendererClassSimpleName, ExecutableElement c) {
        StringBuilder sig = new StringBuilder();
        StringBuilder _super = new StringBuilder();
        sig.append("public ").append(rendererClassSimpleName).append("(");
        _super.append("super(");
        boolean first = true;
        for (VariableElement variableElement : c.getParameters()) {
            if (!first) {
                sig.append(", ");
                _super.append(", ");
            } else {
                first = false;
            }
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                EnumSet<ElementType> targets = this.annotationTargets(annotationMirror);
                if (!targets.contains((Object)ElementType.PARAMETER)) continue;
                sig.append(annotationMirror.toString()).append(" ");
            }
            sig.append(ToStringTypeVisitor.toCodeSafeString(variableElement.asType()));
            sig.append(" ");
            sig.append(variableElement.getSimpleName());
            _super.append(variableElement.getSimpleName());
        }
        sig.append(")");
        _super.append(");");
        this.println("");
        for (AnnotationMirror annotationMirror : c.getAnnotationMirrors()) {
            this.println("    " + annotationMirror);
        }
        this.println("    " + sig.toString() + " {");
        this.println("        " + _super.toString());
        this.println("        this.formatter = __formatter(null);");
        this.println("        this.escaper = __escaper(null);");
        this.println("    }");
        this.println("");
    }

    EnumSet<ElementType> annotationTargets(AnnotationMirror anno) {
        Target target = anno.getAnnotationType().getAnnotation(Target.class);
        if (target == null) {
            return EnumSet.allOf(ElementType.class);
        }
        @NonNull ElementType[] ets = EclipseNonNull.castNonNullArray(target.value());
        EnumSet<ElementType> t = EnumSet.noneOf(ElementType.class);
        for (ElementType et : ets) {
            t.add(et);
        }
        if (t.isEmpty()) {
            t = EnumSet.allOf(ElementType.class);
        }
        return t;
    }

    String nullMarkClassRef(String className, String nullable) {
        int idx = className.lastIndexOf(".");
        if (idx > 0) {
            String pkg = className.substring(0, idx + 1);
            String cname = className.substring(idx + 1);
            return pkg + nullable + cname;
        }
        return nullable + className;
    }

    private void writeRendererDefinitionMethod(GenerateRendererProcessor.RendererModel model) throws IOException, ProcessingException, AnnotatedException {
        boolean jstachio = this.formatCallType == FormatterTypes.FormatCallType.JSTACHIO;
        TypeElement element = model.element();
        VariableContext.NullChecking nullChecking = this.nullChecking(model);
        VariableContext variables = VariableContext.createDefaultContext(nullChecking);
        String dataName = variables.introduceNewNameLike("data");
        String className = element.getQualifiedName().toString();
        if (jstachio) {
            this.jstachioRenderMethodHead(variables, dataName, className, model);
        } else {
            this.stacheRenderMethodHead(variables, dataName, className, model);
        }
        TemplateCompilerContext context = this.codeWriter.createTemplateContext(model.namedTemplate(), element, dataName, variables, model.flags());
        this.codeWriter.compileTemplate(this.templateLoader, context);
        this.println("");
        this.println("    }");
    }

    private void stacheRenderMethodHead(VariableContext variables, String dataName, String className, GenerateRendererProcessor.RendererModel model) {
        String nullable = model.nullableAnnotation() + " ";
        String _F_Formatter = Function.class.getName() + "<" + nullable + "Object, String>";
        String _Escaper = this._F_Escaper;
        String _Formatter = _F_Formatter;
        this.println("    /**");
        this.println("     * Renders the passed in model.");
        this.println("     * @param " + dataName + " model");
        this.println("     * @param " + variables.unescapedWriter() + " appendable to write to.");
        this.println("     * @param " + variables.formatter() + " formats variables before they are passed to the escaper.");
        this.println("     * @param " + variables.escaper() + " used to write escaped variables.");
        this.println("     * @throws java.io.IOException if an error occurs while writing to the appendable");
        this.println("     */");
        this.println("    public static  void render(\n        " + className + " " + dataName + ", \n        " + this._Appendable + " " + variables.unescapedWriter() + ",\n        " + _Formatter + " " + variables.formatter() + ",\n        " + _Escaper + " " + variables.escaper() + ") throws java.io.IOException {");
    }

    private void jstachioRenderMethodHead(VariableContext variables, String dataName, String className, GenerateRendererProcessor.RendererModel model) {
        String _Appender;
        String _Escaper = _Appender = "io.jstach.jstachio.Appender";
        String _Formatter = "io.jstach.jstachio.Formatter";
        String _A = "<A extends io.jstach.jstachio.Output<E>, E extends Exception>";
        String _Template = model.rendererClassRef().requireCanonicalName();
        this.println("    /**");
        this.println("     * Renders the passed in model.");
        this.println("     * @param <A> appendable type.");
        this.println("     * @param <E> error type.");
        this.println("     * @param " + dataName + " model");
        this.println("     * @param " + variables.unescapedWriter() + " appendable to write to.");
        this.println("     * @param " + variables.formatter() + " formats variables before they are passed to the escaper.");
        this.println("     * @param " + variables.escaper() + " used to write escaped variables.");
        this.println("     * @param " + variables.appender() + " used to write unescaped variables.");
        this.println("     * @throws E if an error occurs while writing to the appendable");
        this.println("     */");
        this.println("    public static " + _A + " void render(\n        " + className + " " + dataName + ", \n        A " + variables.unescapedWriter() + ",\n        " + _Formatter + " " + variables.formatter() + ",\n        " + _Escaper + " " + variables.escaper() + ",\n        " + _Appender + " " + variables.appender() + ") throws E {");
        this.println("        render(of(), " + dataName + ", " + TemplateClassWriter.renderContextNode(variables, dataName, model) + ", " + variables.unescapedWriter() + ", " + variables.formatter() + ", " + variables.escaper() + ", " + variables.appender() + ");");
        this.println("    }");
        this.println("");
        this.println("    /**");
        this.println("     * Renders the passed in model.");
        this.println("     * @param <A> appendable type.");
        this.println("     * @param <E> error type.");
        this.println("     * @param " + variables.template() + " instance of template.");
        this.println("     * @param " + dataName + " model");
        this.println("     * @param " + variables.context() + " context");
        this.println("     * @param " + variables.unescapedWriter() + " appendable to write to.");
        this.println("     * @param " + variables.formatter() + " formats variables before they are passed to the escaper.");
        this.println("     * @param " + variables.escaper() + " used to write escaped variables.");
        this.println("     * @param " + variables.appender() + " used to write unescaped variables.");
        this.println("     * @throws E if an error occurs while writing to the appendable");
        this.println("     */");
        this.println("    protected static " + _A + " void render(\n        " + _Template + " " + variables.template() + ", \n        " + className + " " + dataName + ", \n        io.jstach.jstachio.context.ContextNode " + variables.context() + ", \n        A " + variables.unescapedWriter() + ",\n        " + _Formatter + " " + variables.formatter() + ",\n        " + _Escaper + " " + variables.escaper() + ",\n        " + _Appender + " " + variables.appender() + ") throws E {");
    }

    private VariableContext.NullChecking nullChecking(GenerateRendererProcessor.RendererModel model) {
        VariableContext.NullChecking nullChecking;
        VariableContext.NullChecking nullChecking2 = nullChecking = model.flags().contains((Object)Prisms.Flag.NO_NULL_CHECKING) ? VariableContext.NullChecking.ANNOTATED : VariableContext.NullChecking.ALWAYS;
        if (this.isDebug() && !nullChecking.isDefault()) {
            this.debug("NullChecking = ", (Object)nullChecking);
        }
        return nullChecking;
    }

    private void writeRendererDefinitionMethodStream(GenerateRendererProcessor.RendererModel model) throws IOException, ProcessingException, AnnotatedException {
        if (this.formatCallType != FormatterTypes.FormatCallType.JSTACHIO) {
            return;
        }
        this.codeWriter.setFormatCallType(FormatterTypes.FormatCallType.JSTACHIO_BYTE);
        TypeElement element = model.element();
        VariableContext.NullChecking nullChecking = this.nullChecking(model);
        VariableContext variables = VariableContext.createDefaultContext(nullChecking);
        String dataName = variables.introduceNewNameLike("data");
        String className = element.getQualifiedName().toString();
        String _Appender = "io.jstach.jstachio.Appender";
        String _Escaper = "io.jstach.jstachio.Escaper";
        String _Formatter = "io.jstach.jstachio.Formatter";
        String _OutputStream = "<A extends io.jstach.jstachio.Output.EncodedOutput<E>, E extends Exception>";
        String _Template = model.rendererClassRef().requireCanonicalName();
        this.println("");
        this.println("    /**");
        this.println("     * Renders to an OutputStream use pre-encoded parts of the template.");
        this.println("     * @param <A> output type.");
        this.println("     * @param <E> error type.");
        this.println("     * @param " + dataName + " model");
        this.println("     * @param " + variables.unescapedWriter() + " stream to write to.");
        this.println("     * @param " + variables.formatter() + " formats variables before they are passed to the escaper.");
        this.println("     * @param " + variables.escaper() + " used to write escaped variables.");
        this.println("     * @param " + variables.appender() + " used to write unescaped variables.");
        this.println("     * @throws E if an error occurs while writing to the appendable");
        this.println("     */");
        this.println("    protected static " + _OutputStream + " void encode(\n        " + className + " " + dataName + ", \n        A " + variables.unescapedWriter() + ",\n        " + _Formatter + " " + variables.formatter() + ",\n        " + _Escaper + " " + variables.escaper() + ",\n        " + _Appender + " " + variables.appender() + ") throws E {");
        this.println("        encode(of(), " + dataName + ", " + TemplateClassWriter.renderContextNode(variables, dataName, model) + ", " + variables.unescapedWriter() + ", " + variables.formatter() + ", " + variables.escaper() + ", " + variables.appender() + ");");
        this.println("    }");
        this.println("");
        this.println("    /**");
        this.println("     * Renders to an OutputStream use pre-encoded parts of the template.");
        this.println("     * @param <A> output type.");
        this.println("     * @param <E> error type.");
        this.println("     * @param " + variables.template() + " instance of template.");
        this.println("     * @param " + dataName + " model");
        this.println("     * @param " + variables.context() + " context");
        this.println("     * @param " + variables.unescapedWriter() + " stream to write to.");
        this.println("     * @param " + variables.formatter() + " formats variables before they are passed to the escaper.");
        this.println("     * @param " + variables.escaper() + " used to write escaped variables.");
        this.println("     * @param " + variables.appender() + " used to write unescaped variables.");
        this.println("     * @throws E if an error occurs while writing to the appendable");
        this.println("     */");
        this.println("    protected static " + _OutputStream + " void encode(\n        " + _Template + " " + variables.template() + ", \n        " + className + " " + dataName + ", \n        io.jstach.jstachio.context.ContextNode " + variables.context() + ", \n        A " + variables.unescapedWriter() + ",\n        " + _Formatter + " " + variables.formatter() + ",\n        " + _Escaper + " " + variables.escaper() + ",\n        " + _Appender + " " + variables.appender() + ") throws E {");
        TemplateCompilerContext context = this.codeWriter.createTemplateContext(model.namedTemplate(), element, dataName, variables, model.flags());
        this.codeWriter.compileTemplate(this.templateLoader, context);
        this.println("");
        this.println("    }");
        List<Map.Entry<String, String>> textVariables = variables.textVariables();
        for (Map.Entry<String, String> entry : textVariables) {
            this.println("    private static final byte[] " + entry.getKey() + " = (" + entry.getValue() + ").getBytes(TEMPLATE_CHARSET);");
        }
        this.codeWriter.setFormatCallType(this.formatCallType);
    }

    private static String renderContextNode(VariableContext variables, String dataName, GenerateRendererProcessor.RendererModel model) {
        boolean enabled = !model.flags().contains((Object)Prisms.Flag.CONTEXT_SUPPORT_DISABLE);
        return TemplateClassWriter.renderContextNode(variables, dataName, enabled);
    }

    private static String renderContextNode(VariableContext variables, String dataName, boolean enabled) {
        Object contextCreator = enabled ? "io.jstach.jstachio.context.ContextNode.resolve(" + dataName + "," + variables.unescapedWriter() + ")" : "io.jstach.jstachio.context.ContextNode.empty()";
        return contextCreator;
    }

    static String resolveCharsetCode(Charset charset) {
        String ref = STANDARD_CHARSETS.get(charset);
        if (ref != null) {
            return ref;
        }
        return Charset.class.getName() + ".forName(\"" + charset.name() + "\")";
    }

    static enum GeneratedMethod {
        execute,
        templateFormatter,
        templateEscaper;


        static EnumMap<GeneratedMethod, ExecutableElement> find(TypeElement parentClass) {
            Elements es = JavaLanguageModel.getInstance().getElements();
            EnumMap<GeneratedMethod, ExecutableElement> em = new EnumMap<GeneratedMethod, ExecutableElement>(GeneratedMethod.class);
            for (ExecutableElement ee : ElementFilter.methodsIn(es.getAllMembers(parentClass))) {
                for (GeneratedMethod m : GeneratedMethod.values()) {
                    if (!m.isMatch(ee)) continue;
                    em.put(m, ee);
                }
            }
            return em;
        }

        public boolean gen(Set<GeneratedMethod> gm) {
            return !gm.contains((Object)this);
        }

        public boolean isMatch(ExecutableElement e) {
            int parameters;
            JavaLanguageModel jlm = JavaLanguageModel.getInstance();
            if (!this.name().equals(e.getSimpleName().toString()) || !e.getModifiers().contains((Object)Modifier.PUBLIC) || e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return false;
            }
            TypeMirror appendable = jlm.getElements().getTypeElement(Appendable.class.getName()).asType();
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case execute: {
                    int n = 2;
                    break;
                }
                case templateFormatter: 
                case templateEscaper: {
                    int n = parameters = 0;
                }
            }
            if (e.getParameters().size() != parameters) {
                return false;
            }
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case execute -> {
                    if (e.getReturnType().getKind() == TypeKind.VOID && jlm.isSameType(e.getParameters().get(1).asType(), appendable)) {
                        yield true;
                    }
                    yield false;
                }
                case templateFormatter, templateEscaper -> e.getParameters().isEmpty();
            };
        }
    }
}

