/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.NamedReader;
import io.jstach.apt.PartialParameterProcessor;
import io.jstach.apt.internal.CodeAppendable;
import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.util.ClassRef;
import io.jstach.apt.prism.Prisms;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

interface TemplateCompilerLike
extends AutoCloseable {
    public void run() throws ProcessingException, IOException;

    @Override
    public void close() throws IOException;

    public TemplateCompilerType getCompilerType();

    public LoggingSupport logging();

    public String getTemplateName();

    public ClassRef getModelClass();

    public @Nullable TemplateCompilerLike getCaller();

    public TemplateLoader getTemplateLoader();

    public CodeAppendable getWriter();

    public Set<Prisms.Flag> flags();

    public @Nullable ParameterPartial currentParameterPartial();

    public ParameterPartial createParameterPartial(String var1) throws ProcessingException, IOException;

    public static class ParameterPartial
    extends AbstractPartial {
        private final PartialParameterProcessor processor;
        private boolean ran;

        public ParameterPartial(TemplateCompilerLike templateCompiler, PartialParameterProcessor processor) {
            super(templateCompiler);
            this.processor = processor;
        }

        public PartialParameterProcessor getProcessor() {
            return this.processor;
        }

        @Override
        void run() throws ProcessingException, IOException {
            if (this.ran) {
                throw new IllegalStateException("Already ran");
            }
            this.ran = true;
            super.run();
        }
    }

    public static class Partial
    extends AbstractPartial {
        public Partial(TemplateCompilerLike templateCompiler) {
            super(templateCompiler);
        }

        public String toString() {
            return "Partial(template = " + this.getTemplateName() + ")";
        }
    }

    public static abstract class AbstractPartial
    implements AutoCloseable {
        protected final TemplateCompilerLike templateCompiler;

        public AbstractPartial(TemplateCompilerLike templateCompiler) {
            this.templateCompiler = templateCompiler;
        }

        public String getTemplateName() {
            return this.templateCompiler.getTemplateName();
        }

        void run() throws ProcessingException, IOException {
            this.templateCompiler.run();
        }

        @Override
        public void close() throws IOException {
            this.templateCompiler.close();
        }
    }

    public static interface TemplateLoader {
        public NamedReader open(String var1) throws IOException;
    }

    public static enum TemplateCompilerType {
        SIMPLE,
        LAMBDA,
        PARTIAL_TEMPLATE,
        PARAM_PARTIAL_TEMPLATE;

    }

    public static interface ChildTemplateCompiler
    extends TemplateCompilerLike {
        @Override
        public TemplateCompilerLike getCaller();

        @Override
        default public TemplateLoader getTemplateLoader() {
            return this.getCaller().getTemplateLoader();
        }

        @Override
        default public CodeAppendable getWriter() {
            return this.getCaller().getWriter();
        }

        @Override
        default public Set<Prisms.Flag> flags() {
            return this.getCaller().flags();
        }

        @Override
        default public ClassRef getModelClass() {
            return Objects.requireNonNull(this.getCaller()).getModelClass();
        }
    }
}

