/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.MustacheTokenProcessor;
import io.jstach.apt.internal.Position;
import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

abstract class WhitespaceTokenProcessor
implements MustacheTokenProcessor,
LoggingSupport.LoggingSupplier {
    private Deque<PositionedToken<MustacheToken>> previousTokens = new ArrayDeque<PositionedToken<MustacheToken>>(5);
    protected boolean atStartOfLine = true;
    protected @Nullable PositionedToken<MustacheToken> currentToken = null;
    protected @Nullable PositionedToken<MustacheToken> lastProcessedToken = null;
    protected Position position = Position.noPosition();
    protected String partialIndent = "";

    WhitespaceTokenProcessor() {
    }

    @Override
    public final void processToken(PositionedToken<MustacheToken> positionedToken) throws ProcessingException {
        List<PositionedToken<MustacheToken>> tokens = this.filter(positionedToken);
        for (PositionedToken<MustacheToken> t : tokens) {
            this.previousTokens.offer(t);
            this.processTokens();
        }
    }

    protected List<PositionedToken<MustacheToken>> filter(PositionedToken<MustacheToken> positionedToken) throws ProcessingException {
        return List.of(positionedToken);
    }

    private void processTokens() throws ProcessingException {
        boolean eof = this.previousTokens.stream().filter((? super T t) -> ((MustacheToken)t.innerToken()).isEOF()).findFirst().isPresent();
        if (eof && !this.previousTokens.getLast().innerToken().isEOF()) {
            throw new IllegalStateException(this.previousTokens.toString());
        }
        ArrayDeque<PositionedToken<MustacheToken>> buf = new ArrayDeque<PositionedToken<MustacheToken>>();
        do {
            buf.clear();
            int size = this.previousTokens.size();
            if (size == 1 && eof) {
                this._processToken(this.previousTokens.pop());
                return;
            }
            if (size < 2 && !eof) {
                return;
            }
            PositionedToken<MustacheToken> firstToken = this.previousTokens.pop();
            PositionedToken<MustacheToken> secondToken = this.previousTokens.pop();
            buf.offerLast(firstToken);
            buf.offerLast(secondToken);
            if (this.atStartOfLine && !firstToken.innerToken().isNewlineToken() && !firstToken.innerToken().isWhitespaceToken() && secondToken.innerToken().isStandaloneToken()) {
                this.processTokenGroup(ProcessToken.of(firstToken), ProcessToken.of(secondToken));
                this.atStartOfLine = false;
                continue;
            }
            if (this.atStartOfLine && firstToken.innerToken().isStandaloneToken() && secondToken.innerToken().isNewlineOrEOF()) {
                this.debug("2 standalone condition: {{#some section}} [ newline ]");
                this.processTokenGroup(ProcessToken.of(firstToken), ProcessToken.ignore(secondToken));
                this.atStartOfLine = true;
                continue;
            }
            if (this.atStartOfLine && size >= 3) {
                PositionedToken<MustacheToken> thirdToken = this.previousTokens.pop();
                buf.add(thirdToken);
                if (firstToken.innerToken().isStandaloneToken() && secondToken.innerToken().isWhitespaceToken() && thirdToken.innerToken().isNewlineOrEOF()) {
                    this.debug("3 standalone condition: {{#some section}} [white space] [ newline ]");
                    this.processTokenGroup(ProcessToken.of(firstToken), ProcessToken.ignore(secondToken), ProcessToken.ignore(thirdToken));
                    this.atStartOfLine = true;
                    continue;
                }
                if (firstToken.innerToken().isWhitespaceToken() && secondToken.innerToken().isStandaloneToken() && thirdToken.innerToken().isNewlineOrEOF()) {
                    this.debug("3 standalone condition: [white space] {{#some section}} [ newline ]");
                    this.processTokenGroup(ProcessToken.indent(firstToken), ProcessToken.of(secondToken), ProcessToken.ignore(thirdToken));
                    this.atStartOfLine = true;
                    continue;
                }
                if (size >= 4) {
                    PositionedToken<MustacheToken> fourthToken = this.previousTokens.pop();
                    buf.add(fourthToken);
                    if (firstToken.innerToken().isWhitespaceToken() && secondToken.innerToken().isStandaloneToken() && thirdToken.innerToken().isWhitespaceToken() && fourthToken.innerToken().isNewlineOrEOF()) {
                        this.debug("4 standalone condition: [white space] {{#some section}} [white space] [ newline ]");
                        this.processTokenGroup(ProcessToken.indent(firstToken), ProcessToken.of(secondToken), ProcessToken.ignore(thirdToken), ProcessToken.ignore(fourthToken));
                        this.atStartOfLine = true;
                        continue;
                    }
                }
            }
            buf.descendingIterator().forEachRemaining(this.previousTokens::offerFirst);
            if (eof && !this.previousTokens.isEmpty()) {
                this.processTokenGroup(ProcessToken.of(this.previousTokens.pop()));
                continue;
            }
            if (this.previousTokens.size() <= 5) continue;
            this.processTokenGroup(ProcessToken.of(this.previousTokens.pop()));
        } while (eof && !this.previousTokens.isEmpty());
    }

    protected void processTokenGroup(ProcessToken ... tokens) throws ProcessingException {
        this.processTokenGroup(List.of(tokens));
    }

    protected void processTokenGroup(List<ProcessToken> tokens) throws ProcessingException {
        this.processTokenGroup(this::_processToken, tokens);
    }

    protected void processTokenGroup(MustacheTokenProcessor processor, List<ProcessToken> tokens) throws ProcessingException {
        Iterator<ProcessToken> it = tokens.iterator();
        while (it.hasNext()) {
            ProcessToken token = it.next();
            switch (token.hint()) {
                case IGNORE: {
                    break;
                }
                case INDENT: {
                    ProcessToken nextToken = it.next();
                    this._processIndentToken(processor, token.token(), nextToken.token());
                    break;
                }
                case NORMAL: 
                case EOF: {
                    processor.processToken(token.token());
                }
            }
        }
    }

    protected void beforeProcessToken(PositionedToken<MustacheToken> positionedToken) {
        this.position = positionedToken.position();
        this.currentToken = positionedToken;
    }

    protected void afterProcessToken(PositionedToken<MustacheToken> positionedToken) {
        this.atStartOfLine = positionedToken.innerToken().isNewlineOrEOF();
        this.lastProcessedToken = positionedToken;
    }

    protected final void _processToken(PositionedToken<MustacheToken> positionedToken) throws ProcessingException {
        this.beforeProcessToken(positionedToken);
        this.handleToken(positionedToken);
        this.afterProcessToken(positionedToken);
    }

    protected abstract void handleToken(PositionedToken<MustacheToken> var1) throws ProcessingException;

    protected void _processIndentToken(MustacheTokenProcessor processor, PositionedToken<MustacheToken> whitespace, PositionedToken<MustacheToken> positionedToken) throws ProcessingException {
        if (positionedToken.innerToken().isIndented()) {
            MustacheToken mustacheToken = whitespace.innerToken();
            if (mustacheToken instanceof MustacheToken.TextToken) {
                MustacheToken.TextToken tt = (MustacheToken.TextToken)mustacheToken;
                if (this.isDebug()) {
                    this.debug("Setting indent. whitespace: " + tt + " standalone: " + positionedToken.innerToken());
                }
                this.partialIndent = tt.text();
            } else {
                throw new IllegalStateException("whitespace token is wrong");
            }
        }
        processor.processToken(positionedToken);
    }

    protected record ProcessToken(PositionedToken<MustacheToken> token, ProcessHint hint) {
        static ProcessToken ignore(PositionedToken<MustacheToken> token) {
            if (token.innerToken().isEOF()) {
                return new ProcessToken(token, ProcessHint.EOF);
            }
            return new ProcessToken(token, ProcessHint.IGNORE);
        }

        static ProcessToken of(PositionedToken<MustacheToken> token) {
            if (token.innerToken().isEOF()) {
                return new ProcessToken(token, ProcessHint.EOF);
            }
            return new ProcessToken(token, ProcessHint.NORMAL);
        }

        static ProcessToken indent(PositionedToken<MustacheToken> token) {
            if (token.innerToken().isEOF()) {
                return new ProcessToken(token, ProcessHint.EOF);
            }
            return new ProcessToken(token, ProcessHint.INDENT);
        }

        protected static enum ProcessHint {
            IGNORE,
            INDENT,
            NORMAL,
            EOF;

        }
    }
}

