/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal;

import io.jstach.apt.internal.context.JavaLanguageModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public interface FormatterTypes {
    public boolean isMatch(String var1);

    public static FormatterTypes acceptOnlyKnownTypes() {
        return new FormatterTypes(){

            @Override
            public boolean isMatch(String className) {
                return false;
            }
        };
    }

    public static enum FormatCallType {
        STACHE,
        JSTACHIO,
        JSTACHIO_BYTE;

    }

    public static class ConfiguredFormatterTypes
    implements FormatterTypes {
        private final Set<String> classNames;
        private final Set<DeclaredType> ifaces;
        private final List<Pattern> patterns;

        public ConfiguredFormatterTypes(Collection<String> classNames, List<String> classPatterns) {
            this.classNames = Set.copyOf(classNames);
            HashSet<DeclaredType> ifaces = new HashSet<DeclaredType>();
            for (String c : classNames) {
                TypeMirror tm;
                Elements elements = JavaLanguageModel.getInstance().getElements();
                TypeElement te = elements.getTypeElement(c);
                if (te == null || !((tm = te.asType()) instanceof DeclaredType)) continue;
                DeclaredType dt = (DeclaredType)tm;
                ifaces.add(dt);
            }
            this.ifaces = Set.copyOf(ifaces);
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String p : classPatterns) {
                patterns.add(Pattern.compile(p));
            }
            this.patterns = List.copyOf(patterns);
        }

        public boolean isMatch(DeclaredType dt) {
            TypeMirror erasedDt = JavaLanguageModel.getInstance().getTypes().erasure(dt);
            String className = erasedDt.toString();
            boolean match = this.isMatch(className);
            if (match) {
                return true;
            }
            for (DeclaredType iface : this.ifaces) {
                match = JavaLanguageModel.getInstance().isSubtype(dt, iface);
                if (!match) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isMatch(String className) {
            if (this.classNames.isEmpty() && this.patterns.isEmpty() || this.classNames.contains(className)) {
                return true;
            }
            for (Pattern p : this.patterns) {
                if (!p.matcher(className).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

