/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal;

import io.jstach.apt.internal.token.Delimiters;
import io.jstach.apt.internal.token.MustacheTagKind;
import java.io.IOException;
import java.io.UncheckedIOException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MustacheToken {
    default public boolean isWhitespaceToken() {
        return MustacheToken.isWhitespace(this);
    }

    default public boolean isTagToken() {
        return false;
    }

    default public boolean isSectionToken() {
        return false;
    }

    default public boolean isSectionEndToken(String name) {
        return false;
    }

    default public boolean isStandaloneToken() {
        return false;
    }

    default public boolean isNewlineToken() {
        return false;
    }

    default public boolean isNewlineOrEOF() {
        return this.isNewlineToken() || this.isEOF();
    }

    default public boolean isEOF() {
        return this instanceof EndOfFileToken;
    }

    default public boolean isIndented() {
        return false;
    }

    public void appendRawText(Appendable var1) throws IOException;

    default public void appendRawText(StringBuilder sb) {
        try {
            this.appendRawText((Appendable)sb);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public void appendEscapedJava(StringBuilder sb) {
        this.appendRawText(sb);
    }

    public static boolean isWhitespace(MustacheToken token) {
        if (token instanceof TextToken) {
            TextToken tt = (TextToken)token;
            return tt.text().isBlank();
        }
        return false;
    }

    public <R, E extends Exception> R accept(Visitor<R, E> var1) throws E;

    public record EndOfFileToken() implements MustacheToken
    {
        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return visitor.endOfFile();
        }

        @Override
        public void appendRawText(Appendable a) throws IOException {
        }
    }

    public record TextToken(String text) implements MustacheToken
    {
        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return visitor.text(this.text);
        }

        @Override
        public void appendRawText(Appendable a) throws IOException {
            a.append(this.text);
        }
    }

    public static interface Visitor<R, E extends Exception> {
        public R beginSection(String var1) throws E;

        public R beginInvertedSection(String var1) throws E;

        public R beginParentSection(String var1) throws E;

        public R beginBlockSection(String var1) throws E;

        public R endSection(String var1) throws E;

        public R partial(String var1) throws E;

        public R variable(String var1) throws E;

        public R unescapedVariable(String var1) throws E;

        public R delimiters(Delimiters var1) throws E;

        public R comment(String var1) throws E;

        public R specialCharacter(SpecialChar var1) throws E;

        public R newline(NewlineChar var1) throws E;

        public R text(String var1) throws E;

        public R endOfFile() throws E;
    }

    public static enum SpecialChar {
        QUOTATION_MARK('\"'),
        BACKSLASH('\\');

        private final char character;

        private SpecialChar(char character) {
            this.character = character;
        }

        public char character() {
            return this.character;
        }

        public String javaEscaped() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case QUOTATION_MARK -> "\\\"";
                case BACKSLASH -> "\\\\";
            };
        }
    }

    public static enum NewlineChar {
        LF("\n"),
        CRLF("\r\n");

        private final String characters;

        private NewlineChar(String characters) {
            this.characters = characters;
        }

        public String characters() {
            return this.characters;
        }

        public String javaEscaped() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case LF -> "\\n";
                case CRLF -> "\\r\\n";
            };
        }
    }

    public record NewlineToken(NewlineChar newlineChar) implements MustacheToken
    {
        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return visitor.newline(this.newlineChar);
        }

        @Override
        public boolean isNewlineToken() {
            return true;
        }

        @Override
        public void appendRawText(Appendable a) throws IOException {
            a.append(this.newlineChar.characters());
        }

        @Override
        public void appendEscapedJava(StringBuilder sb) {
            sb.append(this.newlineChar.javaEscaped());
        }
    }

    public record SpecialCharacterToken(SpecialChar specialChar) implements MustacheToken
    {
        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return visitor.specialCharacter(this.specialChar);
        }

        @Override
        public void appendRawText(Appendable a) throws IOException {
            a.append(this.specialChar.character());
        }

        @Override
        public void appendEscapedJava(StringBuilder sb) {
            sb.append(this.specialChar.javaEscaped());
        }
    }

    public record CommentToken(String comment, Delimiters delimiters) implements MustacheToken
    {
        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return visitor.comment(this.comment);
        }

        @Override
        public void appendRawText(Appendable a) throws IOException {
            this.delimiters.appendStart(a);
            a.append("!");
            a.append(this.comment);
            this.delimiters.appendEnd(a);
        }

        @Override
        public boolean isStandaloneToken() {
            return true;
        }
    }

    public record DelimitersToken(Delimiters delimiters, Delimiters nextDelimiters) implements MustacheToken
    {
        @Override
        public void appendRawText(Appendable a) throws IOException {
            this.delimiters.appendStart(a);
            a.append("=");
            this.nextDelimiters.appendStart(a);
            a.append(" ");
            this.nextDelimiters.appendEnd(a);
            a.append("=");
            this.delimiters.appendEnd(a);
        }

        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return visitor.delimiters(this.nextDelimiters);
        }

        @Override
        public boolean isStandaloneToken() {
            return true;
        }
    }

    public record TagToken(MustacheTagKind tagKind, String name, Delimiters delimiters) implements MustacheToken
    {
        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return switch (this.tagKind()) {
                default -> throw new IncompatibleClassChangeError();
                case MustacheTagKind.BEGIN_SECTION -> visitor.beginSection(this.name);
                case MustacheTagKind.BEGIN_BLOCK_SECTION -> visitor.beginBlockSection(this.name);
                case MustacheTagKind.BEGIN_INVERTED_SECTION -> visitor.beginInvertedSection(this.name);
                case MustacheTagKind.BEGIN_PARENT_SECTION -> visitor.beginParentSection(this.name);
                case MustacheTagKind.END_SECTION -> visitor.endSection(this.name);
                case MustacheTagKind.UNESCAPED_VARIABLE_THREE_BRACES -> visitor.unescapedVariable(this.name);
                case MustacheTagKind.UNESCAPED_VARIABLE_TWO_BRACES -> visitor.unescapedVariable(this.name);
                case MustacheTagKind.VARIABLE -> visitor.variable(this.name);
                case MustacheTagKind.PARTIAL -> visitor.partial(this.name);
            };
        }

        @Override
        public boolean isTagToken() {
            return true;
        }

        @Override
        public boolean isSectionToken() {
            return this.tagKind().isSection();
        }

        @Override
        public boolean isSectionEndToken(String name) {
            return this.tagKind().isEndSection() && this.name().equals(name);
        }

        @Override
        public boolean isStandaloneToken() {
            return this.isSectionToken() || this.tagKind == MustacheTagKind.PARTIAL;
        }

        @Override
        public boolean isIndented() {
            return this.tagKind == MustacheTagKind.PARTIAL || this.tagKind == MustacheTagKind.BEGIN_PARENT_SECTION;
        }

        private char sigil() {
            return switch (this.tagKind()) {
                default -> throw new IncompatibleClassChangeError();
                case MustacheTagKind.BEGIN_SECTION -> '#';
                case MustacheTagKind.BEGIN_BLOCK_SECTION -> '$';
                case MustacheTagKind.BEGIN_INVERTED_SECTION -> '^';
                case MustacheTagKind.BEGIN_PARENT_SECTION -> '<';
                case MustacheTagKind.END_SECTION -> '/';
                case MustacheTagKind.PARTIAL -> '>';
                case MustacheTagKind.UNESCAPED_VARIABLE_TWO_BRACES -> '&';
                case MustacheTagKind.UNESCAPED_VARIABLE_THREE_BRACES, MustacheTagKind.VARIABLE -> throw new UnsupportedOperationException("does not have a sigil: " + this.tagKind());
            };
        }

        @Override
        public void appendRawText(Appendable a) throws IOException {
            switch (this.tagKind()) {
                case BEGIN_SECTION: 
                case BEGIN_BLOCK_SECTION: 
                case BEGIN_INVERTED_SECTION: 
                case BEGIN_PARENT_SECTION: 
                case END_SECTION: 
                case UNESCAPED_VARIABLE_TWO_BRACES: 
                case PARTIAL: {
                    this.delimiters.appendStart(a).append(this.sigil()).append(this.name);
                    this.delimiters.appendEnd(a);
                    break;
                }
                case UNESCAPED_VARIABLE_THREE_BRACES: {
                    this.delimiters.appendStartEscape(a).append(this.name);
                    this.delimiters.appendEndEscape(a);
                    break;
                }
                case VARIABLE: {
                    this.delimiters.appendStart(a).append(this.name);
                    this.delimiters.appendEnd(a);
                }
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TagToken[");
            this.appendRawText(sb);
            sb.append(", ");
            sb.append((Object)this.tagKind());
            sb.append("]");
            return sb.toString();
        }
    }
}

