/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface NamedTemplate {
    public String name();

    public Type type();

    public Element element();

    public AnnotationMirror annotationMirror();

    public String path();

    public String template();

    public static final class InlineTemplate
    extends Record
    implements NamedTemplate {
        private final String name;
        private final String template;
        private final TypeElement element;
        private final AnnotationMirror annotationMirror;

        public InlineTemplate(String name, String template, TypeElement element, AnnotationMirror annotationMirror) {
            this.name = name;
            this.template = template;
            this.element = element;
            this.annotationMirror = annotationMirror;
        }

        @Override
        public Type type() {
            return Type.INLINE;
        }

        @Override
        public String path() {
            return "";
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{InlineTemplate.class, "name;template;element;annotationMirror", "name", "template", "element", "annotationMirror"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InlineTemplate.class, "name;template;element;annotationMirror", "name", "template", "element", "annotationMirror"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InlineTemplate.class, "name;template;element;annotationMirror", "name", "template", "element", "annotationMirror"}, this, o);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String template() {
            return this.template;
        }

        @Override
        public TypeElement element() {
            return this.element;
        }

        @Override
        public AnnotationMirror annotationMirror() {
            return this.annotationMirror;
        }
    }

    public record FileTemplate(String name, String path, Element element, AnnotationMirror annotationMirror) implements NamedTemplate
    {
        @Override
        public Type type() {
            return Type.FILE;
        }

        @Override
        public String template() {
            return "";
        }
    }

    public static enum Type {
        FILE,
        INLINE;

    }
}

