/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.BooleanExpressionContext;
import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.VariableContext;
import org.eclipse.jdt.annotation.Nullable;

class BooleanRenderingContext
implements RenderingContext.ChildRenderingContext,
BooleanExpressionContext {
    private final String expression;
    private final RenderingContext parent;

    BooleanRenderingContext(String expression, RenderingContext parent) {
        this.expression = expression;
        this.parent = parent;
    }

    @Override
    public String beginSectionRenderingCode() {
        return this.parent.beginSectionRenderingCode() + "if (" + this.expression + ") { ";
    }

    @Override
    public String endSectionRenderingCode() {
        return " }" + this.parent.endSectionRenderingCode();
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public @Nullable BooleanExpressionContext getParentExpression() {
        RenderingContext renderingContext = this.parent;
        if (renderingContext instanceof BooleanExpressionContext) {
            BooleanExpressionContext be = (BooleanExpressionContext)renderingContext;
            return be;
        }
        return null;
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        return this.parent.get(name);
    }

    @Override
    public JavaExpression currentExpression() {
        return this.parent.currentExpression();
    }

    @Override
    public VariableContext createEnclosedVariableContext() {
        return this.parent.createEnclosedVariableContext();
    }

    @Override
    public RenderingContext getParent() {
        return this.parent;
    }

    @Override
    public String description() {
        return this.toString();
    }

    public String toString() {
        return "BooleanRenderingContext [expression=" + this.expression + "]";
    }
}

