/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.DeclaredTypeRenderingContext;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.RenderingContext;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.eclipse.jdt.annotation.Nullable;

public class EnumRenderingContext
extends DeclaredTypeRenderingContext {
    private final TypeElement enumElement;

    public EnumRenderingContext(JavaExpression expression, TypeElement element, RenderingContext parent) {
        super(expression, element, parent);
        this.enumElement = element;
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        JavaExpression pexp = super.get(name);
        if (pexp != null) {
            return pexp;
        }
        Set<String> names = this.getEnumValues(this.enumElement);
        if (names.contains(name)) {
            JavaExpression exp = this.currentExpression();
            String bexp = this.enumElement.getQualifiedName().toString() + "." + name + " == " + exp.text();
            return exp.model().expression(bexp, exp.model().knownTypes()._boolean);
        }
        return null;
    }

    Set<String> getEnumValues(TypeElement enumTypeElement) {
        return enumTypeElement.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(Object::toString).collect(Collectors.toSet());
    }
}

