/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.BooleanExpressionContext;
import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.InvertedExpressionContext;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.VariableContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class InvertedRenderingContext
implements RenderingContext.ChildRenderingContext,
BooleanExpressionContext {
    private final BooleanExpressionContext parent;
    private final boolean dottedName;

    InvertedRenderingContext(RenderingContext parent, boolean dottedName) {
        this.parent = (BooleanExpressionContext)parent;
        this.dottedName = dottedName;
    }

    @Override
    public String beginSectionRenderingCode() {
        String ifexp;
        String debug = "";
        BooleanExpressionContext e = this.parent;
        if (this.dottedName) {
            List exps = this.nullableExpressions().stream().map(ne -> ne.invertedExpression()).collect(Collectors.toCollection(ArrayList::new));
            exps.add(e.getExpression());
            ifexp = "if (" + exps.stream().collect(Collectors.joining(" || ")) + ") {";
        } else {
            ifexp = "if (" + e.getExpression() + ") {";
        }
        String s = debug + ifexp;
        return s;
    }

    private List<BooleanExpressionContext> booleanExpressions() {
        ArrayList<BooleanExpressionContext> expressions = new ArrayList<BooleanExpressionContext>();
        for (RenderingContext p = this.getParent(); p != null; p = p.getParent()) {
            BooleanExpressionContext be;
            if (!(p instanceof BooleanExpressionContext) || (be = (BooleanExpressionContext)p).getExpression().isBlank()) continue;
            expressions.add(be);
        }
        return expressions;
    }

    private List<InvertedExpressionContext> nullableExpressions() {
        ArrayList<InvertedExpressionContext> expressions = new ArrayList<InvertedExpressionContext>();
        for (RenderingContext p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof InvertedExpressionContext)) continue;
            @NonNull InvertedExpressionContext ne = (InvertedExpressionContext)((Object)p);
            expressions.add(ne);
        }
        Collections.reverse(expressions);
        return expressions;
    }

    @Override
    public String endSectionRenderingCode() {
        return "}";
    }

    @Override
    public String getExpression() {
        return "";
    }

    @Override
    public @Nullable BooleanExpressionContext getParentExpression() {
        return this.parent;
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        return this.parent.get(name);
    }

    @Override
    public JavaExpression currentExpression() {
        return this.parent.currentExpression();
    }

    @Override
    public VariableContext createEnclosedVariableContext() {
        return this.parent.createEnclosedVariableContext();
    }

    @Override
    public RenderingContext getParent() {
        return this.parent;
    }

    @Override
    public String description() {
        return this.toString();
    }

    public String toString() {
        return "InvertedRenderingContext [expression=" + this.booleanExpressions().stream().map(e -> e.getExpression()).collect(Collectors.joining(",")) + "]";
    }
}

