/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.JavaLanguageModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

class JavaExpression {
    private final JavaLanguageModel model;
    private final String text;
    private final TypeMirror type;
    private final List<String> path;

    JavaExpression(JavaLanguageModel model, String text, TypeMirror type, List<String> path) {
        this.model = model;
        this.text = text;
        this.type = type;
        this.path = path;
    }

    String text() {
        return this.text;
    }

    TypeMirror type() {
        return this.type;
    }

    JavaLanguageModel model() {
        return this.model;
    }

    private static List<String> concat(List<String> list, String a) {
        list = new ArrayList<String>(list);
        list.add(a);
        return List.copyOf(list);
    }

    private List<String> concatPath(String a) {
        return JavaExpression.concat(this.path, a);
    }

    public String path() {
        return this.path.stream().collect(Collectors.joining("."));
    }

    JavaExpression arrayLength() {
        return new JavaExpression(this.model, this.text + ".length", this.model.knownTypes()._int.typeMirror(), this.concatPath("length"));
    }

    JavaExpression stringLiteral(String alreadyEscapedString) {
        return new JavaExpression(this.model, alreadyEscapedString, this.model.knownTypes()._String.typeElement().asType(), this.path);
    }

    JavaExpression mapGet(ExecutableElement getMethod, String key) {
        JavaExpression keyExpression = new JavaExpression(this.model, "\"" + key + "\"", this.model.knownTypes()._String.typeElement().asType(), this.concatPath(key));
        return this.methodCall(getMethod, keyExpression);
    }

    JavaExpression optionalOrElseNull(ExecutableElement getMethod) {
        JavaExpression keyExpression = new JavaExpression(this.model, "null", this.model.knownTypes()._String.typeElement().asType(), this.path);
        return this.methodCall(getMethod, keyExpression);
    }

    public JavaExpression subscript(JavaExpression indexExpression) {
        return new JavaExpression(this.model, this.text + "[" + indexExpression.text() + "]", ((ArrayType)this.type).getComponentType(), this.concatPath(indexExpression.text));
    }

    public JavaExpression fieldAccess(Element element) {
        VariableElement fieldElement = (VariableElement)element;
        TypeMirror memberType = this.model.asMemberOf((DeclaredType)this.type, fieldElement);
        return new JavaExpression(this.model, this.text + "." + fieldElement.getSimpleName(), memberType, this.concatPath(fieldElement.getSimpleName().toString()));
    }

    public JavaExpression methodCall(Element element, JavaExpression ... arguments) {
        ExecutableElement executableElement = (ExecutableElement)element;
        ExecutableType executableType = this.methodSignature(executableElement);
        StringBuilder result = new StringBuilder();
        result.append(this.text).append(".").append(executableElement.getSimpleName()).append("(");
        if (arguments.length > 0) {
            result.append(arguments[0].text());
            for (int i = 1; i < arguments.length; ++i) {
                result.append(", ");
                result.append(arguments[i].text());
            }
        }
        result.append(")");
        return new JavaExpression(this.model, result.toString(), executableType.getReturnType(), this.concatPath(executableElement.getSimpleName().toString()));
    }

    public boolean isNullable() {
        if (this.type.getKind().isPrimitive()) {
            return false;
        }
        return this.type.getAnnotationMirrors().stream().filter(am -> am.getAnnotationType().toString().endsWith(".Nullable")).findAny().isPresent();
    }

    public ExecutableType methodSignature(Element element) {
        ExecutableElement executableElement = (ExecutableElement)element;
        return (ExecutableType)this.model.asMemberOf((DeclaredType)this.type, executableElement);
    }

    public String toString() {
        return "JavaExpression [text=" + this.text + ", type=" + this.type + ", path=" + this.path + "]";
    }

    JavaExpression listSize() {
        return new JavaExpression(this.model, this.text + ".size()", this.model.knownTypes()._int.typeMirror(), this.concatPath("size"));
    }
}

