/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.VariableContext;
import io.jstach.apt.internal.context.types.ObjectType;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;

class RootRenderingContext
implements RenderingContext {
    private final VariableContext variables;
    private final JavaExpression expression;

    public RootRenderingContext(JavaExpression expression, VariableContext variables) {
        this.expression = expression;
        this.variables = variables;
    }

    @Override
    public String beginSectionRenderingCode() {
        return "";
    }

    @Override
    public String endSectionRenderingCode() {
        return "";
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        return this._get(name);
    }

    private @Nullable JavaExpression _get(String name) {
        JavaLanguageModel lm = JavaLanguageModel.getInstance();
        return switch (name) {
            case "@context" -> {
                ObjectType contextNodeType = lm.knownTypes()._ContextNode.orElse(null);
                if (contextNodeType == null) {
                    yield null;
                }
                yield lm.expression(this.variables.context(), contextNodeType.typeElement().asType());
            }
            case "@template" -> {
                ObjectType templateType = lm.knownTypes()._Template_Info.orElse(null);
                if (templateType == null) {
                    yield null;
                }
                yield lm.expression(this.variables.template(), templateType.typeElement().asType());
            }
            case "@root" -> this.expression;
            default -> null;
        };
    }

    @Override
    public @Nullable JavaExpression find(String name, Predicate<RenderingContext> filter) {
        return this._get(name);
    }

    @Override
    public JavaExpression currentExpression() {
        throw new IllegalStateException("No current data in root context");
    }

    @Override
    public VariableContext createEnclosedVariableContext() {
        return this.variables.createEnclosedContext();
    }

    @Override
    public VariableContext variableContext() {
        return this.variables;
    }

    @Override
    public @Nullable RenderingContext getParent() {
        return null;
    }
}

