/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.NamedTemplate;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.util.ClassRef;
import io.jstach.apt.prism.Prisms;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.eclipse.jdt.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TemplateStack
extends LoggingSupport.MessagerLogging {
    public String getTemplateName();

    public ClassRef getModelClass();

    public @Nullable TemplateStack getCaller();

    public TemplateType getTemplateType();

    @Override
    public AnnotationMirror annotationToLog();

    default public String describeTemplateStack() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTemplateName());
        for (TemplateStack parent = this.getCaller(); parent != null; parent = parent.getCaller()) {
            sb.append(" <- ");
            sb.append(parent.getTemplateName());
        }
        return sb.toString();
    }

    default public StringBuilder logName(StringBuilder sb) {
        Iterator<TemplateStack> it = this.stack().descendingIterator();
        sb.append(this.getModelClass().getSimpleName());
        while (it.hasNext()) {
            TemplateStack s = it.next();
            switch (s.getTemplateType()) {
                case PARTIAL: {
                    sb.append(" >");
                    break;
                }
                case PARAMETER_PARTIAL: {
                    sb.append(" <");
                    break;
                }
                case ROOT: {
                    sb.append(" = ");
                    break;
                }
                case LAMBDA: {
                    sb.append("#");
                }
            }
            sb.append(s.getTemplateName());
        }
        return sb;
    }

    default public Deque<TemplateStack> stack() {
        ArrayDeque<TemplateStack> stack = new ArrayDeque<TemplateStack>();
        stack.add(this);
        for (TemplateStack parent = this.getCaller(); parent != null; parent = parent.getCaller()) {
            stack.add(parent);
        }
        return stack;
    }

    default public TemplateStack ofParameterPartial(String templateName) {
        return new SimpleTemplateStack(templateName, this, TemplateType.PARAMETER_PARTIAL);
    }

    default public TemplateStack ofPartial(String templateName) {
        return new SimpleTemplateStack(templateName, this, TemplateType.PARTIAL);
    }

    default public TemplateStack ofLambda(String templateName) {
        return new SimpleTemplateStack(templateName, this, TemplateType.LAMBDA);
    }

    public static TemplateStack ofRoot(ClassRef modelClass, NamedTemplate template, Set<Prisms.Flag> flags) {
        return new RootTemplateStack(modelClass, template, flags);
    }

    @Override
    default public Messager messager() {
        return JavaLanguageModel.getInstance().getMessager();
    }

    @Override
    default public void debug(CharSequence message) {
        PrintStream out;
        if (this.isDebug() && (out = this.outWriter()) != null) {
            StringBuilder sb = new StringBuilder("[JSTACHIO] ");
            this.logName(sb).append(": ").append(message);
            out.println(sb.toString());
        }
    }

    @Override
    default public void error(CharSequence message, Throwable t) {
        this.printError(message + " " + t.getMessage());
        PrintStream out = this.errorWriter();
        if (out != null) {
            StringBuilder sb = new StringBuilder("[JSTACHIO] ");
            this.logName(sb).append(": ").append(message);
            out.println(sb.toString());
            t.printStackTrace(out);
        }
    }

    @Override
    default public boolean isDebug() {
        return this.flags().contains((Object)Prisms.Flag.DEBUG);
    }

    default public LoggingSupport logging() {
        return this;
    }

    default public Set<Prisms.Flag> flags() {
        TemplateStack caller = this.getCaller();
        if (caller != null) {
            return caller.flags();
        }
        return Set.of();
    }

    public static enum TemplateType {
        ROOT,
        PARTIAL,
        PARAMETER_PARTIAL,
        LAMBDA;

    }

    public record SimpleTemplateStack(String templateName, TemplateStack caller, TemplateType type) implements TemplateStack
    {
        @Override
        public String getTemplateName() {
            return this.templateName;
        }

        @Override
        public @Nullable TemplateStack getCaller() {
            return this.caller;
        }

        @Override
        public ClassRef getModelClass() {
            return this.caller().getModelClass();
        }

        @Override
        public TemplateType getTemplateType() {
            return this.type();
        }

        @Override
        public AnnotationMirror annotationToLog() {
            return this.caller.annotationToLog();
        }

        @Override
        public Element elementToLog() {
            return this.caller.elementToLog();
        }
    }

    public record RootTemplateStack(ClassRef modelClass, NamedTemplate template, Set<Prisms.Flag> flags) implements TemplateStack
    {
        @Override
        public String getTemplateName() {
            return this.template.name();
        }

        @Override
        public @Nullable TemplateStack getCaller() {
            return null;
        }

        @Override
        public ClassRef getModelClass() {
            return this.modelClass();
        }

        @Override
        public TemplateType getTemplateType() {
            return TemplateType.ROOT;
        }

        @Override
        public AnnotationMirror annotationToLog() {
            return this.template.annotationMirror();
        }

        @Override
        public Element elementToLog() {
            return this.template.element();
        }
    }
}

