/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.JavaExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;

public class VariableContext {
    public static String APPENDER = "appender";
    public static String ESCAPER = "escaper";
    public static String APPENDABLE = "unescapedWriter";
    public static String FORMATTER = "formatter";
    public static String TEMPLATE = "template";
    public static String CONTEXT = "context";
    public static String TEXT = "TEXT";
    private final String appender;
    private final String escaper;
    private final String unescapedWriter;
    private final String formatter;
    private final String template;
    private final String context;
    private final Map<String, Integer> variables;
    private final @Nullable VariableContext parent;
    private final boolean escaped;
    private final NullChecking nullChecking;

    public static VariableContext createDefaultContext(NullChecking nullChecking) {
        TreeMap<String, Integer> variables = new TreeMap<String, Integer>();
        variables.put(ESCAPER, 1);
        variables.put(APPENDER, 1);
        variables.put(APPENDABLE, 1);
        variables.put(FORMATTER, 1);
        variables.put(TEMPLATE, 1);
        variables.put(CONTEXT, 1);
        return new RootVariableContext(APPENDER, ESCAPER, APPENDABLE, FORMATTER, TEMPLATE, CONTEXT, variables, nullChecking);
    }

    VariableContext(String appender, String escaper, String unescapedWriter, String formatter, String template, String context, Map<String, Integer> variables, @Nullable VariableContext parent, boolean escaped, NullChecking nullChecking) {
        this.appender = appender;
        this.escaper = escaper;
        this.unescapedWriter = unescapedWriter;
        this.formatter = formatter;
        this.template = template;
        this.context = context;
        this.variables = variables;
        this.parent = parent;
        this.escaped = escaped;
        this.nullChecking = nullChecking;
    }

    public List<String> textCodes() {
        VariableContext p = this;
        while (p != null) {
            if (p instanceof RootVariableContext) {
                RootVariableContext r = (RootVariableContext)p;
                return r.textCodes;
            }
            p = p.parent;
        }
        throw new IllegalStateException("bug");
    }

    public List<Map.Entry<String, String>> textVariables() {
        List<String> codes = this.textCodes();
        ArrayList<Map.Entry<String, String>> results = new ArrayList<Map.Entry<String, String>>();
        int i = 0;
        for (String code : codes) {
            results.add(Map.entry(TEXT + "_" + i++, code));
        }
        return results;
    }

    public String addTextCode(String textCode) {
        List<String> codes = this.textCodes();
        int i = codes.indexOf(textCode);
        if (i < 0) {
            i = codes.size();
            codes.add(textCode);
        }
        return TEXT + "_" + i;
    }

    public String escaper() {
        return this.escaper;
    }

    public String appender() {
        return this.appender;
    }

    public String unescapedWriter() {
        return this.unescapedWriter;
    }

    public String formatter() {
        return this.formatter;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public String context() {
        return this.context;
    }

    public String template() {
        return this.template;
    }

    public NullChecking nullChecking() {
        return this.nullChecking;
    }

    VariableContext unescaped() {
        return new VariableContext(this.appender, this.appender, this.unescapedWriter, this.formatter, this.template, this.context, this.variables, this.parent, false, this.nullChecking);
    }

    private @Nullable Integer lookupVariable(String baseName) {
        Integer result = this.variables.get(baseName);
        VariableContext p = this.parent;
        if (result != null || p == null) {
            return result;
        }
        return p.lookupVariable(baseName);
    }

    public String introduceNewNameLike(String baseName) {
        int subscriptIndex = baseName.length();
        while (Character.isDigit(baseName.charAt(subscriptIndex - 1))) {
            --subscriptIndex;
        }
        if (subscriptIndex == baseName.length()) {
            Integer count = this.lookupVariable(baseName);
            if (count == null) {
                this.variables.put(baseName, 1);
                return baseName;
            }
            this.variables.put(baseName, count + 1);
            return baseName + count;
        }
        Integer requestedCount = Integer.parseInt(baseName.substring(subscriptIndex));
        Integer currentCount = this.lookupVariable(baseName = baseName.substring(0, subscriptIndex));
        int count = currentCount == null || currentCount < requestedCount ? requestedCount : currentCount;
        this.variables.put(baseName, count + 1);
        return baseName + count;
    }

    VariableContext createEnclosedContext() {
        return new VariableContext(this.appender, this.escaper, this.unescapedWriter, this.formatter, this.template, this.context, new TreeMap<String, Integer>(), this, true, this.nullChecking);
    }

    private static class RootVariableContext
    extends VariableContext {
        private List<String> textCodes = new ArrayList<String>();

        RootVariableContext(String appender, String escaper, String unescapedWriter, String formatter, String template, String context, Map<String, Integer> variables, NullChecking nullChecking) {
            super(appender, escaper, unescapedWriter, formatter, template, context, variables, null, true, nullChecking);
        }
    }

    public static enum NullChecking {
        ALWAYS,
        ANNOTATED;


        public boolean isNullable(JavaExpression expression) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ALWAYS -> true;
                case ANNOTATED -> expression.isNullable();
            };
        }

        public static NullChecking defaults() {
            return ALWAYS;
        }

        public boolean isDefault() {
            return ALWAYS == this;
        }
    }
}

