/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context.types;

import io.jstach.apt.internal.context.types.NativeType;
import io.jstach.apt.internal.context.types.ObjectType;
import io.jstach.apt.internal.context.types.TypesMixin;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class KnownTypes
implements TypesMixin {
    public final NativeType _int;
    public final NativeType _short;
    public final NativeType _long;
    public final NativeType _char;
    public final NativeType _byte;
    public final NativeType _float;
    public final NativeType _double;
    public final NativeType _boolean;
    public final ObjectType _Error;
    public final ObjectType _RuntimeException;
    public final ObjectType _Enum;
    public final ObjectType _Optional;
    public final ObjectType _Integer;
    public final ObjectType _Short;
    public final ObjectType _Long;
    public final ObjectType _Character;
    public final ObjectType _Byte;
    public final ObjectType _Float;
    public final ObjectType _Double;
    public final ObjectType _String;
    public final ObjectType _Boolean;
    public final ObjectType _Iterable;
    public final ObjectType _List;
    public final ObjectType _Map;
    public final Optional<ObjectType> _ContextNode;
    public final Optional<ObjectType> _Formattable;
    public final Optional<ObjectType> _Template_Info;
    public final ObjectType _UUID;
    public final ObjectType _URI;
    public final ObjectType _URL;
    private final List<NativeType> nativeTypes;
    private final List<ObjectType> objectTypes;
    public final ObjectType _Object;
    private final Types types;

    public static KnownTypes createInstace(Elements declarations, Types types) {
        return new KnownTypes(declarations, types);
    }

    private KnownTypes(Elements declarations, Types types) {
        ObjectType ot;
        this.types = types;
        TypesMixin mixin = () -> types;
        Builder b = new Builder(mixin, declarations, types);
        this._int = b.nativeType(TypeKind.INT, Integer.class, Integer.TYPE);
        this._short = b.nativeType(TypeKind.SHORT, Short.class, Short.TYPE);
        this._long = b.nativeType(TypeKind.LONG, Long.class, Long.TYPE);
        this._char = b.nativeType(TypeKind.CHAR, Character.class, Character.TYPE);
        this._byte = b.nativeType(TypeKind.BYTE, Byte.class, Byte.TYPE);
        this._float = b.nativeType(TypeKind.FLOAT, Float.class, Float.TYPE);
        this._double = b.nativeType(TypeKind.DOUBLE, Double.class, Double.TYPE);
        this._boolean = b.nativeType(TypeKind.BOOLEAN, Boolean.class, Boolean.TYPE);
        this._Enum = b.objectType(Enum.class);
        this._String = b.objectType(String.class);
        this._Integer = b.objectType(Integer.class);
        this._Short = b.objectType(Short.class);
        this._Long = b.objectType(Long.class);
        this._Character = b.objectType(Character.class);
        this._Byte = b.objectType(Byte.class);
        this._Float = b.objectType(Float.class);
        this._Double = b.objectType(Double.class);
        this._Boolean = b.objectType(Boolean.class);
        this._Error = b.objectType(Error.class);
        this._RuntimeException = b.objectType(RuntimeException.class);
        this._Optional = b.objectType(Optional.class);
        this._ContextNode = b.optionalObjectType("io.jstach.jstachio.context.ContextNode");
        this._Formattable = b.optionalObjectType("io.jstach.jstachio.Formatter.Formattable");
        this._Template_Info = b.optionalObjectType("io.jstach.jstachio.TemplateInfo");
        this._Iterable = b.objectType(Iterable.class);
        this._List = b.objectType(List.class);
        this._Map = b.objectType(Map.class);
        this._UUID = b.objectType(UUID.class);
        this._URI = b.objectType(URI.class);
        this._URL = b.objectType(URL.class);
        this.nativeTypes = List.copyOf(b.nativeTypes);
        this.objectTypes = List.copyOf(b.objectTypes);
        TypeElement typeElement = Objects.requireNonNull(declarations.getTypeElement(Object.class.getName()));
        this._Object = ot = new ObjectType(mixin, typeElement, Object.class.getName());
    }

    public List<NativeType> getNativeTypes() {
        return this.nativeTypes;
    }

    public List<ObjectType> getObjectTypes() {
        return this.objectTypes;
    }

    @Override
    public Types getTypes() {
        return this.types;
    }

    private static class Builder {
        private final List<NativeType> nativeTypes = new ArrayList<NativeType>();
        private final List<ObjectType> objectTypes = new ArrayList<ObjectType>();
        private final Elements elements;
        private final Types types;
        private final TypesMixin mixin;

        public Builder(TypesMixin mixin, Elements elements, Types types) {
            this.elements = elements;
            this.types = types;
            this.mixin = mixin;
        }

        private NativeType nativeType(TypeKind kind, Class<?> boxedType, Class<?> unboxedType) {
            PrimitiveType typeMirror = this.types.getPrimitiveType(kind);
            NativeType nt = new NativeType(this.mixin, typeMirror, boxedType, unboxedType);
            this.nativeTypes.add(nt);
            return nt;
        }

        private Optional<ObjectType> optionalObjectType(String canonicalName) {
            TypeElement typeElement = this.elements.getTypeElement(canonicalName);
            if (typeElement == null) {
                return Optional.empty();
            }
            ObjectType ot = new ObjectType(this.mixin, typeElement, canonicalName);
            this.objectTypes.add(ot);
            return Optional.of(ot);
        }

        private ObjectType objectType(Class<?> type) {
            TypeElement typeElement = Objects.requireNonNull(this.elements.getTypeElement(type.getName()));
            ObjectType ot = new ObjectType(this.mixin, typeElement, type.getName());
            this.objectTypes.add(ot);
            return ot;
        }
    }
}

