/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.util;

import io.jstach.apt.internal.context.JavaLanguageModel;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ClassRef {
    private final String packageName;
    private final String simpleName;
    private final String binaryName;
    private final String canonicalName;

    private ClassRef(String packageName, String simpleName, String binaryName, String canonicalName) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.binaryName = binaryName;
        this.canonicalName = canonicalName;
    }

    public static ClassRef ofBinaryName(String binaryName) {
        int i = binaryName.lastIndexOf(".");
        if (i == 0) {
            throw new IllegalArgumentException("malformed binaryName");
        }
        String className = i > 0 ? binaryName.substring(i + 1) : binaryName;
        String packageName = i > 0 ? binaryName.substring(0, i) : "";
        int j = className.lastIndexOf("$");
        String simpleName = i > 0 ? className.substring(j + 1) : className;
        String canonicalName = binaryName.replace("$", ".");
        return new ClassRef(packageName, simpleName, binaryName, canonicalName);
    }

    public static ClassRef of(String packageName, String className) {
        String binaryClassName = className.replace(".", "$");
        String binaryName = packageName.isEmpty() ? binaryClassName : packageName + "." + binaryClassName;
        return ClassRef.ofBinaryName(binaryName);
    }

    public static ClassRef of(PackageElement packageElement, String className) {
        return ClassRef.of(packageElement.getQualifiedName().toString(), className);
    }

    public static ClassRef of(TypeMirror tm) {
        Element e = ((DeclaredType)tm).asElement();
        TypeElement te = (TypeElement)e;
        return ClassRef.of(te);
    }

    public static ClassRef of(TypeElement te) {
        Elements elements = JavaLanguageModel.getInstance().getElements();
        PackageElement pe = elements.getPackageOf(te);
        assert (pe != null);
        String packageName = pe.getQualifiedName().toString();
        String simpleName = te.getSimpleName().toString();
        String binaryName = elements.getBinaryName(te).toString();
        String qualifiedName = te.getQualifiedName().toString();
        return new ClassRef(packageName, simpleName, binaryName, qualifiedName);
    }

    public static ClassRef of(Class<?> c) {
        return ClassRef.ofBinaryName(c.getName());
    }

    public int hashCode() {
        return Objects.hash(this.binaryName);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClassRef other = (ClassRef)obj;
        return Objects.equals(this.binaryName, other.binaryName);
    }

    public @Nullable String getCanonicalName() {
        return this.canonicalName;
    }

    public String requireCanonicalName() {
        return Objects.requireNonNull(this.canonicalName);
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public boolean isSamePackage(ClassRef other) {
        return this.getPackageName().equals(other.getPackageName());
    }

    public String getBinaryNameMinusPackage() {
        if (this.packageName.isEmpty()) {
            return this.binaryName;
        }
        return this.binaryName.substring(this.packageName.length() + 1);
    }

    public @NonNull String toString() {
        return this.binaryName;
    }
}

