/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.util;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor14;

public class ToStringTypeVisitor
extends AbstractTypeVisitor14<StringBuilder, StringBuilder> {
    private final int depth;
    private final boolean includeAnnotations;
    private final HashMap<TypeVariable, String> typeVariables;
    private static final boolean DEBUG = false;

    public static String toCodeSafeString(TypeMirror typeMirror) {
        return ToStringTypeVisitor.toCodeSafeString(typeMirror, 1, Map.of());
    }

    static String toCodeSafeString(TypeMirror typeMirror, int depth, Map<TypeVariable, String> typeVariables) {
        ToStringTypeVisitor v = new ToStringTypeVisitor(depth, typeVariables);
        v.typeVariables.putAll(typeVariables);
        StringBuilder b = new StringBuilder();
        return typeMirror.accept(v, b).toString();
    }

    private ToStringTypeVisitor() {
        this(1, new HashMap<TypeVariable, String>());
    }

    private ToStringTypeVisitor(int depth, Map<TypeVariable, String> typeVariables) {
        this.includeAnnotations = true;
        this.depth = depth;
        this.typeVariables = new HashMap();
        this.typeVariables.putAll(typeVariables);
    }

    void debug(String message, Object o) {
    }

    private static String indent(int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }

    ToStringTypeVisitor child() {
        ToStringTypeVisitor tmv = new ToStringTypeVisitor(this.depth + 1, this.typeVariables);
        return tmv;
    }

    @Override
    public StringBuilder visitPrimitive(PrimitiveType t, StringBuilder p) {
        this.debug("primitive", t);
        if (this.includeAnnotations) {
            for (AnnotationMirror annotationMirror : t.getAnnotationMirrors()) {
                p.append(annotationMirror.toString()).append(" ");
            }
        }
        p.append(t.getKind().toString().toLowerCase(Locale.ROOT));
        return p;
    }

    @Override
    public StringBuilder visitNull(NullType t, StringBuilder p) {
        this.debug("null", t);
        return p;
    }

    @Override
    public StringBuilder visitArray(ArrayType t, StringBuilder p) {
        this.debug("array", t);
        TypeMirror ct = t.getComponentType();
        ct.accept(this.child(), p);
        boolean first = true;
        if (this.includeAnnotations) {
            for (AnnotationMirror annotationMirror : t.getAnnotationMirrors()) {
                if (first) {
                    p.append(" ");
                    first = false;
                }
                p.append(annotationMirror.toString()).append(" ");
            }
        }
        p.append("[]");
        return p;
    }

    @Override
    public StringBuilder visitDeclared(DeclaredType t, StringBuilder p) {
        this.debug("declared", t);
        String fqn = ToStringTypeVisitor.fullyQualfiedName(t, this.includeAnnotations);
        this.debug("typeUseFQN", fqn);
        p.append(fqn);
        List<? extends TypeMirror> tas = t.getTypeArguments();
        if (!tas.isEmpty()) {
            p.append("<");
            boolean first = true;
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                if (first) {
                    first = false;
                } else {
                    p.append(", ");
                }
                typeMirror.accept(this.child(), p);
            }
            p.append(">");
        }
        return p;
    }

    static String fullyQualfiedName(DeclaredType t, boolean includeAnnotations) {
        Object enclosedPart;
        TypeElement element = (TypeElement)t.asElement();
        List<? extends AnnotationMirror> typeUseAnnotations = t.getAnnotationMirrors();
        if (typeUseAnnotations.isEmpty() || !includeAnnotations) {
            return element.getQualifiedName().toString();
        }
        Element enclosed = element.getEnclosingElement();
        if (enclosed instanceof QualifiedNameable) {
            QualifiedNameable qn = (QualifiedNameable)enclosed;
            enclosedPart = qn.getQualifiedName().toString() + ".";
        } else {
            enclosedPart = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append((String)enclosedPart);
        for (AnnotationMirror annotationMirror : typeUseAnnotations) {
            sb.append(annotationMirror.toString()).append(" ");
        }
        sb.append(element.getSimpleName());
        return sb.toString();
    }

    @Override
    public StringBuilder visitError(ErrorType t, StringBuilder p) {
        this.debug("error", t);
        return p;
    }

    @Override
    public StringBuilder visitTypeVariable(TypeVariable t, StringBuilder p) {
        this.debug("typeVariable", t);
        String previous = this.typeVariables.get(t);
        if (previous != null) {
            p.append(previous);
            return p;
        }
        this.debug("lower", t.getLowerBound());
        this.debug("upper", t.getUpperBound());
        StringBuilder sb = new StringBuilder();
        if (this.includeAnnotations) {
            for (AnnotationMirror annotationMirror : t.getAnnotationMirrors()) {
                p.append(annotationMirror.toString()).append(" ");
                sb.append(annotationMirror.toString()).append(" ");
            }
        }
        p.append(t.asElement().getSimpleName().toString());
        sb.append(t.asElement().getSimpleName().toString());
        this.typeVariables.put(t, sb.toString());
        return p;
    }

    @Override
    public StringBuilder visitWildcard(WildcardType t, StringBuilder p) {
        this.debug("wildcard", t);
        TypeMirror extendsBound = t.getExtendsBound();
        TypeMirror superBound = t.getSuperBound();
        for (AnnotationMirror annotationMirror : t.getAnnotationMirrors()) {
            p.append(annotationMirror.toString()).append(" ");
        }
        if (extendsBound != null) {
            p.append("? extends ");
            extendsBound.accept(this.child(), p);
        } else if (superBound != null) {
            p.append("? super ");
            superBound.accept(this.child(), p);
        } else {
            p.append("?");
        }
        return p;
    }

    @Override
    public StringBuilder visitExecutable(ExecutableType t, StringBuilder p) {
        this.debug("executable", t);
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuilder visitNoType(NoType t, StringBuilder p) {
        this.debug("noType", t);
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuilder visitIntersection(IntersectionType t, StringBuilder p) {
        this.debug("intersection", t);
        boolean first = true;
        for (TypeMirror typeMirror : t.getBounds()) {
            if (first) {
                first = false;
            } else {
                p.append("&");
            }
            typeMirror.accept(this.child(), p);
        }
        return p;
    }

    @Override
    public StringBuilder visitUnion(UnionType t, StringBuilder p) {
        this.debug("union", t);
        throw new UnsupportedOperationException();
    }
}

