/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XmlHelper {
    private final Document doc;
    private final XPath xpath;

    private XmlHelper(Document doc, XPath xpath) {
        this.doc = doc;
        this.xpath = xpath;
    }

    public static XmlHelper of(InputStream stream) throws IOException {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(stream);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        return new XmlHelper(doc, xpath);
    }

    public Optional<String> findString(String ... paths) {
        try {
            for (String path : paths) {
                String v = (String)this.xpath.evaluate(path, this.doc, XPathConstants.STRING);
                if (v == null || v.isEmpty()) continue;
                return Optional.of(v);
            }
            return Optional.empty();
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<Element> findElements(String path) {
        try {
            NodeList list = (NodeList)this.xpath.evaluate(path, this.doc, XPathConstants.NODESET);
            Objects.requireNonNull(list);
            return XmlHelper.toElementStream(list);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    static Stream<Element> toElementStream(final NodeList nodeList) {
        Spliterators.AbstractSpliterator<Element> spliterator = new Spliterators.AbstractSpliterator<Element>((long)nodeList.getLength(), 16){
            int index;
            {
                super(est, additionalCharacteristics);
                this.index = 0;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Element> action) {
                while (this.index < nodeList.getLength()) {
                    Node item;
                    if (!((item = nodeList.item(this.index++)) instanceof Element)) continue;
                    Element e = (Element)item;
                    action.accept(e);
                    return true;
                }
                return false;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }
}

