/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.prism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.Nullable;

public class JStacheCatalogPrism {
    private @Nullable String _name;
    private List<String> _flags;
    public static final String PRISM_ANNOTATION_TYPE = "io.jstach.jstache.JStacheCatalog";
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>();
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>();
    private boolean valid = true;

    public static @Nullable JStacheCatalogPrism getInstanceOn(Element e) {
        AnnotationMirror m = JStacheCatalogPrism.getMirror(PRISM_ANNOTATION_TYPE, e);
        if (m == null) {
            return null;
        }
        return JStacheCatalogPrism.getInstance(m);
    }

    public static JStacheCatalogPrism getInstance(AnnotationMirror mirror) {
        String mirrorType = mirror.getAnnotationType().toString();
        if (!PRISM_ANNOTATION_TYPE.equals(mirrorType)) {
            throw new IllegalArgumentException("expected: io.jstach.jstache.JStacheCatalog got: " + mirrorType);
        }
        return new JStacheCatalogPrism(mirror);
    }

    private JStacheCatalogPrism(AnnotationMirror mirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : mirror.getElementValues().entrySet()) {
            this.memberValues.put(e.getKey().getSimpleName().toString(), e.getValue());
        }
        for (ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue = member.getDefaultValue();
            if (defaultValue == null) continue;
            this.defaults.put(member.getSimpleName().toString(), defaultValue);
        }
        this._name = this.getValue("name", String.class);
        List<VariableElement> flagsMirrors = this.getArrayValues("flags", VariableElement.class);
        this._flags = new ArrayList<String>(flagsMirrors.size());
        for (VariableElement flagsMirror : flagsMirrors) {
            this._flags.add(flagsMirror.getSimpleName().toString());
        }
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String name() {
        return JStacheCatalogPrism.requireMember(this._name);
    }

    public List<String> flags() {
        return JStacheCatalogPrism.requireMember(this._flags);
    }

    private <T> @Nullable T getValue(String name, Class<T> clazz) {
        @Nullable T result = JStacheCatalogPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = JStacheCatalogPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == Collections.emptyList()) {
            this.valid = false;
        }
        return result;
    }

    private static @Nullable AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> @Nullable T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> T requireMember(@Nullable T t) {
        if (t == null) {
            throw new NoSuchElementException("prism is invalid");
        }
        return t;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return Collections.emptyList();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : JStacheCatalogPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return Collections.emptyList();
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public @Nullable AnnotationValue name() {
            return this.values.get("name");
        }

        public @Nullable AnnotationValue flags() {
            return this.values.get("flags");
        }
    }
}

