/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.prism;

import io.jstach.apt.prism.JStacheInterfacesPrism;
import io.jstach.apt.prism.JStachePathPrism;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.Nullable;

public class JStacheConfigPrism {
    private @Nullable TypeMirror _using;
    private List<JStacheName> _naming;
    private List<JStachePathPrism> _pathing;
    private List<JStacheInterfacesPrism> _interfacing;
    private @Nullable TypeMirror _contentType;
    private @Nullable TypeMirror _formatter;
    private @Nullable String _charset;
    private @Nullable String _type;
    public static final String PRISM_ANNOTATION_TYPE = "io.jstach.jstache.JStacheConfig";
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>();
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>();
    private boolean valid = true;

    public static @Nullable JStacheConfigPrism getInstanceOn(Element e) {
        AnnotationMirror m = JStacheConfigPrism.getMirror(PRISM_ANNOTATION_TYPE, e);
        if (m == null) {
            return null;
        }
        return JStacheConfigPrism.getInstance(m);
    }

    public static JStacheConfigPrism getInstance(AnnotationMirror mirror) {
        String mirrorType = mirror.getAnnotationType().toString();
        if (!PRISM_ANNOTATION_TYPE.equals(mirrorType)) {
            throw new IllegalArgumentException("expected: io.jstach.jstache.JStacheConfig got: " + mirrorType);
        }
        return new JStacheConfigPrism(mirror);
    }

    private JStacheConfigPrism(AnnotationMirror mirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            this.memberValues.put(entry.getKey().getSimpleName().toString(), entry.getValue());
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue = executableElement.getDefaultValue();
            if (annotationValue == null) continue;
            this.defaults.put(executableElement.getSimpleName().toString(), annotationValue);
        }
        this._using = this.getValue("using", TypeMirror.class);
        List<AnnotationMirror> namingMirrors = this.getArrayValues("naming", AnnotationMirror.class);
        this._naming = new ArrayList<JStacheName>(namingMirrors.size());
        for (AnnotationMirror annotationMirror : namingMirrors) {
            this._naming.add(JStacheName.getInstance(annotationMirror));
        }
        List<AnnotationMirror> list = this.getArrayValues("pathing", AnnotationMirror.class);
        this._pathing = new ArrayList<JStachePathPrism>(list.size());
        for (AnnotationMirror annotationMirror : list) {
            this._pathing.add(JStachePathPrism.getInstance(annotationMirror));
        }
        List<AnnotationMirror> list2 = this.getArrayValues("interfacing", AnnotationMirror.class);
        this._interfacing = new ArrayList<JStacheInterfacesPrism>(list2.size());
        for (AnnotationMirror interfacingMirror : list2) {
            this._interfacing.add(JStacheInterfacesPrism.getInstance(interfacingMirror));
        }
        this._contentType = this.getValue("contentType", TypeMirror.class);
        this._formatter = this.getValue("formatter", TypeMirror.class);
        this._charset = this.getValue("charset", String.class);
        VariableElement variableElement = this.getValue("type", VariableElement.class);
        this.valid = this.valid && variableElement != null;
        this._type = variableElement == null ? null : variableElement.getSimpleName().toString();
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public TypeMirror using() {
        return JStacheConfigPrism.requireMember(this._using);
    }

    public List<JStacheName> naming() {
        return JStacheConfigPrism.requireMember(this._naming);
    }

    public List<JStachePathPrism> pathing() {
        return JStacheConfigPrism.requireMember(this._pathing);
    }

    public List<JStacheInterfacesPrism> interfacing() {
        return JStacheConfigPrism.requireMember(this._interfacing);
    }

    public TypeMirror contentType() {
        return JStacheConfigPrism.requireMember(this._contentType);
    }

    public TypeMirror formatter() {
        return JStacheConfigPrism.requireMember(this._formatter);
    }

    public String charset() {
        return JStacheConfigPrism.requireMember(this._charset);
    }

    public String type() {
        return JStacheConfigPrism.requireMember(this._type);
    }

    private <T> @Nullable T getValue(String name, Class<T> clazz) {
        @Nullable T result = JStacheConfigPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = JStacheConfigPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == Collections.emptyList()) {
            this.valid = false;
        }
        return result;
    }

    private static @Nullable AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> @Nullable T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> T requireMember(@Nullable T t) {
        if (t == null) {
            throw new NoSuchElementException("prism is invalid");
        }
        return t;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return Collections.emptyList();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : JStacheConfigPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return Collections.emptyList();
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class JStacheName {
        private @Nullable String _prefix;
        private @Nullable String _suffix;
        public static final String PRISM_ANNOTATION_TYPE = "io.jstach.jstache.JStacheName";
        public final Values values;
        public final boolean isValid;
        public final AnnotationMirror mirror;
        private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>();
        private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>();
        private boolean valid = true;

        private static JStacheName getInstance(AnnotationMirror mirror) {
            String mirrorType = mirror.getAnnotationType().toString();
            if (!PRISM_ANNOTATION_TYPE.equals(mirrorType)) {
                throw new IllegalArgumentException("expected: io.jstach.jstache.JStacheName got: " + mirrorType);
            }
            return new JStacheName(mirror);
        }

        private JStacheName(AnnotationMirror mirror) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : mirror.getElementValues().entrySet()) {
                this.memberValues.put(e.getKey().getSimpleName().toString(), e.getValue());
            }
            for (ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
                AnnotationValue defaultValue = member.getDefaultValue();
                if (defaultValue == null) continue;
                this.defaults.put(member.getSimpleName().toString(), defaultValue);
            }
            this._prefix = this.getValue("prefix", String.class);
            this._suffix = this.getValue("suffix", String.class);
            this.values = new Values(this.memberValues);
            this.mirror = mirror;
            this.isValid = this.valid;
        }

        public String prefix() {
            return JStacheConfigPrism.requireMember(this._prefix);
        }

        public String suffix() {
            return JStacheConfigPrism.requireMember(this._suffix);
        }

        private <T> @Nullable T getValue(String name, Class<T> clazz) {
            @Nullable T result = JStacheConfigPrism.getValue(this.memberValues, this.defaults, name, clazz);
            if (result == null) {
                this.valid = false;
            }
            return result;
        }

        public static class Values {
            private Map<String, AnnotationValue> values;

            private Values(Map<String, AnnotationValue> values) {
                this.values = values;
            }

            public @Nullable AnnotationValue prefix() {
                return this.values.get("prefix");
            }

            public @Nullable AnnotationValue suffix() {
                return this.values.get("suffix");
            }
        }
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public @Nullable AnnotationValue using() {
            return this.values.get("using");
        }

        public @Nullable AnnotationValue naming() {
            return this.values.get("naming");
        }

        public @Nullable AnnotationValue pathing() {
            return this.values.get("pathing");
        }

        public @Nullable AnnotationValue interfacing() {
            return this.values.get("interfacing");
        }

        public @Nullable AnnotationValue contentType() {
            return this.values.get("contentType");
        }

        public @Nullable AnnotationValue formatter() {
            return this.values.get("formatter");
        }

        public @Nullable AnnotationValue charset() {
            return this.values.get("charset");
        }

        public @Nullable AnnotationValue type() {
            return this.values.get("type");
        }
    }
}

