/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.util.ClassRef;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ServicesFiles {
    public static final String SERVICES_PATH = "META-INF/services";

    private ServicesFiles() {
    }

    static String getPath(String serviceName) {
        return "META-INF/services/" + serviceName;
    }

    static Set<String> readServiceFile(InputStream input) throws IOException {
        LinkedHashSet<String> serviceClasses = new LinkedHashSet<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                int commentStart = line.indexOf(35);
                if (commentStart >= 0) {
                    line = line.substring(0, commentStart);
                }
                if ((line = line.trim()).isEmpty()) continue;
                serviceClasses.add(line);
            }
            LinkedHashSet<String> linkedHashSet = serviceClasses;
            return linkedHashSet;
        }
    }

    static FileObject getResourceFile(Filer filer, String file) throws IOException {
        return filer.getResource(StandardLocation.CLASS_OUTPUT, "", file);
    }

    static FileObject createResourceFile(Filer filer, String file) throws IOException {
        return filer.createResource(StandardLocation.CLASS_OUTPUT, "", file, new Element[0]);
    }

    private static void writeServiceFile(Collection<String> services, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        for (String service : services) {
            writer.write(service);
            writer.newLine();
        }
        writer.flush();
    }

    public static void writeServicesFile(Filer filer, LoggingSupport messager, ClassRef serviceInterface, Iterable<ClassRef> classes) {
        String serviceFile = "META-INF/services/" + serviceInterface.requireCanonicalName();
        TreeSet<String> services = new TreeSet<String>();
        try {
            FileObject existingFile = ServicesFiles.getResourceFile(filer, serviceFile);
            Set<String> oldServices = ServicesFiles.readServiceFile(existingFile.openInputStream());
            services.addAll(oldServices);
        }
        catch (IOException ioe) {
            messager.debug("no existing services file found");
        }
        SortedSet newServices = StreamSupport.stream(classes.spliterator(), false).map(c -> c.getBinaryName()).collect(Collectors.toCollection(TreeSet::new));
        services.addAll(newServices);
        try {
            FileObject existingFile = ServicesFiles.createResourceFile(filer, serviceFile);
            try (OutputStream os = existingFile.openOutputStream();){
                ServicesFiles.writeServiceFile(services, os);
            }
            messager.info("Wrote services file: " + serviceInterface.requireCanonicalName());
        }
        catch (IOException ioe) {
            messager.error("error writing services files: ", ioe);
        }
    }
}

