/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.internal.ProcessingConfig;
import io.jstach.apt.internal.util.EclipseClasspath;
import io.jstach.apt.internal.util.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.jdt.annotation.Nullable;

class TextFileObject {
    private final ProcessingEnvironment env;
    private final ProcessingConfig config;
    private static final ConcurrentMap<Path, Optional<EclipseClasspath.EclipseClasspathFile>> eclipseClasspathFileCache = new ConcurrentHashMap<Path, Optional<EclipseClasspath.EclipseClasspathFile>>();

    TextFileObject(ProcessingConfig config, ProcessingEnvironment env) {
        this.env = env;
        this.config = config;
    }

    InputStream openInputStream(String name) throws IOException {
        FileObject resource;
        if (name.startsWith("/")) {
            if (this.config.isDebug()) {
                this.config.debug("Path starts with a starting slash. path=" + name);
            }
            name = name.substring(1);
        }
        if ((resource = this.env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", name)).getLastModified() > 0L) {
            return resource.openInputStream();
        }
        boolean eclipseFileManager = this.env.getFiler().getClass().getName().startsWith("org.eclipse");
        if (this.config.isDebug()) {
            this.config.debug("File not found with Filer. resource: " + resource.toUri());
            if (eclipseFileManager) {
                this.config.debug("Eclipse file manager is in use.");
            }
        }
        if (this.config.fallbackToFilesystem()) {
            List<String> resourcePaths;
            ProjectPattern pattern;
            Path projectPath;
            FileObject dummyClassOutput = this.env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "dummy");
            FileObject dummySourceOutput = this.env.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", "dummy");
            if (this.config.isGradleEnabled() && this.config.isDebug()) {
                this.config.debug("Looks like we are using Gradle incremental. dummy: " + dummyClassOutput.toUri());
            } else if (this.config.isDebug()) {
                this.config.debug("Looks like we are using Eclipse or Intellij incremental. dummy: " + dummyClassOutput.toUri());
            }
            OutputPathPattern outputPattern = OutputPathPattern.find(dummyClassOutput.toUri());
            if (outputPattern == OutputPathPattern.CWD && eclipseFileManager) {
                this.config.debug("Attempting to locate .classpath as we are in Eclipse");
                Path classOutputPath = Path.of(dummyClassOutput.toUri()).getParent();
                if (classOutputPath == null) {
                    throw new IOException(TextFileObject.printAttempts("Failed to locate Eclipse .classpath! ", name, resource));
                }
                EclipseClasspath.EclipseClasspathFile classpathFile = this.findEclipseClasspathFile(classOutputPath);
                if (classpathFile == null) {
                    this.config.debug("Failed to locate Eclipse .classpath!");
                    throw new IOException(TextFileObject.printAttempts("Failed to locate Eclipse .classpath! ", name, resource));
                }
                Path projectDirectory = classpathFile.classpathFile().getParent();
                if (projectDirectory == null) {
                    throw new IOException(TextFileObject.printAttempts("No parent directory to Eclipse .classpath! ", name, resource));
                }
                projectPath = projectDirectory;
                Path sourceOutputPath = Path.of(dummySourceOutput.toUri()).getParent();
                List<String> sourcePaths = classpathFile.findRelativeSourcePaths(classOutputPath, sourceOutputPath).toList();
                pattern = new ProjectPattern.EclipseProjectPattern(sourcePaths);
                if (this.config.isDebug()) {
                    this.config.info("Inside Eclipse. Using .classpath. name = " + name + " projectPath = " + projectPath + " sourcePaths = " + sourcePaths + " resourcesPaths=" + this.config.resourcesPaths());
                }
            } else {
                projectPath = outputPattern.resolveProjectPath(dummyClassOutput.toUri());
                pattern = outputPattern;
            }
            if (this.config.isDebug()) {
                this.config.debug("Detected class output pattern: " + pattern + " projectPath: " + projectPath);
            }
            if ((resourcePaths = this.config.resourcesPaths()).isEmpty()) {
                resourcePaths = pattern.relativeSourcePaths();
            }
            String resourceName = name;
            List<Path> fullPaths = resourcePaths.stream().map(rp -> TextFileObject.resolvePath(projectPath, rp, resourceName)).toList();
            for (Path fullPath : fullPaths) {
                if (this.config.isDebug()) {
                    this.config.debug("File not found with Filer. Trying direct file access. name:" + resourceName + ", path: " + fullPath + ", dummy: " + dummyClassOutput.toUri());
                }
                if (!Files.isReadable(fullPath)) continue;
                return Files.newInputStream(fullPath, new OpenOption[0]);
            }
            Object error = TextFileObject.printAttempts(new StringBuilder(), name, resource, fullPaths, "").toString();
            if (this.config.isDebug()) {
                StringBuilder diagnostic = new StringBuilder();
                TextFileObject.printAttempts(diagnostic, name, resource, fullPaths, "\n\t");
                diagnostic.append("\n\n");
                List<Map.Entry<String, String>> keys = List.of(Map.entry("projectPath", projectPath.toString()), Map.entry("classOutput", dummyClassOutput.toUri().toString()), Map.entry("sourceOutput", dummySourceOutput.toUri().toString()), Map.entry("outputPathPattern", pattern.toString()), Map.entry("jstache.resourcesPath", this.config.resourcesPaths().toString()), Map.entry("filer", this.env.getFiler().getClass().toString()));
                TextFileObject.diagnosticDump(diagnostic, this.config, keys);
                this.config.warn(diagnostic.toString());
                if (diagnostic.length() > 4096) {
                    diagnostic.setLength(4096);
                }
                error = (String)error + "\nBelow is extended diagnostic data which maybe truncated (check logs).\n" + diagnostic.toString();
            }
            throw new IOException((String)error);
        }
        return resource.openInputStream();
    }

    private @Nullable EclipseClasspath.EclipseClasspathFile findEclipseClasspathFile(Path classOutputPath) throws IOException {
        return eclipseClasspathFileCache.computeIfAbsent(classOutputPath, p -> {
            try {
                return EclipseClasspath.find(p);
            }
            catch (IOException e) {
                throw Throwables.sneakyThrow(e);
            }
        }).orElse(null);
    }

    private static String printAttempts(String error, String name, FileObject resource) {
        StringBuilder sb = new StringBuilder(error);
        return TextFileObject.printAttempts(sb, name, resource, List.of(), "").toString();
    }

    private static StringBuilder printAttempts(StringBuilder sb, String name, FileObject resource, List<Path> fullPaths, String separator) {
        sb.append("Failed to find template resource: '").append(name).append("'. Tried the following locations: ");
        sb.append(separator).append("'").append(resource.toUri()).append("'");
        for (Path p : fullPaths) {
            sb.append(separator).append(", '").append(p.toString()).append("'");
        }
        return sb;
    }

    private static StringBuilder diagnosticDump(StringBuilder sb, ProcessingConfig config, List<Map.Entry<String, String>> keys) {
        sb.append("Environment Info:").append("\n");
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        keys.forEach(e -> info.put((String)e.getKey(), (String)e.getValue()));
        Path cwd = Path.of(".", new String[0]);
        try {
            info.put("CWD", cwd.toAbsolutePath().toString());
        }
        catch (Exception e2) {
            info.put("CWD", cwd.toString());
        }
        info.put("JDK", Runtime.version().toString());
        info.put("isGradle", "" + config.isGradleEnabled());
        for (Map.Entry entry : info.entrySet()) {
            sb.append("\n\t").append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        sb.append("\n\n");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString().toLowerCase(Locale.ENGLISH);
            if (key.contains("secret") || key.contains("password") || key.contains("key") || key.contains("line.separator") || key.contains("vmargs") || key.contains("eclipse.commands") || key.startsWith("osgi") || key.startsWith("org.osgi")) continue;
            sb.append("\n\t").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb;
    }

    private static Path resolvePath(Path projectPath, String resourcePath, String name) {
        Path filePath = Path.of(resourcePath, name);
        return filePath.isAbsolute() ? filePath : projectPath.resolve(filePath);
    }

    Charset charset() {
        return this.config.charset();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum OutputPathPattern implements ProjectPattern
    {
        GRADLE("/build/classes/java/main/", List.of("src/main/resources")),
        GRADLE_TEST("/build/classes/java/test/", List.of("src/test/resources")),
        MAVEN("/target/classes/", List.of("src/main/resources")),
        MAVEN_TEST("/target/test-classes/", List.of("src/test/resources")),
        CWD(".", (List)List.of("src/main/resources")){

            @Override
            public boolean matches(String uri) {
                return false;
            }

            @Override
            public Path resolveProjectPath(URI uri) {
                return Path.of(".", new String[0]);
            }
        };

        private static final String DUMMY = "dummy";
        private final String endPath;
        private final List<String> relativeSourcePaths;
        private final StandardLocation outputType;

        private OutputPathPattern(String endPath, List<String> relativeSourcePaths) {
            this(endPath, relativeSourcePaths, StandardLocation.CLASS_OUTPUT);
        }

        private OutputPathPattern(String endPath, List<String> relativeSourcePaths, StandardLocation outputType) {
            this.endPath = endPath;
            this.relativeSourcePaths = relativeSourcePaths;
            this.outputType = outputType;
        }

        public boolean matches(String uri) {
            return uri.endsWith(this.endPath + DUMMY);
        }

        public Path resolveProjectPath(URI uri) {
            Path path = Paths.get(uri);
            int segments = this.endPath.split("/").length;
            for (int i = 0; i < segments; ++i) {
                Path parent = path.getParent();
                if (parent == null) {
                    throw new IllegalStateException("Path pattern (bug). pattern: " + this + " uri: " + uri);
                }
                path = parent;
            }
            return path;
        }

        @Override
        public List<String> relativeSourcePaths() {
            return this.relativeSourcePaths;
        }

        public static OutputPathPattern find(URI uri) {
            return OutputPathPattern.find(uri, StandardLocation.CLASS_OUTPUT);
        }

        public static OutputPathPattern find(URI uri, StandardLocation location) {
            String u = uri.toString().trim();
            for (OutputPathPattern o : OutputPathPattern.values()) {
                if (location != o.outputType || !o.matches(u)) continue;
                return o;
            }
            return CWD;
        }
    }

    private static interface ProjectPattern {
        public List<String> relativeSourcePaths();

        public record EclipseProjectPattern(List<String> relativeSourcePaths) implements ProjectPattern
        {
        }
    }
}

