/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal;

import io.jstach.apt.internal.escape.EscapeUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

public interface CodeAppendable
extends Appendable {
    default public void print(String s) {
        try {
            this.append(s);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public void println() {
        this.print("\n");
    }

    public static String stringLiteralConcat(String s) {
        int i = 0;
        StringBuilder code = new StringBuilder();
        for (String line : CodeAppendable.split(s, "\\n")) {
            if (i > 0) {
                code.append(" +");
            }
            code.append("\n    \"");
            code.append(line);
            code.append("\"");
            ++i;
        }
        String result = code.toString();
        if (result.isEmpty()) {
            result = "\"\"";
        }
        return result;
    }

    public static String stringConcat(String s) {
        int i = 0;
        StringBuilder code = new StringBuilder();
        for (String line : CodeAppendable.split(s, "\n")) {
            if (i > 0) {
                code.append(" +");
            }
            code.append("\n    \"");
            code.append(EscapeUtils.escapeJava(line));
            code.append("\"");
            ++i;
        }
        String result = code.toString();
        if (result.isEmpty()) {
            result = "\"\"";
        }
        return result;
    }

    public static List<String> split(String s, String delim) {
        int dl = delim.length();
        int sl = s.length();
        ArrayList<String> tokens = new ArrayList<String>();
        int i = 0;
        while (i < sl) {
            int end = s.indexOf(delim, i);
            end = end < 0 ? sl : Integer.min(end + dl, sl);
            String chunk = s.substring(i, end);
            tokens.add(chunk);
            i = end;
        }
        return tokens;
    }

    public static class StringCodeAppendable
    implements CodeAppendable {
        private final StringBuilder buffer;

        public StringCodeAppendable() {
            this(new StringBuilder());
        }

        public StringCodeAppendable(StringBuilder buffer) {
            this.buffer = buffer;
        }

        public String toString() {
            return this.buffer.toString();
        }

        @Override
        public StringCodeAppendable append(@Nullable CharSequence csq) {
            this.buffer.append(csq);
            return this;
        }

        @Override
        public StringCodeAppendable append(@Nullable CharSequence csq, int start, int end) {
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        public StringCodeAppendable append(char c) {
            this.buffer.append(c);
            return this;
        }
    }

    public static class HiddenCodeAppendable
    implements CodeAppendable {
        private final Consumer<CharSequence> sink;

        public HiddenCodeAppendable(Consumer<CharSequence> sink) {
            this.sink = sink;
        }

        @Override
        public HiddenCodeAppendable append(@Nullable CharSequence csq) {
            if (csq != null) {
                this.sink.accept(csq);
            }
            return this;
        }

        @Override
        public HiddenCodeAppendable append(@Nullable CharSequence csq, int start, int end) {
            if (csq != null) {
                this.sink.accept(csq);
            }
            return this;
        }

        @Override
        public HiddenCodeAppendable append(char c) {
            this.append(String.valueOf(c));
            return this;
        }
    }
}

