/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.LambdaContext;
import io.jstach.apt.internal.context.TypeException;
import io.jstach.apt.prism.RawPrism;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Lambda {
    default public String name() {
        return this.method().name();
    }

    public Method method();

    default public String description() {
        return "Lambda[name='" + this.name() + "', returnType=" + this.method().methodElement().getReturnType() + ", method='" + this.method() + "]";
    }

    default public JavaExpression callExpression(String literalBlock, LambdaContext context) throws TypeException {
        JavaLanguageModel model = this.method().expression().model();
        JavaExpression currentContextExpression = context.get();
        ArrayList<JavaExpression> args = new ArrayList<JavaExpression>();
        for (Param param : this.method().params()) {
            JavaExpression arg = switch (param.paramType()) {
                default -> throw new IncompatibleClassChangeError();
                case ParamType.STRING_BODY -> currentContextExpression.stringLiteral(literalBlock);
                case ParamType.CURRENT_CONTEXT -> {
                    TypeMirror supertype = param.type();
                    if (!model.isSubtype(currentContextExpression.type(), supertype)) {
                        Method method = this.method();
                        throw new TypeException(String.format("Lambda context parameter is incorrect. details:\n                         method :  %s\n            current context type:  %s\n    lambda expected context type:  %s\n", method.methodElement(), currentContextExpression.type(), param.type()));
                    }
                    yield currentContextExpression;
                }
            };
            args.add(arg);
        }
        return this.method().expression().methodCall(this.method().methodElement(), args.toArray(new JavaExpression[0]));
    }

    public static Lambda of(JavaExpression expression, ExecutableElement method, @Nullable String name, String template) throws AnnotatedException {
        if (name == null || name.isBlank()) {
            name = method.getSimpleName().toString();
        }
        Method m = Method.of(expression, method, name, template);
        return new SimpleLambda(m);
    }

    public record Method(JavaExpression expression, String name, ExecutableElement methodElement, ReturnKind returnKind, List<Param> params, String template) {
        public static Method of(JavaExpression expression, ExecutableElement method, @Nullable String name, String template) throws AnnotatedException {
            ReturnKind returnType;
            boolean raw;
            if (name == null || name.isBlank()) {
                name = method.getSimpleName().toString();
            }
            JavaLanguageModel model = expression.model();
            List<? extends VariableElement> parameters = method.getParameters();
            if (parameters.size() > 2 || parameters.size() < 1) {
                throw new UnsupportedOperationException("Lambda can only support 1 or 2 parameters");
            }
            ArrayList<Param> params = new ArrayList<Param>();
            Iterator<? extends VariableElement> it = parameters.iterator();
            VariableElement p = it.next();
            boolean bl = raw = RawPrism.getInstanceOn(p) != null;
            if (raw && model.isType(p.asType(), model.knownTypes()._String)) {
                params.add(new Param(name, ParamType.STRING_BODY, p.asType()));
            } else {
                if (raw) {
                    throw new AnnotatedException(p, "Only String types can be annotated with Raw");
                }
                params.add(new Param(name, ParamType.CURRENT_CONTEXT, p.asType()));
                if (it.hasNext()) {
                    throw new UnsupportedOperationException("Lambdas can only have one context parameter");
                }
            }
            if (it.hasNext()) {
                p = it.next();
                params.add(new Param(name, ParamType.CURRENT_CONTEXT, p.asType()));
            }
            boolean bl2 = raw = RawPrism.getInstanceOn(method) != null;
            if (raw && model.isType(method.getReturnType(), model.knownTypes()._String)) {
                returnType = ReturnKind.RAW_STRING;
            } else {
                if (raw) {
                    throw new AnnotatedException(method, "Only String return types can be annotated with Raw");
                }
                returnType = ReturnKind.MODEL;
            }
            return new Method(expression, name, method, returnType, params, template);
        }
    }

    public record Param(String name, ParamType paramType, TypeMirror type) {
    }

    public static enum ParamType {
        STRING_BODY,
        CURRENT_CONTEXT;

    }

    public record SimpleLambda(Method method) implements Lambda
    {
    }

    public static class Lambdas {
        private final Map<String, Lambda> lambdas;

        public Lambdas(Map<String, Lambda> lambdas) {
            this.lambdas = lambdas;
        }

        public Map<String, Lambda> lambdas() {
            return this.lambdas;
        }
    }

    public static enum ReturnKind {
        RAW_STRING,
        MODEL;

    }
}

