/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.VariableContext;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.Nullable;

class ListRenderingContext
implements RenderingContext.ChildRenderingContext {
    private final JavaExpression listExpression;
    private final String indexVariableName;
    private final RenderingContext parent;

    public ListRenderingContext(JavaExpression listExpression, String indexVariableName, RenderingContext parent) {
        this.listExpression = listExpression;
        this.indexVariableName = indexVariableName;
        this.parent = parent;
    }

    @Override
    public String beginSectionRenderingCode() {
        return this.parent.beginSectionRenderingCode() + String.format("for (int %s = 0; %s < %s; %s++) { ", this.indexVariableName, this.indexExpression().text(), this.listExpression.listSize().text(), this.indexExpression().text());
    }

    @Override
    public String endSectionRenderingCode() {
        return "}" + this.parent.endSectionRenderingCode();
    }

    JavaExpression componentExpession() {
        JavaLanguageModel model = this.listExpression.model();
        DeclaredType dt = (DeclaredType)this.listExpression.type();
        List<? extends Element> all = model.getElements().getAllMembers((TypeElement)dt.asElement());
        ExecutableElement getMethod = ElementFilter.methodsIn(all).stream().filter(e -> "get".equals(e.getSimpleName().toString()) && e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getReturnType().getKind() != TypeKind.VOID && e.getParameters().size() == 1 && model.isType(e.getParameters().get(0).asType(), model.knownTypes()._int)).findFirst().orElse(null);
        if (getMethod == null) {
            throw new IllegalStateException("List missing get? bug.");
        }
        return this.listExpression.methodCall(getMethod, this.indexExpression());
    }

    @Override
    public @Nullable JavaExpression get(String name) throws ContextException {
        return null;
    }

    @Override
    public JavaExpression currentExpression() {
        return this.listExpression;
    }

    @Override
    public VariableContext createEnclosedVariableContext() {
        return this.parent.createEnclosedVariableContext();
    }

    private JavaExpression indexExpression() {
        return this.listExpression.model().expression(this.indexVariableName, this.listExpression.model().knownTypes()._int);
    }

    @Override
    public RenderingContext getParent() {
        return this.parent;
    }
}

