/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.context;

import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.FormatterTypes;
import io.jstach.apt.internal.context.ArrayRenderingContext;
import io.jstach.apt.internal.context.BlockRenderingContext;
import io.jstach.apt.internal.context.BooleanRenderingContext;
import io.jstach.apt.internal.context.ContextNodeRenderingContext;
import io.jstach.apt.internal.context.DeclaredTypeRenderingContext;
import io.jstach.apt.internal.context.EnumRenderingContext;
import io.jstach.apt.internal.context.InvertedExpressionContext;
import io.jstach.apt.internal.context.IterableRenderingContext;
import io.jstach.apt.internal.context.JavaExpression;
import io.jstach.apt.internal.context.JavaLanguageModel;
import io.jstach.apt.internal.context.Lambda;
import io.jstach.apt.internal.context.ListRenderingContext;
import io.jstach.apt.internal.context.MapRenderingContext;
import io.jstach.apt.internal.context.NoDataContext;
import io.jstach.apt.internal.context.OptionalRenderingContext;
import io.jstach.apt.internal.context.PrimitiveRenderingContext;
import io.jstach.apt.internal.context.RenderingContext;
import io.jstach.apt.internal.context.RootRenderingContext;
import io.jstach.apt.internal.context.TemplateCompilerContext;
import io.jstach.apt.internal.context.TemplateStack;
import io.jstach.apt.internal.context.TypeException;
import io.jstach.apt.internal.context.VariableContext;
import io.jstach.apt.internal.context.VariablesRenderingContext;
import io.jstach.apt.internal.context.types.KnownType;
import io.jstach.apt.internal.context.types.KnownTypes;
import io.jstach.apt.internal.context.types.NativeType;
import io.jstach.apt.internal.context.types.ObjectType;
import io.jstach.apt.prism.JStacheLambdaPrism;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RenderingCodeGenerator {
    private final KnownTypes knownTypes;
    protected final JavaLanguageModel javaModel;
    private final FormatterTypes formatterTypes;
    private FormatterTypes.FormatCallType formatCallType;
    private boolean USE_LIST_CONTEXT = Boolean.getBoolean("USE_LIST_CONTEXT");

    public static RenderingCodeGenerator createInstance(JavaLanguageModel javaModel, FormatterTypes formatterTypes, FormatterTypes.FormatCallType formatCallType) {
        return new RenderingCodeGenerator(javaModel.knownTypes(), javaModel, formatterTypes, formatCallType);
    }

    private RenderingCodeGenerator(KnownTypes types, JavaLanguageModel javaModel, FormatterTypes formatterTypes, FormatterTypes.FormatCallType formatCallType) {
        this.knownTypes = types;
        this.javaModel = javaModel;
        this.formatterTypes = formatterTypes;
        this.formatCallType = formatCallType;
    }

    public FormatterTypes.FormatCallType getFormatCallType() {
        return this.formatCallType;
    }

    public void setFormatCallType(FormatterTypes.FormatCallType formatCallType) {
        this.formatCallType = formatCallType;
    }

    String generateRenderingCode(JavaExpression expression, VariableContext variables, String path) throws TypeException {
        DeclaredType dt;
        String cname;
        TypeMirror type = expression.type();
        String text = expression.text();
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            TypeMirror bound = RenderingCodeGenerator.resolveBound(wildcardType);
            return this.generateRenderingCode(this.javaModel.expression(text, bound), variables, path);
        }
        KnownType knownType = this.javaModel.resolveType(type).orElse(null);
        if (this.isDirectFormat(type, knownType)) {
            return this.renderFormatCall(variables, path, text);
        }
        if (knownType != null && knownType instanceof ObjectType) {
            String cname2 = knownType.renderClassName() + ".class";
            return this.renderFormatCall(variables, path, text, cname2);
        }
        if (type instanceof DeclaredType && this.formatterTypes.isMatch(cname = this.javaModel.eraseType(dt = (DeclaredType)type))) {
            return this.renderFormatCall(variables, path, text, cname + ".class");
        }
        throw new TypeException(MessageFormat.format("Can''t render {0} expression of {1} type as it is not an allowed type to format. ", text, type));
    }

    private boolean isDirectFormat(TypeMirror type, @Nullable KnownType kt) {
        KnownType formattableType = this.knownTypes._Formattable.orElse(null);
        if (formattableType != null && formattableType.isSupertype(type)) {
            return true;
        }
        if (kt == null) {
            return false;
        }
        return kt instanceof NativeType || kt.equals(this.knownTypes._String);
    }

    private String renderFormatCall(VariableContext variables, String path, String text, String cname) {
        return switch (this.formatCallType) {
            default -> throw new IncompatibleClassChangeError();
            case FormatterTypes.FormatCallType.JSTACHIO, FormatterTypes.FormatCallType.JSTACHIO_BYTE -> this.renderFormatCallJStache(variables, path, text, cname);
            case FormatterTypes.FormatCallType.STACHE -> this.renderFormatCallStache(variables, text);
        };
    }

    private String renderFormatCall(VariableContext variables, String path, String text) {
        return switch (this.formatCallType) {
            default -> throw new IncompatibleClassChangeError();
            case FormatterTypes.FormatCallType.JSTACHIO, FormatterTypes.FormatCallType.JSTACHIO_BYTE -> this.renderFormatCallJStache(variables, path, text);
            case FormatterTypes.FormatCallType.STACHE -> this.renderFormatCallStache(variables, text);
        };
    }

    private String renderFormatCallJStache(VariableContext variables, String path, String text) {
        return variables.formatter() + ".format(" + variables.escaper() + ", " + variables.unescapedWriter() + ", \"" + path + "\", " + text + ");";
    }

    private String renderFormatCallJStache(VariableContext variables, String path, String text, String cname) {
        return variables.formatter() + ".format(" + variables.escaper() + ", " + variables.unescapedWriter() + ", \"" + path + "\", " + cname + ", " + text + ");";
    }

    private String renderFormatCallStache(VariableContext variables, String text) {
        String fmt = variables.formatter() + ".apply(" + text + ")";
        if (variables.isEscaped()) {
            fmt = variables.escaper() + ".apply(" + fmt + ")";
        }
        return variables.unescapedWriter() + ".append(" + fmt + ");";
    }

    private Lambda.Lambdas resolveLambdas(TypeElement element, JavaExpression root) throws AnnotatedException {
        List<? extends Element> all = this.javaModel.getElements().getAllMembers(element);
        List lambdaMethods = ElementFilter.methodsIn(all).stream().filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getReturnType().getKind() != TypeKind.VOID).flatMap(e -> Stream.ofNullable(JStacheLambdaPrism.getInstanceOn(e)).map(p -> Map.entry(e, p))).toList();
        LinkedHashMap<String, Lambda> lambdas = new LinkedHashMap<String, Lambda>();
        for (Map.Entry e2 : lambdaMethods) {
            JStacheLambdaPrism p = (JStacheLambdaPrism)e2.getValue();
            ExecutableElement method = (ExecutableElement)e2.getKey();
            String name = p.name();
            String template = p.template();
            Lambda lambda = Lambda.of(root, method, name, template);
            lambdas.put(lambda.name(), lambda);
        }
        return new Lambda.Lambdas(lambdas);
    }

    public TemplateCompilerContext createTemplateCompilerContext(TemplateStack templateStack, TypeElement element, String expression, VariableContext variables) throws AnnotatedException {
        JavaExpression javaExpression = this.javaModel.expression(expression, this.javaModel.getDeclaredType(element, new TypeMirror[0]));
        RootRenderingContext root = new RootRenderingContext(javaExpression, variables);
        Lambda.Lambdas lambdas = this.resolveLambdas(element, javaExpression);
        InvertedExpressionContext rootRenderingContext = this.javaModel.isType(element.asType(), this.knownTypes._ContextNode) ? new ContextNodeRenderingContext(javaExpression, element, root) : (this.javaModel.isType(element.asType(), this.knownTypes._Map) ? new MapRenderingContext(javaExpression, element, root) : new DeclaredTypeRenderingContext(javaExpression, element, root));
        return new TemplateCompilerContext(templateStack, lambdas, this, variables, (RenderingContext)((Object)rootRenderingContext), TemplateCompilerContext.ContextType.ROOT);
    }

    RenderingContext createRenderingContext(TemplateCompilerContext.ContextType childType, JavaExpression expression, RenderingContext enclosing) throws TypeException {
        RenderingContext nullable;
        ObjectType contextNode = this.knownTypes._ContextNode.orElse(null);
        if (contextNode != null && contextNode.isType(expression.type())) {
            return switch (childType) {
                case TemplateCompilerContext.ContextType.SECTION -> this.createIterableContext(expression, enclosing);
                default -> this.createContextNodeContext(expression, enclosing);
            };
        }
        TypeMirror typeMirror = expression.type();
        if (typeMirror instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)typeMirror;
            TypeMirror bound = RenderingCodeGenerator.resolveBound(wildcardType);
            return this.createRenderingContext(childType, this.javaModel.expression(expression.text(), bound), enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._boolean) && !childType.isVar() && childType != TemplateCompilerContext.ContextType.ROOT) {
            return new BooleanRenderingContext(expression.text(), enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Boolean) && !childType.isVar() && childType != TemplateCompilerContext.ContextType.ROOT) {
            RenderingContext nullableContext = this.nullableRenderingContext(expression, enclosing);
            BooleanRenderingContext booleanContext = new BooleanRenderingContext(expression.text(), nullableContext);
            return booleanContext;
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Optional)) {
            return this.createOptionalContext(childType, expression, enclosing);
        }
        if (this.USE_LIST_CONTEXT && this.javaModel.isType(expression.type(), this.knownTypes._List)) {
            nullable = this.nullableRenderingContext(expression, enclosing);
            VariableContext variableContext = nullable.createEnclosedVariableContext();
            String indexVariableName = variableContext.introduceNewNameLike("i");
            VariablesRenderingContext variables = new VariablesRenderingContext(variableContext, nullable);
            ListRenderingContext list = new ListRenderingContext(expression, indexVariableName, variables);
            return this.createRenderingContext(childType, list.componentExpession(), list);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Iterable) && childType == TemplateCompilerContext.ContextType.SECTION) {
            return this.createIterableContext(expression, enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Map)) {
            return this.createMapContext(expression, enclosing);
        }
        if (expression.type().getKind() == TypeKind.ARRAY) {
            nullable = this.nullableRenderingContext(expression, enclosing);
            VariableContext variableContext = nullable.createEnclosedVariableContext();
            String indexVariableName = variableContext.introduceNewNameLike("i");
            VariablesRenderingContext variables = new VariablesRenderingContext(variableContext, nullable);
            ArrayRenderingContext array = new ArrayRenderingContext(expression, indexVariableName, variables);
            return this.createRenderingContext(childType, array.componentExpession(), array);
        }
        if (expression.type().getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)expression.type();
            RenderingContext parent = switch (childType) {
                default -> throw new IncompatibleClassChangeError();
                case TemplateCompilerContext.ContextType.ESCAPED_VAR, TemplateCompilerContext.ContextType.UNESCAPED_VAR, TemplateCompilerContext.ContextType.SECTION_VAR -> enclosing;
                case TemplateCompilerContext.ContextType.SECTION, TemplateCompilerContext.ContextType.ROOT, TemplateCompilerContext.ContextType.PATH, TemplateCompilerContext.ContextType.INVERTED, TemplateCompilerContext.ContextType.PARENT_PARTIAL -> this.nullableRenderingContext(expression, enclosing);
                case TemplateCompilerContext.ContextType.BLOCK, TemplateCompilerContext.ContextType.LAMBDA, TemplateCompilerContext.ContextType.PARTIAL -> throw new UnsupportedOperationException("Unimplemented case: " + childType);
            };
            return this.createDeclaredContext(expression, declaredType, parent);
        }
        if (expression.type() instanceof PrimitiveType) {
            return new PrimitiveRenderingContext(expression, enclosing);
        }
        return new NoDataContext(expression, enclosing);
    }

    private static TypeMirror resolveBound(WildcardType wildcardType) throws TypeException {
        TypeMirror bound = wildcardType.getExtendsBound();
        if (bound == null) {
            bound = wildcardType.getSuperBound();
        }
        if (bound == null) {
            throw new TypeException("Cannot handle wildcards with out bounds! type: " + wildcardType);
        }
        return bound;
    }

    private DeclaredTypeRenderingContext createDeclaredContext(JavaExpression expression, DeclaredType declaredType, RenderingContext parent) {
        TypeElement typeElement = this.javaModel.asElement(declaredType);
        DeclaredTypeRenderingContext declaredContext = this.knownTypes._Enum.isType(declaredType) ? new EnumRenderingContext(expression, typeElement, parent) : new DeclaredTypeRenderingContext(expression, typeElement, parent);
        return declaredContext;
    }

    private RenderingContext createOptionalContext(TemplateCompilerContext.ContextType childType, JavaExpression expression, RenderingContext enclosing) throws TypeException {
        DeclaredType declaredType = (DeclaredType)expression.type();
        OptionalRenderingContext optional = new OptionalRenderingContext(expression, this.javaModel.asElement(declaredType), enclosing);
        return this.createRenderingContext(childType, optional.currentExpression(), optional);
    }

    private RenderingContext createMapContext(JavaExpression expression, RenderingContext enclosing) {
        RenderingContext nullable = this.nullableRenderingContext(expression, enclosing);
        DeclaredType mapType = (DeclaredType)expression.type();
        MapRenderingContext map = new MapRenderingContext(expression, this.javaModel.asElement(mapType), nullable);
        return map;
    }

    private RenderingContext createContextNodeContext(JavaExpression expression, RenderingContext enclosing) {
        RenderingContext nullable = this.nullableRenderingContext(expression, enclosing);
        DeclaredType mapType = (DeclaredType)expression.type();
        ContextNodeRenderingContext map = new ContextNodeRenderingContext(expression, this.javaModel.asElement(mapType), nullable);
        return map;
    }

    private RenderingContext createIterableContext(JavaExpression expression, RenderingContext enclosing) throws TypeException {
        RenderingContext nullable = this.nullableRenderingContext(expression, enclosing);
        VariableContext variableContext = nullable.createEnclosedVariableContext();
        String elementVariableName = variableContext.introduceNewNameLike("element");
        String indexVariableName = variableContext.introduceNewNameLike("i");
        VariablesRenderingContext variables = new VariablesRenderingContext(variableContext, nullable);
        IterableRenderingContext iterable = new IterableRenderingContext(expression, elementVariableName, indexVariableName, variables);
        if (expression.model().isType(expression.type(), this.knownTypes._ContextNode)) {
            return this.createContextNodeContext(iterable.elementExpession(), iterable);
        }
        return this.createRenderingContext(TemplateCompilerContext.ContextType.SECTION_VAR, iterable.elementExpession(), iterable);
    }

    RenderingContext createInvertedRenderingContext(JavaExpression expression, RenderingContext enclosing) throws TypeException {
        Object c;
        TypeMirror optionalContext2;
        if (this.knownTypes._Iterable.isType(expression.type()) && !expression.model().isType(expression.type(), this.knownTypes._ContextNode)) {
            return new BooleanRenderingContext("(" + expression.text() + " == null ) || ! " + expression.text() + ".iterator().hasNext()", enclosing);
        }
        if (expression.type() instanceof WildcardType) {
            throw new IllegalStateException("bug");
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._boolean)) {
            return new BooleanRenderingContext("!(" + expression.text() + ")", enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Boolean)) {
            return new BooleanRenderingContext("(" + expression.text() + ") == null || !(" + expression.text() + ")", enclosing);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._Optional)) {
            RenderingContext optionalContext2 = this.createOptionalContext(TemplateCompilerContext.ContextType.INVERTED, expression, enclosing);
            return new BooleanRenderingContext("(" + expression.text() + ".isEmpty())", optionalContext2);
        }
        if (this.javaModel.isType(expression.type(), this.knownTypes._ContextNode) && (optionalContext2 = expression.type()) instanceof DeclaredType) {
            @NonNull DeclaredType dt = (DeclaredType)optionalContext2;
            c = new ContextNodeRenderingContext(expression, this.javaModel.asElement(dt), enclosing);
            return new BooleanRenderingContext(this.knownTypes._ContextNode.get().typeElement().getQualifiedName().toString() + ".isFalsey(" + expression.text() + ")", (RenderingContext)c);
        }
        c = expression.type();
        if (c instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)c;
            DeclaredTypeRenderingContext declaredContext = this.createDeclaredContext(expression, dt, enclosing);
            String nullable = "(" + expression.text() + ") == null";
            if (this.knownTypes._Object.isSameType(dt)) {
                nullable = " || Boolean.FALSE.equals(" + expression.text() + ")";
            }
            return new BooleanRenderingContext(nullable, declaredContext);
        }
        if (expression.type() instanceof ArrayType) {
            return new BooleanRenderingContext("(" + expression.text() + ") == null || (" + expression.text() + ").length == 0", enclosing);
        }
        throw new TypeException(MessageFormat.format("Can''t invert {0} expression of {1} type", expression.text(), expression.type()));
    }

    private RenderingContext nullableRenderingContext(JavaExpression expression, RenderingContext context) {
        VariableContext.NullChecking nullChecking = context.variableContext().nullChecking();
        if (this.javaModel.isSameType(expression.type(), this.knownTypes._Object.typeElement().asType())) {
            String nullableCheck = nullChecking.isNullable(expression) ? expression.text() + " != null && " : "";
            return new BooleanRenderingContext(nullableCheck + " ! Boolean.FALSE.equals(" + expression.text() + ")", context);
        }
        if (nullChecking.isNullable(expression)) {
            return new BooleanRenderingContext(expression.text() + " != null", context);
        }
        return new BlockRenderingContext(context);
    }
}

