/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.escape;

import io.jstach.apt.internal.escape.AggregateTranslator;
import io.jstach.apt.internal.escape.CharSequenceTranslator;
import io.jstach.apt.internal.escape.JavaUnicodeEscaper;
import io.jstach.apt.internal.escape.LookupTranslator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EscapeUtils {
    private static final Map<CharSequence, CharSequence> JAVA_CTRL_CHARS_ESCAPE;
    static final CharSequenceTranslator ESCAPE_JAVA;

    public static String escapeJava(String text) {
        return ESCAPE_JAVA.translate(text);
    }

    static {
        HashMap<String, String> initialMap = new HashMap<String, String>();
        initialMap.put("\b", "\\b");
        initialMap.put("\n", "\\n");
        initialMap.put("\t", "\\t");
        initialMap.put("\f", "\\f");
        initialMap.put("\r", "\\r");
        JAVA_CTRL_CHARS_ESCAPE = Collections.unmodifiableMap(initialMap);
        HashMap<String, String> escapeJavaMap = new HashMap<String, String>();
        escapeJavaMap.put("\"", "\\\"");
        escapeJavaMap.put("\\", "\\\\");
        ESCAPE_JAVA = new AggregateTranslator(new LookupTranslator(Collections.unmodifiableMap(escapeJavaMap)), new LookupTranslator(JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf(32, 127));
    }
}

