/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public record Delimiters(char start1, char start2, char end1, char end2) {
    private static final Delimiters defaultDelimiters = new Delimiters('{', '{', '}', '}');
    public static final char NO_CHAR = '\u0000';

    public static Delimiters of() {
        return defaultDelimiters;
    }

    public static Delimiters of(String content) throws DelimiterParsingException {
        char end1;
        char start1;
        String[] delims = content.trim().split("\\s+");
        if (delims.length != 2) {
            throw new DelimiterParsingException(content);
        }
        return new Delimiters(start1, switch (delims[0].length()) {
            case 1 -> {
                start1 = delims[0].charAt(0);
                yield '\u0000';
            }
            case 2 -> {
                start1 = delims[0].charAt(0);
                yield delims[0].charAt(1);
            }
            default -> throw new DelimiterParsingException(content);
        }, end1, switch (delims[1].length()) {
            case 1 -> {
                end1 = delims[1].charAt(0);
                yield '\u0000';
            }
            case 2 -> {
                end1 = delims[1].charAt(0);
                yield delims[1].charAt(1);
            }
            default -> throw new DelimiterParsingException(content);
        });
    }

    public boolean isDefault() {
        return defaultDelimiters.equals(this);
    }

    public Appendable appendStart(Appendable a) throws IOException {
        a.append(this.start1);
        if (this.requiresStart2()) {
            a.append(this.start2);
        }
        return a;
    }

    public Appendable appendStartEscape(Appendable a) throws IOException {
        this.appendStart(a);
        a.append(this.start3());
        return a;
    }

    public Appendable appendEndEscape(Appendable a) throws IOException {
        this.appendEnd(a);
        a.append(this.end3());
        return a;
    }

    public Appendable appendEnd(Appendable a) throws IOException {
        a.append(this.end1);
        if (this.requiresEnd2()) {
            a.append(this.end2);
        }
        return a;
    }

    public boolean requiresStart2() {
        return this.start2 != '\u0000';
    }

    public boolean requiresEnd2() {
        return this.end2 != '\u0000';
    }

    public char start3() {
        return '{';
    }

    public char end3() {
        return '}';
    }

    static class DelimiterParsingException
    extends Exception {
        private static final long serialVersionUID = -6891726165744713522L;
        private final String message;

        public DelimiterParsingException(String content) {
            super("Cannot parse delimiters from '" + content + "'");
            this.message = "Cannot parse delimiters from '" + content + "'";
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class Publisher {
        private List<Subscriber> subscribers = new ArrayList<Subscriber>();
        private Delimiters delimiters = Delimiters.of();

        public void subscribe(Subscriber subscriber) {
            this.subscribers.add(subscriber);
            subscriber.setDelimters(this.delimiters);
        }

        public void setDelimiters(Delimiters delimiters) {
            this.delimiters = delimiters;
            for (Subscriber s : this.subscribers) {
                s.setDelimters(delimiters);
            }
        }

        public Delimiters getDelimiters() {
            return this.delimiters;
        }
    }

    public static interface Subscriber {
        public void setDelimters(Delimiters var1);
    }
}

