/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token;

import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.token.MustacheTokenizer;
import io.jstach.apt.internal.token.MustacheTokenizerState;
import io.jstach.apt.internal.token.OutsideMustacheTokenizerState;
import org.eclipse.jdt.annotation.Nullable;

class EndMustacheTokenizerState
implements MustacheTokenizerState {
    private final MustacheTokenizer tokenizer;
    private final boolean expectsThree;

    EndMustacheTokenizerState(MustacheTokenizer tokenizer, boolean expectsThree) {
        this.tokenizer = tokenizer;
        this.expectsThree = expectsThree;
    }

    @Override
    public @Nullable Void twoOpenBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected open braces");
        return null;
    }

    @Override
    public @Nullable Void threeOpenBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected open braces");
        return null;
    }

    @Override
    public @Nullable Void twoClosingBraces() throws ProcessingException {
        if (this.expectsThree) {
            this.tokenizer.error("Expects three closing braces, not two");
        } else {
            this.tokenizer.setState(new OutsideMustacheTokenizerState(this.tokenizer));
        }
        return null;
    }

    @Override
    public @Nullable Void threeClosingBraces() throws ProcessingException {
        if (this.expectsThree) {
            this.tokenizer.setState(new OutsideMustacheTokenizerState(this.tokenizer));
        } else {
            this.tokenizer.error("Expects two closing braces, not three");
        }
        return null;
    }

    @Override
    public @Nullable Void character(char c) throws ProcessingException {
        if (!Character.isWhitespace(c)) {
            this.tokenizer.error("Unrecognized character " + c);
        }
        return null;
    }

    @Override
    public @Nullable Void endOfFile() throws ProcessingException {
        this.tokenizer.error("Unclosed field at the end of file");
        return null;
    }

    @Override
    public void beforeStateChange() throws ProcessingException {
    }
}

