/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token.util;

import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import io.jstach.apt.internal.token.BracesToken;
import io.jstach.apt.internal.token.Delimiters;
import io.jstach.apt.internal.token.util.PositionAnnotator;
import io.jstach.apt.internal.token.util.PositionedTransformer;
import io.jstach.apt.internal.token.util.TokenProcessorDecorator;
import org.eclipse.jdt.annotation.Nullable;

public class BracesTokenizer
implements TokenProcessor<Character>,
Delimiters.Subscriber {
    private final TokenProcessor<BracesToken> downstream;
    private State state = State.NONE;
    private Delimiters delim = Delimiters.of();
    char lastChar;

    static TokenProcessorDecorator<@Nullable Character, BracesToken> decorator(final Delimiters.Publisher publisher) {
        return new TokenProcessorDecorator<Character, BracesToken>(){

            @Override
            public TokenProcessor<@Nullable Character> decorateTokenProcessor(TokenProcessor<BracesToken> downstream) {
                BracesTokenizer bt = new BracesTokenizer(downstream);
                publisher.subscribe(bt);
                return bt;
            }
        };
    }

    public static TokenProcessor<@Nullable Character> createInstance(String fileName, TokenProcessor<PositionedToken<BracesToken>> downstream, Delimiters.Publisher publisher) {
        TokenProcessor<PositionedToken<@Nullable Character>> paransisTokenizer = PositionedTransformer.decorateTokenProcessor(BracesTokenizer.decorator(publisher), downstream);
        return new PositionAnnotator(fileName, paransisTokenizer);
    }

    public BracesTokenizer(TokenProcessor<BracesToken> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void setDelimters(Delimiters delimiters) {
        this.delim = delimiters;
    }

    private void t(BracesToken.TokenType type) throws ProcessingException {
        switch (type) {
            case TWO_OPEN: {
                this.downstream.processToken(BracesToken.twoOpenBraces());
                break;
            }
            case TWO_CLOSE: {
                this.downstream.processToken(BracesToken.twoClosingBraces());
                break;
            }
            case THREE_OPEN: {
                this.downstream.processToken(BracesToken.threeOpenBraces());
                break;
            }
            case THREE_CLOSE: {
                this.downstream.processToken(BracesToken.threeClosingBraces());
                break;
            }
            case CHARACTER: {
                throw new IllegalStateException();
            }
            case EOF: {
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + type);
            }
        }
    }

    private void c(char t) throws ProcessingException {
        this.downstream.processToken(BracesToken.character(t));
    }

    @Override
    public void processToken(@Nullable Character token) throws ProcessingException {
        Delimiters delim = this.delim;
        if (token == null) {
            switch (this.state) {
                case NONE: {
                    break;
                }
                case WAS_OPEN: {
                    this.c(delim.start1());
                    break;
                }
                case WAS_OPEN_TWICE: {
                    this.t(BracesToken.TokenType.TWO_OPEN);
                    break;
                }
                case WAS_INSIDE: {
                    break;
                }
                case WAS_CLOSE: {
                    this.c(delim.end1());
                    break;
                }
                case WAS_CLOSE_TWICE: {
                    this.t(BracesToken.TokenType.TWO_CLOSE);
                }
            }
            this.state = State.NONE;
            this.downstream.processToken(BracesToken.endOfFile());
            return;
        }
        char c = token.charValue();
        State s = switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.NONE -> {
                if (delim.start1() == c) {
                    if (delim.requiresStart2()) {
                        yield State.WAS_OPEN;
                    }
                    yield State.WAS_OPEN_TWICE;
                }
                this.c(c);
                yield State.NONE;
            }
            case State.WAS_INSIDE -> {
                if (delim.end1() == c) {
                    if (delim.requiresStart2()) {
                        yield State.WAS_CLOSE;
                    }
                    yield State.WAS_CLOSE_TWICE;
                }
                this.c(c);
                yield State.WAS_INSIDE;
            }
            case State.WAS_OPEN -> {
                if (!delim.requiresStart2()) {
                    throw new IllegalStateException();
                }
                if (delim.start2() == c) {
                    yield State.WAS_OPEN_TWICE;
                }
                this.c(delim.start1());
                this.c(c);
                yield State.NONE;
            }
            case State.WAS_OPEN_TWICE -> {
                if (delim.start3() == c) {
                    this.t(BracesToken.TokenType.THREE_OPEN);
                    yield State.WAS_INSIDE;
                }
                this.t(BracesToken.TokenType.TWO_OPEN);
                this.c(c);
                yield State.WAS_INSIDE;
            }
            case State.WAS_CLOSE -> {
                if (!delim.requiresEnd2()) {
                    throw new IllegalStateException();
                }
                if (delim.end2() == c) {
                    yield State.WAS_CLOSE_TWICE;
                }
                this.c(delim.end1());
                this.c(c);
                yield State.NONE;
            }
            case State.WAS_CLOSE_TWICE -> {
                if (delim.end3() == c) {
                    this.t(BracesToken.TokenType.THREE_CLOSE);
                    yield State.NONE;
                }
                this.t(BracesToken.TokenType.TWO_CLOSE);
                delim = this.delim;
                if (delim.start1() == c) {
                    if (delim.requiresStart2()) {
                        yield State.WAS_OPEN;
                    }
                    yield State.WAS_OPEN_TWICE;
                }
                this.c(c);
                yield State.NONE;
            }
        };
        this.lastChar = c;
        this.state = s;
    }

    private static enum State {
        WAS_OPEN,
        WAS_OPEN_TWICE,
        WAS_INSIDE,
        WAS_CLOSE,
        WAS_CLOSE_TWICE,
        NONE;

    }
}

