/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.prism;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.Nullable;

public class JStacheFormatterPrism {
    private @Nullable String _providesMethod;
    public static final String PRISM_ANNOTATION_TYPE = "io.jstach.jstache.JStacheFormatter";
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>();
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>();
    private boolean valid = true;

    public static @Nullable JStacheFormatterPrism getInstanceOn(Element e) {
        AnnotationMirror m = JStacheFormatterPrism.getMirror(PRISM_ANNOTATION_TYPE, e);
        if (m == null) {
            return null;
        }
        return JStacheFormatterPrism.getInstance(m);
    }

    public static JStacheFormatterPrism getInstance(AnnotationMirror mirror) {
        String mirrorType = mirror.getAnnotationType().toString();
        if (!PRISM_ANNOTATION_TYPE.equals(mirrorType)) {
            throw new IllegalArgumentException("expected: io.jstach.jstache.JStacheFormatter got: " + mirrorType);
        }
        return new JStacheFormatterPrism(mirror);
    }

    private JStacheFormatterPrism(AnnotationMirror mirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : mirror.getElementValues().entrySet()) {
            this.memberValues.put(e.getKey().getSimpleName().toString(), e.getValue());
        }
        for (ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue = member.getDefaultValue();
            if (defaultValue == null) continue;
            this.defaults.put(member.getSimpleName().toString(), defaultValue);
        }
        this._providesMethod = this.getValue("providesMethod", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String providesMethod() {
        return JStacheFormatterPrism.requireMember(this._providesMethod);
    }

    private <T> @Nullable T getValue(String name, Class<T> clazz) {
        @Nullable T result = JStacheFormatterPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static @Nullable AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> @Nullable T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> T requireMember(@Nullable T t) {
        if (t == null) {
            throw new NoSuchElementException("prism is invalid");
        }
        return t;
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public @Nullable AnnotationValue providesMethod() {
            return this.values.get("providesMethod");
        }
    }
}

