/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.util.ClassRef;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

class CatalogClassWriter {
    private final Set<String> templateClassNames = new TreeSet<String>();
    private final ClassRef catalogClass;

    public CatalogClassWriter(String packageName, String catalogName) {
        this(ClassRef.of(packageName, catalogName));
    }

    public CatalogClassWriter(ClassRef catalogClass) {
        this.catalogClass = catalogClass;
    }

    void write(Appendable a) throws IOException {
        String packageName = this.catalogClass.getPackageName();
        String catalogName = this.catalogClass.getSimpleName();
        String _TemplateProvider = "io.jstach.jstachio.spi.TemplateProvider.GeneratedTemplateProvider";
        String _List = List.class.getCanonicalName();
        String _Template = "io.jstach.jstachio.Template";
        String _TemplateConfig = "io.jstach.jstachio.TemplateConfig";
        a.append("package " + packageName + ";\n");
        a.append("\n");
        a.append("/**\n");
        a.append(" * Generated template catalog.\n");
        a.append(" */\n");
        a.append("public class " + catalogName + " implements " + _TemplateProvider + " {\n");
        a.append("\n");
        a.append("    /**\n");
        a.append("     * Generated template catalog constructor for ServiceLoader.\n");
        a.append("     */\n");
        a.append("    public " + catalogName + "() {\n");
        a.append("    }\n");
        a.append("\n");
        a.append("    @Override\n");
        a.append("    public " + _List + "<" + _Template + "<?>> provideTemplates(" + _TemplateConfig + " templateConfig) {\n");
        a.append("        return " + _List + ".of(//\n");
        a.append(this.listTemplates("        new ", "(templateConfig)")).append(");\n");
        a.append("    }\n");
        a.append("}\n");
    }

    public void write(Filer filer, LoggingSupport logging) {
        try {
            JavaFileObject sourceFile = filer.createSourceFile(this.catalogClass.requireCanonicalName(), new Element[0]);
            try (Writer w = sourceFile.openWriter();){
                this.write(w);
            }
            logging.info("Wrote catalog class: " + this.catalogClass.requireCanonicalName());
        }
        catch (IOException ioe) {
            logging.error("error writing catalog class: ", ioe);
        }
    }

    String listTemplates(String prefix, String suffix) {
        return this.templateClassNames.stream().map(tn -> prefix + tn + suffix).collect(Collectors.joining(", //\n"));
    }

    void addAll(Collection<? extends ClassRef> templateClasses) {
        for (ClassRef classRef : templateClasses) {
            this.templateClassNames.add(classRef.requireCanonicalName());
        }
    }

    void addTemplateClasses(Collection<String> templateClassNames) {
        this.templateClassNames.addAll(templateClassNames);
    }
}

