/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.NamedReader;
import io.jstach.apt.WhitespaceTokenProcessor;
import io.jstach.apt.internal.CodeAppendable;
import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import io.jstach.apt.internal.token.MustacheTokenizer;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;

class FragmentTokenProcessor
extends WhitespaceTokenProcessor {
    private final String fragment;
    private final LoggingSupport logging;
    private final StringBuilder content = new StringBuilder();
    private final Deque<Section> section = new ArrayDeque<Section>();
    private State state = State.OUTSIDE;
    private String indent = "";
    private String processed = "";

    public FragmentTokenProcessor(String fragment, LoggingSupport logging) {
        this.fragment = fragment;
        this.logging = logging;
    }

    public String run(NamedReader reader) throws ProcessingException, IOException {
        int readResult;
        TokenProcessor<@Nullable Character> processor = MustacheTokenizer.createInstance(reader.name(), this);
        while ((readResult = reader.read()) >= 0) {
            try {
                processor.processToken(Character.valueOf((char)readResult));
            }
            catch (ProcessingException e) {
                if (this.logging.isDebug()) {
                    this.debug(e);
                }
                throw e;
            }
        }
        processor.processToken(EOF);
        this.processed = this.content.toString();
        return FragmentTokenProcessor.reindent(this.processed, this.indent);
    }

    @Override
    public LoggingSupport logging() {
        return this.logging;
    }

    @Nullable String lastSection() {
        Section s = this.section.peek();
        if (s == null) {
            return null;
        }
        return s.token().name();
    }

    public String getIndent() {
        return this.indent;
    }

    public boolean wasFound() {
        return State.FOUND == this.state;
    }

    static String reindent(String content, String indent) {
        if (indent.isEmpty()) {
            return content;
        }
        List<String> lines = CodeAppendable.split(content, "\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (line.equals("\n") || line.equals("\r\n")) {
                sb.append(line);
                continue;
            }
            if (line.startsWith(indent)) {
                sb.append(line.substring(indent.length()));
                continue;
            }
            return content;
        }
        return sb.toString();
    }

    @Override
    protected void processTokenGroup(List<WhitespaceTokenProcessor.ProcessToken> tokens) throws ProcessingException {
        WhitespaceTokenProcessor.ProcessToken first;
        if (this.hasFragmentStart(tokens.stream()) && (first = tokens.get(0)).hint() == WhitespaceTokenProcessor.ProcessToken.ProcessHint.INDENT) {
            StringBuilder leadingSpace = new StringBuilder();
            first.token().innerToken().appendRawText(leadingSpace);
            this.indent = leadingSpace.toString();
        }
        if (this.state == State.INSIDE) {
            if (this.hasFragmentEnd(tokens)) {
                this.processTokenGroup(this::handleToken, tokens);
            } else {
                for (WhitespaceTokenProcessor.ProcessToken t : tokens) {
                    this.handleToken(t.token());
                }
            }
        } else {
            super.processTokenGroup(tokens);
        }
    }

    boolean hasFragmentEnd(Iterable<WhitespaceTokenProcessor.ProcessToken> tokens) {
        for (WhitespaceTokenProcessor.ProcessToken pt : tokens) {
            if (!this.isFragmentEnd(pt)) continue;
            return true;
        }
        return false;
    }

    boolean hasFragmentStart(Stream<WhitespaceTokenProcessor.ProcessToken> tokens) {
        return tokens.filter(this::isFragmentStart).findFirst().isPresent();
    }

    boolean isFragmentEnd(WhitespaceTokenProcessor.ProcessToken token) {
        MustacheToken.TagToken tt;
        MustacheToken mt = token.token().innerToken();
        Section sec = this.section.peek();
        if (sec != null && mt instanceof MustacheToken.TagToken && (tt = (MustacheToken.TagToken)mt).tagKind().isEndSection()) {
            return sec.isFragment();
        }
        return false;
    }

    boolean isFragmentStart(WhitespaceTokenProcessor.ProcessToken token) {
        MustacheToken.TagToken tt;
        if (this.state != State.OUTSIDE) {
            return false;
        }
        MustacheToken mt = token.token().innerToken();
        return mt instanceof MustacheToken.TagToken && (tt = (MustacheToken.TagToken)mt).tagKind().isBeginSection() && tt.name().equals(this.fragment);
    }

    @Override
    protected void handleToken(PositionedToken<MustacheToken> positionedToken) throws ProcessingException {
        State nextState;
        if (this.state == State.FOUND) {
            return;
        }
        MustacheToken token = positionedToken.innerToken();
        if (token instanceof MustacheToken.TagToken) {
            MustacheToken.TagToken tt = (MustacheToken.TagToken)token;
            nextState = this.handleTag(tt, this.state);
        } else {
            nextState = token.isEOF() && this.state != State.FOUND ? State.NOT_FOUND : this.state;
        }
        State lastState = this.state;
        this.state = nextState;
        switch (nextState) {
            case INSIDE: {
                if (lastState == State.OUTSIDE) break;
                token.appendRawText(this.content);
                break;
            }
        }
    }

    private State handleTag(MustacheToken.TagToken tt, State state) throws ProcessingException {
        State nextState;
        String tagName = tt.name();
        @Nullable String lastSection = this.lastSection();
        boolean isFragmentName = this.fragment.equals(tagName);
        if (tt.tagKind().isBeginSection()) {
            if (isFragmentName && state == State.OUTSIDE) {
                this.section.push(new Section(tt, true));
                nextState = State.INSIDE;
            } else {
                this.section.push(new Section(tt, false));
                nextState = state;
            }
        } else if (tt.tagKind().isEndSection()) {
            this.validateEndSection(lastSection, tt);
            Section sec = this.section.pop();
            nextState = sec.isFragment() ? State.FOUND : state;
        } else {
            nextState = state;
        }
        return nextState;
    }

    private void validateEndSection(@Nullable String lastSection, MustacheToken.TagToken tt) throws ProcessingException {
        if (lastSection == null) {
            throw new ProcessingException(this.position, "Close section for no open section: " + tt.name());
        }
        if (!lastSection.equals(tt.name())) {
            throw new ProcessingException(this.position, "Close section of: " + tt.name() + " does not match current open section: " + lastSection);
        }
    }

    private static enum State {
        INSIDE,
        OUTSIDE,
        FOUND,
        NOT_FOUND;

    }

    private record Section(MustacheToken.TagToken token, boolean isFragment) {
    }
}

