/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt;

import io.jstach.apt.AbstractTemplateCompiler;
import io.jstach.apt.NamedReader;
import io.jstach.apt.PartialParameterProcessor;
import io.jstach.apt.Section;
import io.jstach.apt.TemplateCompilerLike;
import io.jstach.apt.WhitespaceTokenProcessor;
import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.CodeAppendable;
import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.MustacheTokenProcessor;
import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.TemplateCompilerContext;
import io.jstach.apt.internal.context.TemplateStack;
import io.jstach.apt.internal.token.MustacheTagKind;
import io.jstach.apt.internal.token.MustacheTokenizer;
import io.jstach.apt.internal.util.ClassRef;
import io.jstach.apt.prism.Prisms;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

abstract class TemplateCompiler
extends AbstractTemplateCompiler {
    private final NamedReader reader;
    private TemplateCompilerContext context;
    private final LoggingSupport logging;
    int depth = 0;
    private final String codeTab = "    ";
    protected String baseCodeTab = "        ";
    StringBuilder currentUnescaped = new StringBuilder();
    StringBuilder rawLambdaContent = new StringBuilder();
    String indent = "";
    private @Nullable TemplateCompilerLike.ParameterPartial _partial;

    public static TemplateCompiler createCompiler(String templateName, TemplateCompilerLike.TemplateLoader templateLoader, CodeAppendable writer, TemplateCompilerContext context, Set<Prisms.Flag> flags) throws IOException {
        return new RootTemplateCompiler(templateName, templateLoader, writer, context, flags);
    }

    protected TemplateCompiler(NamedReader reader, TemplateCompilerContext context) {
        this.reader = reader;
        this.context = context;
        this.logging = context.getTemplateStack();
    }

    @Override
    public void run() throws ProcessingException, IOException {
        int readResult;
        TokenProcessor<@Nullable Character> processor = MustacheTokenizer.createInstance(this.reader.name(), this);
        while ((readResult = this.reader.read()) >= 0) {
            try {
                processor.processToken(Character.valueOf((char)readResult));
            }
            catch (ProcessingException e) {
                if (this.isDebug()) {
                    String m = e.getMessage();
                    if (m != null) {
                        this.debug(m);
                    }
                    this.debug(this.context.getTemplateStack().describeTemplateStack());
                    this.debug(this.context.printStack());
                    this.debug(e);
                }
                throw e;
            }
        }
        processor.processToken(TokenProcessor.EOF);
        this.currentWriter().println();
    }

    @Override
    public LoggingSupport logging() {
        return this.logging;
    }

    @Override
    protected void processTokenGroup(List<WhitespaceTokenProcessor.ProcessToken> tokens) throws ProcessingException {
        TemplateCompilerLike.ParameterPartial p = this.currentParameterPartial();
        if (this.inLambda()) {
            this.processInsideLambdaToken(tokens);
        } else if (p != null) {
            this.processInsideParameterPartial(tokens, true);
        } else if (this.containsParentSection(tokens)) {
            this.processInsideParameterPartial(tokens, false);
        } else {
            super.processTokenGroup(tokens);
        }
    }

    void processInsideLambdaToken(List<WhitespaceTokenProcessor.ProcessToken> tokens) throws ProcessingException {
        boolean standaloneEnd;
        String lambdaName = this.context.currentEnclosedContextName();
        boolean finished = false;
        boolean bl = standaloneEnd = !tokens.stream().filter((? super T t) -> !t.token().innerToken().isSectionEndToken(lambdaName) && t.hint() == WhitespaceTokenProcessor.ProcessToken.ProcessHint.NORMAL).findAny().isPresent();
        if (this.isDebug()) {
            this.debug("lambda = " + lambdaName + " standaloneEnd = " + standaloneEnd);
        }
        for (WhitespaceTokenProcessor.ProcessToken t2 : tokens) {
            MustacheToken mt = t2.token().innerToken();
            if (mt.isSectionEndToken(lambdaName)) {
                finished = true;
                super._processToken(t2.token());
                continue;
            }
            if (mt.isEOF()) {
                if (finished) continue;
                throw new ProcessingException(this.position, "EOF reached before lambda closing tag found. lambda = \"" + lambdaName + "\"");
            }
            if (!standaloneEnd && !finished) {
                mt.appendRawText(this.rawLambdaContent);
                mt.appendEscapedJava(this.currentUnescaped);
                continue;
            }
            if (!finished) continue;
            this.debug("finished token: ", t2);
        }
    }

    boolean containsParentSection(List<WhitespaceTokenProcessor.ProcessToken> tokens) {
        return tokens.stream().filter((? super T t) -> {
            MustacheToken.TagToken tt;
            MustacheToken patt6680$temp = t.token().innerToken();
            return patt6680$temp instanceof MustacheToken.TagToken && (tt = (MustacheToken.TagToken)patt6680$temp).tagKind() == MustacheTagKind.BEGIN_PARENT_SECTION;
        }).findFirst().isPresent();
    }

    protected void processInsideParameterPartial(List<WhitespaceTokenProcessor.ProcessToken> tokens, final boolean _insideParent) throws ProcessingException {
        MustacheTokenProcessor parentProcessor = new MustacheTokenProcessor(){
            boolean insideParent;
            {
                this.insideParent = _insideParent;
            }

            @Override
            public void processToken(PositionedToken<MustacheToken> token) throws ProcessingException {
                MustacheToken.TagToken tt;
                MustacheToken mt = token.innerToken();
                if (!this.insideParent && mt instanceof MustacheToken.TagToken && (tt = (MustacheToken.TagToken)mt).tagKind() == MustacheTagKind.BEGIN_PARENT_SECTION) {
                    this.insideParent = true;
                    TemplateCompiler.this.startParentSection(token);
                } else if (this.insideParent) {
                    if (TemplateCompiler.this.processInsideParameterPartial(token)) {
                        this.insideParent = false;
                    }
                } else {
                    TemplateCompiler.this._processToken(token);
                }
            }
        };
        this.processTokenGroup(parentProcessor, tokens);
    }

    void startParentSection(PositionedToken<MustacheToken> token) throws ProcessingException {
        this.flushUnescaped();
        MustacheToken mustacheToken = token.innerToken();
        if (!(mustacheToken instanceof MustacheToken.TagToken)) {
            throw new IllegalStateException("bug");
        }
        MustacheToken.TagToken tt = (MustacheToken.TagToken)mustacheToken;
        String name = tt.name();
        TemplateCompilerLike.ParameterPartial p = this.currentParameterPartial();
        if (p != null) {
            throw new IllegalStateException("parent (parameter partial) is already started for this context");
        }
        this.println();
        this.print("// start " + TemplateCompilerContext.ContextType.PARENT_PARTIAL + ", template: " + name);
        this.println();
        try {
            p = this.createParameterPartial(name);
        }
        catch (IOException e) {
            throw new ProcessingException(this.position, e);
        }
        p.getProcessor().processToken(token);
        this.pushPartial(p);
    }

    boolean processInsideParameterPartial(PositionedToken<MustacheToken> token) throws ProcessingException {
        TemplateCompilerLike.ParameterPartial p = this.currentParameterPartial();
        if (p == null) {
            throw new IllegalStateException("bug");
        }
        PartialParameterProcessor processor = p.getProcessor();
        if (processor.isDone()) {
            throw new IllegalStateException("processor is already done");
        }
        this.beforeProcessToken(token);
        boolean done = processor.process(token).isDone();
        this.afterProcessToken(token);
        if (done) {
            try (TemplateCompilerLike.ParameterPartial parameterPartial = p;){
                this.debug("start parameter partial: ", p.getTemplateName());
                p.run();
                this.debug("end parameter partial: ", p.getTemplateName());
            }
            catch (IOException e) {
                throw new ProcessingException(this.position, e);
            }
            this.debug("end content: ", p.getProcessor().getEndContent());
            this.popPartial();
            this.println();
            this.print("// end " + TemplateCompilerContext.ContextType.PARENT_PARTIAL + ". template: " + p.getTemplateName());
            this.println();
        }
        return done;
    }

    protected boolean inLambda() {
        return this.context.getType() == TemplateCompilerContext.ContextType.LAMBDA;
    }

    @Override
    public @Nullable TemplateCompilerLike.ParameterPartial currentParameterPartial() {
        return this._partial;
    }

    void popPartial() {
        this._partial = null;
    }

    void pushPartial(TemplateCompilerLike.ParameterPartial partial) {
        this._partial = partial;
    }

    @Override
    public TemplateCompilerLike.TemplateCompilerType getCompilerType() {
        return TemplateCompilerLike.TemplateCompilerType.SIMPLE;
    }

    @Override
    public String getTemplateName() {
        return this.reader.name();
    }

    public CodeAppendable currentWriter() {
        return this.getWriter();
    }

    @Override
    public TemplateCompilerLike.ParameterPartial createParameterPartial(String templateName) throws IOException {
        this.debug("Create Parameter Partial: " + templateName);
        NamedReader reader = this.getTemplateLoader().open(templateName);
        TemplateCompilerContext context = this.context.createForParameterPartial(templateName);
        ParameterPartialTemplateCompiler c = new ParameterPartialTemplateCompiler(templateName, reader, this, context);
        PartialParameterProcessor processor = c.processor;
        c.indent = this.partialIndent;
        this.partialIndent = "";
        return new TemplateCompilerLike.ParameterPartial(c, processor);
    }

    public TemplateCompilerLike.Partial createPartial(String templateName) throws IOException {
        NamedReader reader = this.getTemplateLoader().open(templateName);
        TemplateCompilerContext context = this.context.createForPartial(templateName);
        var c = new SubTemplateCompiler(reader, this, context){

            @Override
            public TemplateCompilerLike.TemplateCompilerType getCompilerType() {
                return TemplateCompilerLike.TemplateCompilerType.PARTIAL_TEMPLATE;
            }
        };
        c.indent = this.partialIndent;
        this.partialIndent = "";
        return new TemplateCompilerLike.Partial(c);
    }

    void flushUnescaped() {
        String code = this.currentUnescaped.toString();
        if (!code.isEmpty()) {
            this._printCodeToWrite(code);
        }
        this.currentUnescaped.setLength(0);
    }

    private void printCodeToWrite(String s) {
        this.currentUnescaped.append(s);
    }

    private void _printCodeToWrite(String s) {
        if (s.isEmpty()) {
            return;
        }
        String code = CodeAppendable.stringLiteralConcat(s);
        this.println();
        this.print(this.context.renderUnescapedOutputCode(code));
        this.println();
    }

    private void print(String s) {
        int i = 0;
        for (String line : s.split("\n")) {
            if (i > 0) {
                this.println();
            }
            this.printIndent();
            this.currentWriter().print(line);
            ++i;
        }
    }

    private void printIndent() {
        this.currentWriter().print(this.baseCodeTab);
        for (int i = 0; i < this.depth; ++i) {
            this.currentWriter().print("    ");
        }
    }

    private void println() {
        this.currentWriter().println();
    }

    private void printBeginSectionComment() {
        this.println();
        this.print("// start " + this.context.getType() + ". name: " + this.context.currentEnclosedContextName() + ", template: " + this.getTemplateName());
        this.println();
    }

    private void printEndSectionComment() {
        this.println();
        this.print("// end " + this.context.getType() + ". name: " + this.context.currentEnclosedContextName() + ", template: " + this.getTemplateName());
        this.println();
    }

    @Override
    protected void _beginSection(String name) throws ProcessingException {
        this.flushUnescaped();
        TemplateCompilerContext.ContextType contextType = TemplateCompilerContext.ContextType.SECTION;
        try {
            this.pushContext(name, contextType);
            this.printBeginSectionComment();
            this.print(this.context.beginSectionRenderingCode());
            this.println();
            ++this.depth;
            if (this.context.getType() == TemplateCompilerContext.ContextType.LAMBDA) {
                this._beginLambdaSection(name);
            }
        }
        catch (ContextException ex) {
            throw new ProcessingException(this.position, ex);
        }
    }

    private void pushContext(String name, TemplateCompilerContext.ContextType contextType) throws ContextException {
        this.context = this.context.getChild(name, contextType);
    }

    private void popContext() {
        this.context = this.context.parentContext();
    }

    protected void _beginLambdaSection(String name) {
        if (this.isDebug()) {
            this.debug("Begin lambda. name = " + name);
        }
        this.rawLambdaContent.setLength(0);
    }

    protected void _endLambdaSection(final String name) throws ProcessingException {
        if (this.isDebug()) {
            this.debug("End Lambda. name = " + name);
        }
        try {
            String javaCode = CodeAppendable.stringLiteralConcat(this.currentUnescaped.toString());
            this.currentUnescaped.setLength(0);
            String rawBody = this.rawLambdaContent.toString();
            this.rawLambdaContent.setLength(0);
            final TemplateCompiler self = this;
            TemplateCompilerContext.LambdaCompiler lambdaCompiler = new TemplateCompilerContext.LambdaCompiler(){

                @Override
                public String run(TemplateCompilerContext rootContext, Reader reader, final Map<String, String> partials) throws IOException, ProcessingException {
                    NamedReader namedReader = new NamedReader(reader, name, "INLINE");
                    final CodeAppendable.StringCodeAppendable codeAppendable = new CodeAppendable.StringCodeAppendable();
                    try (SubTemplateCompiler c = new SubTemplateCompiler(namedReader, self, rootContext){
                        {
                            super(reader, parent, context);
                            this.baseCodeTab = "";
                        }

                        @Override
                        public TemplateCompilerLike.TemplateCompilerType getCompilerType() {
                            return TemplateCompilerLike.TemplateCompilerType.LAMBDA;
                        }

                        @Override
                        public CodeAppendable getWriter() {
                            return codeAppendable;
                        }

                        @Override
                        public TemplateCompilerLike.TemplateLoader getTemplateLoader() {
                            final TemplateCompilerLike.TemplateLoader rootLoader = super.getTemplateLoader();
                            if (partials.isEmpty()) {
                                return rootLoader;
                            }
                            return new TemplateCompilerLike.TemplateLoader(){

                                @Override
                                public NamedReader open(String name) throws IOException {
                                    String t = (String)partials.get(name);
                                    if (t != null) {
                                        return new NamedReader(new StringReader(t), name, "INLINE");
                                    }
                                    return rootLoader.open(name);
                                }
                            };
                        }
                    };){
                        c.run();
                        String string = codeAppendable.toString();
                        return string;
                    }
                }
            };
            this.print(this.context.lambdaRenderingCode(rawBody, javaCode, lambdaCompiler));
        }
        catch (ContextException ex) {
            throw new ProcessingException(this.position, ex);
        }
        catch (IOException ioe) {
            throw new ProcessingException(this.position, ioe);
        }
        catch (AnnotatedException ae) {
            throw new ProcessingException.AnnotationProcessingException(this.position, ae);
        }
    }

    @Override
    protected void _beginInvertedSection(String name) throws ProcessingException {
        this.flushUnescaped();
        TemplateCompilerContext.ContextType contextType = TemplateCompilerContext.ContextType.INVERTED;
        try {
            this.pushContext(name, contextType);
            this.printBeginSectionComment();
            this.print(this.context.beginSectionRenderingCode());
            this.println();
            ++this.depth;
        }
        catch (ContextException ex) {
            throw new ProcessingException(this.position, ex);
        }
    }

    @Override
    protected void _beginParentSection(String name) throws ProcessingException {
        throw new IllegalStateException("bug");
    }

    @Override
    protected void _beginBlockSection(String name) throws ProcessingException {
        this.flushUnescaped();
        TemplateCompilerContext.ContextType contextType = TemplateCompilerContext.ContextType.BLOCK;
        try {
            this.pushContext(name, contextType);
            this.printBeginSectionComment();
        }
        catch (ContextException e) {
            throw new ProcessingException(this.position, e);
        }
    }

    @Override
    protected void _endSection(String name) throws ProcessingException {
        if (!this.context.isEnclosed()) {
            throw new ProcessingException(this.position, "Closing \"" + name + "\" block when no block is currently open");
        }
        if (!this.context.currentEnclosedContextName().equals(name)) {
            throw new ProcessingException(this.position, "Closing " + name + " block instead of " + this.context.currentEnclosedContextName());
        }
        TemplateCompilerContext.ContextType contextType = this.context.getType();
        switch (contextType) {
            case LAMBDA: {
                this._endLambdaSection(name);
                --this.depth;
                break;
            }
            case PARENT_PARTIAL: {
                this.flushUnescaped();
                this._endParentSection(name);
                break;
            }
            case BLOCK: {
                this.flushUnescaped();
                this._endBlockSection(name);
                break;
            }
            case PATH: 
            case ESCAPED_VAR: 
            case UNESCAPED_VAR: 
            case SECTION_VAR: 
            case PARTIAL: {
                throw new IllegalStateException("Context Type is wrong. " + this.context.getType());
            }
            case ROOT: 
            case SECTION: 
            case INVERTED: {
                this.flushUnescaped();
                --this.depth;
            }
        }
        this.print(this.context.endSectionRenderingCode());
        this.printEndSectionComment();
        this.popContext();
    }

    protected void _endParentSection(String name) throws ProcessingException {
        throw new UnsupportedOperationException("bug close parent should be dealt somewhere else. name=" + name);
    }

    protected void _endBlockSection(String name) {
    }

    @Override
    protected void _variable(String name) throws ProcessingException.VariableProcessingException {
        this.indent();
        this.flushUnescaped();
        this.println();
        try {
            TemplateCompilerContext variable = this.context.getChild(name, TemplateCompilerContext.ContextType.ESCAPED_VAR);
            this.print("// variable: " + variable.currentEnclosedContextName());
            this.println();
            this.print(variable.renderingCode());
            this.println();
        }
        catch (ContextException.TypeNotAllowedContextException ex) {
            String message = "Variable type not allowed (see @io.jstach.jstache.JStacheFormatterTypes).";
            throw ProcessingException.VariableProcessingException.of(name, this.context, this.position, ex, message);
        }
        catch (ContextException.FieldNotFoundContextException ex) {
            String message = "Variable not found.";
            throw ProcessingException.VariableProcessingException.of(name, this.context, this.position, ex, message);
        }
        catch (ContextException ex) {
            String message = "Unknown variable problem.";
            throw ProcessingException.VariableProcessingException.of(name, this.context, this.position, ex, message);
        }
    }

    @Override
    protected void _partial(String name) throws ProcessingException {
        this.flushUnescaped();
        this.println();
        TemplateCompilerContext.ContextType contextType = TemplateCompilerContext.ContextType.PARTIAL;
        try {
            this.pushContext(name, contextType);
            this.printBeginSectionComment();
            TemplateCompilerLike.ParameterPartial pp = this.currentParameterPartial();
            if (pp != null) {
                throw new IllegalStateException("bug. parent (parameter partial) is already started for this context");
            }
            try (TemplateCompilerLike.Partial p = this.createPartial(name);){
                p.run();
            }
        }
        catch (ContextException | IOException ex) {
            throw new ProcessingException(this.position, ex);
        }
        this.print(this.context.endSectionRenderingCode());
        this.printEndSectionComment();
        this.popContext();
    }

    @Override
    protected void _unescapedVariable(String name) throws ProcessingException {
        this.indent();
        this.flushUnescaped();
        this.println();
        try {
            TemplateCompilerContext variable = this.context.getChild(name, TemplateCompilerContext.ContextType.UNESCAPED_VAR);
            this.print("// unescaped variable: " + variable.currentEnclosedContextName());
            this.println();
            this.print(variable.unescapedRenderingCode());
            this.println();
        }
        catch (ContextException ex) {
            throw new ProcessingException(this.position, ex);
        }
    }

    private void indent() {
        if (this.atStartOfLine) {
            this.printCodeToWrite(this.indent);
        }
    }

    @Override
    protected void _specialCharacter(MustacheToken.SpecialChar specialChar) throws ProcessingException {
        this.printCodeToWrite(specialChar.javaEscaped());
    }

    @Override
    public void _newline(MustacheToken.NewlineChar c) throws ProcessingException {
        this.printCodeToWrite(c.javaEscaped());
    }

    @Override
    public void _text(String s) throws ProcessingException {
        this.indent();
        this.printCodeToWrite(s);
    }

    @Override
    public void _endOfFile() throws ProcessingException {
        this.flushUnescaped();
        if (!this.context.isEnclosed()) {
            return;
        }
        throw new ProcessingException(this.position, "Unclosed \"" + this.context.currentEnclosedContextName() + "\" block at end of file");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static class RootTemplateCompiler
    extends TemplateCompiler {
        private final TemplateCompilerLike.TemplateLoader templateLoader;
        private final CodeAppendable writer;
        private final Set<Prisms.Flag> flags;
        private final TemplateStack templateStack;

        public RootTemplateCompiler(String templateName, TemplateCompilerLike.TemplateLoader templateLoader, CodeAppendable writer, TemplateCompilerContext context, Set<Prisms.Flag> flags) throws IOException {
            super(templateLoader.open(templateName), context);
            this.templateLoader = templateLoader;
            this.writer = writer;
            this.flags = flags;
            this.templateStack = context.getTemplateStack();
        }

        @Override
        public @Nullable TemplateCompilerLike getCaller() {
            return null;
        }

        @Override
        public ClassRef getModelClass() {
            return this.templateStack.getModelClass();
        }

        @Override
        public TemplateCompilerLike.TemplateLoader getTemplateLoader() {
            return this.templateLoader;
        }

        @Override
        public CodeAppendable getWriter() {
            return this.writer;
        }

        @Override
        public Set<Prisms.Flag> flags() {
            return this.flags;
        }
    }

    static class ParameterPartialTemplateCompiler
    extends SubTemplateCompiler {
        private final PartialParameterProcessor processor;
        private @Nullable PartialParameterProcessor.Block block;
        private final Deque<Section<@Nullable PartialParameterProcessor.Block>> sectionStack = new ArrayDeque<Section<PartialParameterProcessor.Block>>();

        public ParameterPartialTemplateCompiler(String partialName, NamedReader reader, TemplateCompilerLike parent, TemplateCompilerContext context) {
            super(reader, parent, context);
            this.processor = new PartialParameterProcessor(partialName, parent.logging());
        }

        @Override
        public TemplateCompilerLike.TemplateCompilerType getCompilerType() {
            return TemplateCompilerLike.TemplateCompilerType.PARAM_PARTIAL_TEMPLATE;
        }

        private @Nullable PartialParameterProcessor.Block localBlock(String name) {
            return this.processor.getBlocks().get(name);
        }

        public @Nullable PartialParameterProcessor.Block findBlock(String name) {
            @Nullable ParameterPartialTemplateCompiler current = this;
            while (current != null) {
                PartialParameterProcessor.Block block = current.localBlock(name);
                if (block != null) {
                    return block;
                }
                TemplateCompilerLike templateCompilerLike = current.getCaller();
                if (templateCompilerLike instanceof ParameterPartialTemplateCompiler) {
                    ParameterPartialTemplateCompiler ppc;
                    current = ppc = (ParameterPartialTemplateCompiler)templateCompilerLike;
                    continue;
                }
                current = null;
                break;
            }
            return null;
        }

        @Override
        protected List<PositionedToken<MustacheToken>> filter(PositionedToken<MustacheToken> positionedToken) throws ProcessingException {
            MustacheToken mt = positionedToken.innerToken();
            if (mt instanceof MustacheToken.TagToken) {
                Section<PartialParameterProcessor.Block> section;
                MustacheToken.TagToken tt = (MustacheToken.TagToken)mt;
                PartialParameterProcessor.Block b = this.block;
                if (tt.tagKind().isBeginSection()) {
                    this.sectionStack.push(new Section<PartialParameterProcessor.Block>(tt, positionedToken.position(), b));
                } else if (tt.tagKind().isEndSection() && !(section = this.sectionStack.pop()).name().equals(tt.name())) {
                    throw new ProcessingException(positionedToken.position(), "bad end section: \"" + tt.name() + "\" expected \"" + section.name() + "\"");
                }
                if (b == null && tt.tagKind() == MustacheTagKind.BEGIN_BLOCK_SECTION) {
                    PartialParameterProcessor.Block _block;
                    String name = tt.name();
                    this.block = _block = this.findBlock(name);
                    if (_block != null) {
                        this.debug("Replaying tokens for block: " + name);
                        return _block.tokens();
                    }
                    this.debug("No tokens found for block: " + name);
                    return List.of(positionedToken);
                }
                if (b != null && tt.name().equals(b.name()) && tt.tagKind() == MustacheTagKind.END_SECTION) {
                    section = this.sectionStack.peek();
                    if (section == null || section.data() == null) {
                        this.debug("Closing block: " + b.name());
                        this.debug("Section stack: " + this.sectionStack);
                        this.block = null;
                        return List.of();
                    }
                    this.debug("Processing inner block tag: " + tt.name());
                    return List.of(positionedToken);
                }
                if (this.block != null) {
                    this.debug("supressing tag: " + tt.name());
                    return List.of();
                }
                return List.of(positionedToken);
            }
            if (this.block != null) {
                this.debug("supressing other: " + positionedToken.innerToken());
                return List.of();
            }
            return List.of(positionedToken);
        }
    }

    static interface Factory {
        public TemplateCompiler createTemplateCompiler(NamedReader var1, CodeAppendable var2, TemplateCompilerContext var3);
    }

    static class SubTemplateCompiler
    extends TemplateCompiler
    implements TemplateCompilerLike.ChildTemplateCompiler {
        private final TemplateCompilerLike parent;

        protected SubTemplateCompiler(NamedReader reader, TemplateCompilerLike parent, TemplateCompilerContext context) {
            super(reader, context);
            this.parent = parent;
        }

        @Override
        public TemplateCompilerLike getCaller() {
            return this.parent;
        }
    }
}

