/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal;

import io.jstach.apt.internal.context.JavaLanguageModel;
import java.io.PrintStream;
import java.util.Objects;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.eclipse.jdt.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LoggingSupport {
    public boolean isDebug();

    public void debug(CharSequence var1);

    default public void debug(Throwable t) {
        if (this.isDebug()) {
            t.printStackTrace(this.errorWriter());
        }
    }

    default public PrintStream errorWriter() {
        return Objects.requireNonNull(System.err);
    }

    default public PrintStream outWriter() {
        return Objects.requireNonNull(System.out);
    }

    public void info(CharSequence var1);

    default public void debug(CharSequence message, Object a) {
        if (this.isDebug()) {
            this.debug(message + String.valueOf(a));
        }
    }

    default public void debug(CharSequence message, Object a, Object b) {
        if (this.isDebug()) {
            this.debug(message + String.valueOf(a) + String.valueOf(b));
        }
    }

    public void error(CharSequence var1, Throwable var2);

    public static LoggingSupport testLogger() {
        return new TestLogging();
    }

    public static final class TestLogging
    implements LoggingSupport {
        @Override
        public boolean isDebug() {
            return true;
        }

        @Override
        public void debug(CharSequence message) {
            this.outWriter().println("[TEST] " + message);
        }

        @Override
        public void error(CharSequence message, Throwable t) {
            this.errorWriter().println("[ERROR] " + message);
        }

        @Override
        public void info(CharSequence message) {
            this.outWriter().println("[INFO] " + message);
        }
    }

    public static interface LoggingSupplier {
        public LoggingSupport logging();

        default public boolean isDebug() {
            return this.logging().isDebug();
        }

        default public void debug(Throwable t) {
            this.logging().debug(t);
        }

        default public void debug(CharSequence message) {
            this.logging().debug(message);
        }

        default public void debug(CharSequence message, Object a) {
            this.logging().debug(message, a);
        }

        default public void debug(CharSequence message, Object a, Object b) {
            this.logging().debug(message, a, b);
        }

        default public void error(CharSequence message, Throwable t) {
            this.logging().error(message, t);
        }
    }

    public record RootLogging(Messager messager, boolean isDebug) implements LoggingSupport
    {
        @Override
        public void debug(CharSequence message) {
            if (this.isDebug()) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, message);
                this.outWriter().println("[JSTACHIO] " + message);
            }
        }

        @Override
        public void error(CharSequence message, Throwable t) {
            String m = message + " " + t.getMessage();
            this.messager.printMessage(Diagnostic.Kind.ERROR, m);
            this.errorWriter().println("[JSTACHIO] " + m);
        }

        @Override
        public void info(CharSequence message) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, message);
        }
    }

    public record AdHocMessager(String prefix, boolean isDebug, Element elementToLog, AnnotationMirror annotationToLog) implements MessagerLogging
    {
        @Override
        public void debug(CharSequence message) {
            if (this.isDebug()) {
                this.outWriter().println(this.prefix + message);
            }
        }

        @Override
        public void error(CharSequence message, Throwable t) {
            String m = message + t.getMessage();
            this.printError(m);
            PrintStream out = this.errorWriter();
            out.println(m);
            t.printStackTrace(out);
        }

        @Override
        public Messager messager() {
            return JavaLanguageModel.getInstance().getMessager();
        }
    }

    public static interface MessagerLogging
    extends LoggingSupport {
        public @Nullable AnnotationMirror annotationToLog();

        public Element elementToLog();

        public Messager messager();

        default public void printError(CharSequence message) {
            Messager m = this.messager();
            AnnotationMirror a = this.annotationToLog();
            Element e = this.elementToLog();
            if (a == null) {
                m.printMessage(Diagnostic.Kind.ERROR, message, e);
            } else {
                m.printMessage(Diagnostic.Kind.ERROR, message, e, a);
            }
        }

        @Override
        default public void info(CharSequence message) {
            this.messager().printMessage(Diagnostic.Kind.NOTE, message);
        }

        default public void warn(CharSequence message) {
            this.messager().printMessage(Diagnostic.Kind.WARNING, message);
        }
    }
}

