/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal;

import io.jstach.apt.internal.LoggingSupport;
import io.jstach.apt.internal.NamedTemplate;
import io.jstach.apt.prism.Prisms;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

public interface ProcessingConfig
extends LoggingSupport.MessagerLogging {
    public Set<Prisms.Flag> flags();

    public Charset charset();

    @Override
    default public boolean isDebug() {
        return this.flags().contains((Object)Prisms.Flag.DEBUG);
    }

    @Override
    default public void debug(CharSequence message) {
        this.outWriter().println("[JSTACHIO] " + message);
    }

    @Override
    default public void error(CharSequence message, Throwable t) {
        this.printError(message);
        this.errorWriter().println("[JSTACHIO] " + message);
        t.printStackTrace(this.errorWriter());
    }

    default public List<String> resourcesPaths() {
        return List.of("src/main/resources");
    }

    public boolean fallbackToFilesystem();

    public PathConfig pathConfig();

    default public boolean isGradleEnabled() {
        return ProcessingConfig.isGradle();
    }

    public static boolean isGradle() {
        String cmd = System.getProperty("sun.java.command");
        if (cmd != null) {
            return cmd.trim().startsWith("org.gradle.launcher.daemon.bootstrap.GradleDaemon");
        }
        return false;
    }

    public static @Nullable String eclipseVersion() {
        return System.getProperty("eclipse.buildId");
    }

    public static boolean isEclipse() {
        String v = ProcessingConfig.eclipseVersion();
        return v != null && !v.isBlank();
    }

    public record PathConfig(String prefix, String suffix, boolean prefixUnspecified, boolean suffixUnspecified) {
        public URI resolveTemplatePath(NamedTemplate namedTemplate) throws URISyntaxException {
            if (namedTemplate instanceof NamedTemplate.FileTemplate) {
                NamedTemplate.FileTemplate ft = (NamedTemplate.FileTemplate)namedTemplate;
                return this.resolveTemplatePath(new URI(ft.path()));
            }
            if (namedTemplate instanceof NamedTemplate.InlineTemplate) {
                NamedTemplate.InlineTemplate it = (NamedTemplate.InlineTemplate)namedTemplate;
                return new URI(it.path());
            }
            throw new IllegalStateException();
        }

        public URI resolveTemplatePath(NamedTemplate rootTemplate, NamedTemplate.FileTemplate childTemplate) throws URISyntaxException {
            if (rootTemplate == childTemplate) {
                return this.resolveTemplatePath(new URI(rootTemplate.path()));
            }
            URI uri = PathConfig.resolveFragmentURI(rootTemplate, new URI(childTemplate.path()));
            return this.resolveTemplatePath(uri);
        }

        public URI resolveTemplatePath(URI uri) throws URISyntaxException {
            Object templatePath = uri.getPath();
            if (templatePath == null) {
                templatePath = "";
            }
            if (!((String)templatePath).isBlank()) {
                templatePath = this.prefix() + (String)templatePath + this.suffix();
            }
            return new URI(uri.getScheme(), uri.getHost(), (String)templatePath, uri.getFragment());
        }

        static URI resolveFragmentURI(NamedTemplate rootTemplate, URI template) throws URISyntaxException {
            if (rootTemplate instanceof NamedTemplate.InlineTemplate) {
                return template;
            }
            URI rootUri = new URI(rootTemplate.path());
            String fragment = template.getFragment();
            String path = template.getPath();
            String string = path = path == null ? "" : path;
            if (fragment != null && (fragment.isBlank() || path == null)) {
                throw new URISyntaxException(template.toString(), "Fragment is blank");
            }
            if (fragment != null && path.isBlank()) {
                if (rootUri.getFragment() != null) {
                    throw new URISyntaxException(template.toString(), String.format("Root template already has a fragment so \"%s\" is not valid URI", template.toString()));
                }
                return new URI(rootUri.getScheme(), rootUri.getHost(), rootUri.getPath(), fragment);
            }
            return template;
        }
    }
}

