/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal;

import io.jstach.apt.internal.AnnotatedException;
import io.jstach.apt.internal.Position;
import io.jstach.apt.internal.context.ContextException;
import io.jstach.apt.internal.context.TemplateCompilerContext;
import io.jstach.apt.internal.context.TemplateStack;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessingException
extends Exception {
    private static final long serialVersionUID = 7396512855619812062L;
    private final Position position;
    private final String message;

    protected ProcessingException(Position position, String message, @Nullable Throwable cause) {
        super(message, cause);
        this.position = position;
        this.message = message;
    }

    public ProcessingException(Position position, String message) {
        this(position, message, null);
    }

    public ProcessingException(Position position, ContextException contextException) {
        this(position, contextException.getMessage(), contextException);
    }

    public ProcessingException(Position position, Exception contextException) {
        this(position, contextException.getClass().getName() + ": " + contextException.getMessage(), contextException);
    }

    public Position position() {
        return this.position;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static class VariableProcessingException
    extends ProcessingException {
        private static final long serialVersionUID = -6932648568571932099L;

        public VariableProcessingException(Position position, ContextException contextException, String message) {
            super(position, message, contextException);
        }

        public static VariableProcessingException of(String name, TemplateCompilerContext context, Position position, ContextException ex, String message) {
            TemplateStack templateStack = context.getTemplateStack();
            String m = message + "\n          var: '" + name + "'\n     position: '" + position.description() + "'\n     template: " + templateStack.describeTemplateStack() + "\n       reason: " + ex.getMessage() + "\ncontext stack: " + context.printStack() + "\n";
            return new VariableProcessingException(position, ex, m);
        }
    }

    public static class AnnotationProcessingException
    extends ProcessingException {
        private static final long serialVersionUID = 7475603035389163831L;
        private final AnnotatedException annotatedException;

        public AnnotationProcessingException(Position position, AnnotatedException annotedException) {
            super(position, annotedException);
            this.annotatedException = annotedException;
        }

        public AnnotatedException getAnnotatedException() {
            return this.annotatedException;
        }
    }
}

