/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BracesToken {
    public static BracesToken twoOpenBraces() {
        return new BToken(TokenType.TWO_OPEN);
    }

    public static BracesToken twoClosingBraces() {
        return new BToken(TokenType.TWO_CLOSE);
    }

    public static BracesToken threeOpenBraces() {
        return new BToken(TokenType.THREE_OPEN);
    }

    public static BracesToken threeClosingBraces() {
        return new BToken(TokenType.THREE_CLOSE);
    }

    public static BracesToken character(char s) {
        return new CToken(s);
    }

    public static BracesToken endOfFile() {
        return new EOFToken();
    }

    public <R, E extends Exception> R accept(Visitor<R, E> var1) throws E;

    public record BToken(TokenType type) implements BracesToken
    {
        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return switch (this.type()) {
                default -> throw new IncompatibleClassChangeError();
                case TokenType.TWO_OPEN -> visitor.twoOpenBraces();
                case TokenType.TWO_CLOSE -> visitor.twoClosingBraces();
                case TokenType.THREE_OPEN -> visitor.threeOpenBraces();
                case TokenType.THREE_CLOSE -> visitor.threeClosingBraces();
                case TokenType.CHARACTER -> throw new UnsupportedOperationException("Unimplemented case: " + this.type());
                case TokenType.EOF -> throw new UnsupportedOperationException("Unimplemented case: " + this.type());
            };
        }
    }

    public static enum TokenType {
        TWO_OPEN,
        TWO_CLOSE,
        THREE_OPEN,
        THREE_CLOSE,
        CHARACTER,
        EOF;

    }

    public record CToken(char character) implements BracesToken
    {
        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return visitor.character(this.character);
        }
    }

    public record EOFToken() implements BracesToken
    {
        @Override
        public <R, E extends Exception> R accept(Visitor<R, E> visitor) throws E {
            return visitor.endOfFile();
        }
    }

    public static interface Visitor<R, E extends Exception> {
        public R twoOpenBraces() throws E;

        public R twoClosingBraces() throws E;

        public R threeOpenBraces() throws E;

        public R threeClosingBraces() throws E;

        public R character(char var1) throws E;

        public R endOfFile() throws E;
    }
}

