/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token;

import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.token.Delimiters;
import io.jstach.apt.internal.token.MustacheTokenizer;
import io.jstach.apt.internal.token.MustacheTokenizerState;
import io.jstach.apt.internal.token.OutsideMustacheTokenizerState;
import org.eclipse.jdt.annotation.Nullable;

class DelimiterMustacheTokenizerState
implements MustacheTokenizerState {
    private final MustacheTokenizer tokenizer;
    private StringBuilder delimiterContent = new StringBuilder();
    private @Nullable Delimiters previousDelimiters = null;
    private State state = State.OPEN;

    public DelimiterMustacheTokenizerState(MustacheTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public @Nullable Void twoOpenBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected open braces");
        return null;
    }

    @Override
    public @Nullable Void twoClosingBraces() throws ProcessingException {
        try {
            this.previousDelimiters = this.tokenizer.getDelimiters();
            Delimiters delims = Delimiters.of(this.delimiterContent.toString());
            this.tokenizer.setDelimiters(delims);
            this.tokenizer.setState(new OutsideMustacheTokenizerState(this.tokenizer));
            return null;
        }
        catch (Delimiters.DelimiterParsingException e) {
            this.tokenizer.error(e.getMessage());
            return null;
        }
    }

    @Override
    public @Nullable Void threeOpenBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected open braces");
        return null;
    }

    @Override
    public @Nullable Void threeClosingBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected three closing braces");
        return null;
    }

    @Override
    public @Nullable Void character(char c) throws ProcessingException {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.EXPECTING_CLOSE -> {
                if (Character.isWhitespace(c)) {
                    yield null;
                }
                this.tokenizer.error("Unexpected '=' in delimiter definition");
                yield null;
            }
            case State.OPEN -> {
                if (c == '=') {
                    this.state = State.EXPECTING_CLOSE;
                    yield null;
                }
                this.delimiterContent.append(c);
                yield null;
            }
        };
    }

    @Override
    public @Nullable Void endOfFile() throws ProcessingException {
        this.tokenizer.error("Unclosed field at the end of file");
        return null;
    }

    @Override
    public void beforeStateChange() throws ProcessingException {
        Delimiters prev = this.previousDelimiters;
        if (prev == null) {
            throw new IllegalStateException("bug previousDelimiters");
        }
        this.tokenizer.emitToken(new MustacheToken.DelimitersToken(prev, this.tokenizer.getDelimiters()));
    }

    private static enum State {
        OPEN,
        EXPECTING_CLOSE;

    }
}

