/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token;

import io.jstach.apt.internal.MustacheToken;
import io.jstach.apt.internal.Position;
import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import io.jstach.apt.internal.token.BracesToken;
import io.jstach.apt.internal.token.Delimiters;
import io.jstach.apt.internal.token.MustacheTokenizerState;
import io.jstach.apt.internal.token.OutsideMustacheTokenizerState;
import io.jstach.apt.internal.token.util.BracesTokenizer;
import io.jstach.apt.internal.token.util.PositionTokenProcessor;
import org.eclipse.jdt.annotation.Nullable;

public class MustacheTokenizer
implements TokenProcessor<PositionedToken<BracesToken>> {
    private final PositionTokenProcessor<MustacheToken> downstream;
    private @Nullable MustacheTokenizerState state;
    private Position position = Position.noPosition();
    private Delimiters.Publisher delimitersPublisher = new Delimiters.Publisher();

    public static TokenProcessor<@Nullable Character> createInstance(String fileName, TokenProcessor<PositionedToken<MustacheToken>> downstream) {
        MustacheTokenizer mustacheTokenizer = new MustacheTokenizer(new PositionTokenProcessor<MustacheToken>(downstream));
        mustacheTokenizer.state = new OutsideMustacheTokenizerState(mustacheTokenizer);
        Delimiters.Publisher publisher = mustacheTokenizer.getDelimitersPublisher();
        return BracesTokenizer.createInstance(fileName, mustacheTokenizer, publisher);
    }

    private MustacheTokenizer(PositionTokenProcessor<MustacheToken> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void processToken(PositionedToken<BracesToken> positionedToken) throws ProcessingException {
        Position p = this.position = positionedToken.position();
        this.downstream.setPosition(p);
        BracesToken token = positionedToken.innerToken();
        token.accept(this.requireState());
    }

    public Delimiters.Publisher getDelimitersPublisher() {
        return this.delimitersPublisher;
    }

    public Delimiters getDelimiters() {
        return this.delimitersPublisher.getDelimiters();
    }

    public void setDelimiters(Delimiters delimiters) {
        this.delimitersPublisher.setDelimiters(delimiters);
    }

    private MustacheTokenizerState requireState() {
        MustacheTokenizerState s = this.state;
        if (s == null) {
            throw new IllegalStateException();
        }
        return s;
    }

    void setState(MustacheTokenizerState newState) throws ProcessingException {
        this.requireState().beforeStateChange();
        this.state = newState;
    }

    void error(String message) throws ProcessingException {
        throw new ProcessingException(this.position, message);
    }

    void emitToken(MustacheToken token) throws ProcessingException {
        this.downstream.processToken(token);
    }
}

