/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token;

import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.token.BeforeIdentifierMustacheTokenizerState;
import io.jstach.apt.internal.token.CommentMustacheTokenizerState;
import io.jstach.apt.internal.token.DelimiterMustacheTokenizerState;
import io.jstach.apt.internal.token.IdentifierMustacheTokenizerState;
import io.jstach.apt.internal.token.MustacheTagKind;
import io.jstach.apt.internal.token.MustacheTokenizer;
import io.jstach.apt.internal.token.MustacheTokenizerState;
import org.eclipse.jdt.annotation.Nullable;

class StartMustacheTokenizerState
implements MustacheTokenizerState {
    private final MustacheTokenizer tokenizer;

    StartMustacheTokenizerState(MustacheTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public @Nullable Void twoOpenBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected open braces");
        return null;
    }

    @Override
    public @Nullable Void threeOpenBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected open braces");
        return null;
    }

    @Override
    public @Nullable Void twoClosingBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected closing braces");
        return null;
    }

    @Override
    public @Nullable Void threeClosingBraces() throws ProcessingException {
        this.tokenizer.error("Unexpected closing braces");
        return null;
    }

    @Override
    public @Nullable Void character(char c) throws ProcessingException {
        switch (c) {
            case '#': {
                this.tokenizer.setState(new BeforeIdentifierMustacheTokenizerState(MustacheTagKind.BEGIN_SECTION, this.tokenizer));
                break;
            }
            case '^': {
                this.tokenizer.setState(new BeforeIdentifierMustacheTokenizerState(MustacheTagKind.BEGIN_INVERTED_SECTION, this.tokenizer));
                break;
            }
            case '>': {
                this.tokenizer.setState(new BeforeIdentifierMustacheTokenizerState(MustacheTagKind.PARTIAL, this.tokenizer));
                break;
            }
            case '<': {
                this.tokenizer.setState(new BeforeIdentifierMustacheTokenizerState(MustacheTagKind.BEGIN_PARENT_SECTION, this.tokenizer));
                break;
            }
            case '$': {
                this.tokenizer.setState(new BeforeIdentifierMustacheTokenizerState(MustacheTagKind.BEGIN_BLOCK_SECTION, this.tokenizer));
                break;
            }
            case '/': {
                this.tokenizer.setState(new BeforeIdentifierMustacheTokenizerState(MustacheTagKind.END_SECTION, this.tokenizer));
                break;
            }
            case '&': {
                this.tokenizer.setState(new BeforeIdentifierMustacheTokenizerState(MustacheTagKind.UNESCAPED_VARIABLE_TWO_BRACES, this.tokenizer));
                break;
            }
            case '!': {
                this.tokenizer.setState(new CommentMustacheTokenizerState(this.tokenizer));
                break;
            }
            case '=': {
                this.tokenizer.setState(new DelimiterMustacheTokenizerState(this.tokenizer));
                break;
            }
            default: {
                if (Character.isWhitespace(c)) {
                    this.tokenizer.setState(new BeforeIdentifierMustacheTokenizerState(MustacheTagKind.VARIABLE, this.tokenizer));
                    break;
                }
                StringBuilder fieldName = new StringBuilder();
                fieldName.append(c);
                this.tokenizer.setState(new IdentifierMustacheTokenizerState(MustacheTagKind.VARIABLE, fieldName, this.tokenizer));
            }
        }
        return null;
    }

    @Override
    public @Nullable Void endOfFile() throws ProcessingException {
        this.tokenizer.error("Unclosed field");
        return null;
    }

    @Override
    public void beforeStateChange() throws ProcessingException {
    }
}

