/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.token.util;

import io.jstach.apt.internal.Position;
import io.jstach.apt.internal.PositionedToken;
import io.jstach.apt.internal.ProcessingException;
import io.jstach.apt.internal.TokenProcessor;
import org.eclipse.jdt.annotation.Nullable;

public class PositionTokenProcessor<T>
implements TokenProcessor<T> {
    private final TokenProcessor<PositionedToken<T>> downstream;
    private @Nullable Position position = null;

    public PositionTokenProcessor(TokenProcessor<PositionedToken<T>> downstream) {
        this.downstream = downstream;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public void processToken(T transformedToken) throws ProcessingException {
        Position position = this.position;
        if (position == null) {
            throw new IllegalStateException("position was not set");
        }
        this.downstream.processToken(new PositionedToken<T>(position, transformedToken));
    }
}

