/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.internal.util;

import io.jstach.apt.internal.util.XmlHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.tools.StandardLocation;
import org.eclipse.jdt.annotation.Nullable;
import org.w3c.dom.Element;

public class EclipseClasspath {
    private final XmlHelper xml;

    protected EclipseClasspath(XmlHelper xml) {
        this.xml = xml;
    }

    public static EclipseClasspath of(Path classpathFile) throws IOException {
        try (InputStream input = Files.newInputStream(classpathFile, new OpenOption[0]);){
            XmlHelper xml = XmlHelper.of(input);
            EclipseClasspath eclipseClasspath = new EclipseClasspath(xml);
            return eclipseClasspath;
        }
    }

    public static Optional<EclipseClasspathFile> find(Path childpath) throws IOException {
        Path pf = EclipseClasspath.findParentFile(childpath, ".classpath").orElse(null);
        if (pf == null) {
            return Optional.empty();
        }
        EclipseClasspath eclipseClasspath = EclipseClasspath.of(pf);
        List<ClasspathEntry> entries = eclipseClasspath.entries().toList();
        return Optional.of(new EclipseClasspathFile(pf, entries));
    }

    public Stream<ClasspathEntry> entries() {
        return this.xml.findElements("//classpathentry").map(ClasspathEntry::of);
    }

    private static String nullToEmpty(@Nullable String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    static Optional<Path> findParentFile(Path path, String fileName) {
        return EclipseClasspath.createParentPathsStream(path).map(f -> f.resolve(fileName)).filter(p -> p.toFile().isFile()).findFirst();
    }

    static Stream<Path> createParentPathsStream(Path startingPath) {
        File file = startingPath.toAbsolutePath().toFile();
        if (file.isFile() && (file = file.getParentFile()) == null) {
            return Stream.empty();
        }
        Path sp = file.toPath();
        Iterable iterable = () -> new PathIterator(sp);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public record EclipseClasspathFile(Path classpathFile, List<ClasspathEntry> entries) {
        public Optional<ClasspathEntry> findEntry(Path classOutput, Path sourceOutput) {
            String path;
            String output;
            if (classOutput.isAbsolute() && sourceOutput.isAbsolute()) {
                Path dir = this.classpathFile.getParent();
                if (dir == null) {
                    return Optional.empty();
                }
                output = dir.relativize(classOutput).toString();
                path = dir.relativize(sourceOutput).toString();
            } else if (!classOutput.isAbsolute() && !sourceOutput.isAbsolute()) {
                output = classOutput.toString();
                path = sourceOutput.toString();
            } else {
                throw new IllegalArgumentException("classOutput and sourceOutput should be both absolute or neither absolute");
            }
            return this.entries.stream().filter(ce -> output.equals(ce.output()) && path.equals(ce.path())).findFirst();
        }

        public Stream<String> findRelativeSourcePaths(@Nullable Path classOutput, @Nullable Path sourceOutput) {
            ClasspathEntry entry;
            ClasspathEntry classpathEntry = entry = classOutput != null && sourceOutput != null ? (ClasspathEntry)this.findEntry(classOutput, sourceOutput).orElse(null) : null;
            if (entry == null) {
                return this.entries.stream().filter(ClasspathEntry::isSourcePath).map(ClasspathEntry::path).distinct();
            }
            Stream<ClasspathEntry> mainStream = this.entries.stream().filter(ce -> !ce.isTest());
            Stream<ClasspathEntry> testStream = this.entries.stream().filter(ce -> ce.isTest());
            Stream<ClasspathEntry> resolved = entry.isTest() ? Stream.concat(testStream, mainStream) : mainStream;
            return resolved.filter(ClasspathEntry::isSourcePath).map(ClasspathEntry::path).distinct();
        }
    }

    private static class PathIterator
    implements Iterator<Path> {
        private @Nullable Path currentPath;

        public PathIterator(Path startingPath) {
            this.currentPath = startingPath;
        }

        @Override
        public boolean hasNext() {
            return this.currentPath != null;
        }

        @Override
        public Path next() {
            Path nextPath = this.currentPath;
            if (nextPath == null) {
                throw new NoSuchElementException();
            }
            this.currentPath = nextPath.getParent();
            return nextPath;
        }
    }

    public record ClasspathEntry(String output, String kind, String path, Map<String, String> attributes) {
        private static ClasspathEntry of(Element element) {
            String output = EclipseClasspath.nullToEmpty(element.getAttribute("output"));
            String kind = EclipseClasspath.nullToEmpty(element.getAttribute("kind"));
            String path = EclipseClasspath.nullToEmpty(element.getAttribute("path"));
            Stream<Element> attributes = XmlHelper.toElementStream(element.getChildNodes()).filter(e -> "attributes".equals(e.getTagName())).flatMap(e -> XmlHelper.toElementStream(e.getChildNodes())).filter(e -> "attribute".equals(e.getTagName()));
            LinkedHashMap<String, String> ats = new LinkedHashMap<String, String>();
            attributes.forEach(a -> {
                String name = EclipseClasspath.nullToEmpty(a.getAttribute("name"));
                String value = EclipseClasspath.nullToEmpty(a.getAttribute("value"));
                if (name != null && value != null) {
                    ats.put(name, value);
                }
            });
            return new ClasspathEntry(output, kind, path, ats);
        }

        public @Nullable String path(StandardLocation location) {
            return switch (location) {
                case StandardLocation.CLASS_OUTPUT -> this.output();
                case StandardLocation.SOURCE_OUTPUT -> this.path();
                default -> throw new IllegalArgumentException("" + location);
            };
        }

        public boolean isSourcePath() {
            return !this.path.isEmpty() && "src".equals(this.kind);
        }

        public boolean isTest() {
            return "true".equals(this.attributes.get("test"));
        }
    }
}

