/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.prism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.Nullable;

public class JStacheInterfacesPrism {
    private List<TypeMirror> _templateImplements;
    private @Nullable TypeMirror _templateExtends;
    private List<TypeMirror> _templateAnnotations;
    private List<TypeMirror> _modelImplements;
    public static final String PRISM_ANNOTATION_TYPE = "io.jstach.jstache.JStacheInterfaces";
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>();
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>();
    private boolean valid = true;

    public static @Nullable JStacheInterfacesPrism getInstanceOn(Element e) {
        AnnotationMirror m = JStacheInterfacesPrism.getMirror(PRISM_ANNOTATION_TYPE, e);
        if (m == null) {
            return null;
        }
        return JStacheInterfacesPrism.getInstance(m);
    }

    public static JStacheInterfacesPrism getInstance(AnnotationMirror mirror) {
        String mirrorType = mirror.getAnnotationType().toString();
        if (!PRISM_ANNOTATION_TYPE.equals(mirrorType)) {
            throw new IllegalArgumentException("expected: io.jstach.jstache.JStacheInterfaces got: " + mirrorType);
        }
        return new JStacheInterfacesPrism(mirror);
    }

    private JStacheInterfacesPrism(AnnotationMirror mirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : mirror.getElementValues().entrySet()) {
            this.memberValues.put(e.getKey().getSimpleName().toString(), e.getValue());
        }
        for (ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue = member.getDefaultValue();
            if (defaultValue == null) continue;
            this.defaults.put(member.getSimpleName().toString(), defaultValue);
        }
        this._templateImplements = this.getArrayValues("templateImplements", TypeMirror.class);
        this._templateExtends = this.getValue("templateExtends", TypeMirror.class);
        this._templateAnnotations = this.getArrayValues("templateAnnotations", TypeMirror.class);
        this._modelImplements = this.getArrayValues("modelImplements", TypeMirror.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public List<TypeMirror> templateImplements() {
        return JStacheInterfacesPrism.requireMember(this._templateImplements);
    }

    public TypeMirror templateExtends() {
        return JStacheInterfacesPrism.requireMember(this._templateExtends);
    }

    public List<TypeMirror> templateAnnotations() {
        return JStacheInterfacesPrism.requireMember(this._templateAnnotations);
    }

    public List<TypeMirror> modelImplements() {
        return JStacheInterfacesPrism.requireMember(this._modelImplements);
    }

    private <T> @Nullable T getValue(String name, Class<T> clazz) {
        @Nullable T result = JStacheInterfacesPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = JStacheInterfacesPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == Collections.emptyList()) {
            this.valid = false;
        }
        return result;
    }

    private static @Nullable AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> @Nullable T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> T requireMember(@Nullable T t) {
        if (t == null) {
            throw new NoSuchElementException("prism is invalid");
        }
        return t;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return Collections.emptyList();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : JStacheInterfacesPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return Collections.emptyList();
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public @Nullable AnnotationValue templateImplements() {
            return this.values.get("templateImplements");
        }

        public @Nullable AnnotationValue templateExtends() {
            return this.values.get("templateExtends");
        }

        public @Nullable AnnotationValue templateAnnotations() {
            return this.values.get("templateAnnotations");
        }

        public @Nullable AnnotationValue modelImplements() {
            return this.values.get("modelImplements");
        }
    }
}

