/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.apt.prism;

import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.annotation.Nullable;

public class RawPrism {
    public static final String PRISM_ANNOTATION_TYPE = "io.jstach.jstache.JStacheLambda.Raw";
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>();
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>();
    private boolean valid = true;

    public static @Nullable RawPrism getInstanceOn(Element e) {
        AnnotationMirror m = RawPrism.getMirror(PRISM_ANNOTATION_TYPE, e);
        if (m == null) {
            return null;
        }
        return RawPrism.getInstance(m);
    }

    public static RawPrism getInstance(AnnotationMirror mirror) {
        String mirrorType = mirror.getAnnotationType().toString();
        if (!PRISM_ANNOTATION_TYPE.equals(mirrorType)) {
            throw new IllegalArgumentException("expected: io.jstach.jstache.JStacheLambda.Raw got: " + mirrorType);
        }
        return new RawPrism(mirror);
    }

    private RawPrism(AnnotationMirror mirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : mirror.getElementValues().entrySet()) {
            this.memberValues.put(e.getKey().getSimpleName().toString(), e.getValue());
        }
        for (ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue = member.getDefaultValue();
            if (defaultValue == null) continue;
            this.defaults.put(member.getSimpleName().toString(), defaultValue);
        }
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    private static @Nullable AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }
}

