/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.opt.spring.webmvc;

import io.jstach.jstachio.JStachio;
import io.jstach.jstachio.Output;
import io.jstach.jstachio.context.ContextJStachio;
import io.jstach.jstachio.context.ContextNode;
import io.jstach.opt.spring.web.JStachioHttpMessageConverter;
import io.jstach.opt.spring.webmvc.ServletThresholdEncodedOutput;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.View;

public interface JStachioModelView
extends View {
    public static final MediaType DEFAULT_MEDIA_TYPE = JStachioHttpMessageConverter.DEFAULT_MEDIA_TYPE;
    public static final int DEFAULT_BUFFER_LIMIT = 65536;

    default public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String contentType = this.getContentType();
        response.setContentType(contentType);
        Charset charset = this.getMediaType().getCharset();
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try (Output.CloseableEncodedOutput<IOException> o = this.createOutput(charset, response);){
            ContextNode context = this.createContext(model, request, response);
            this.jstachio().write(this.model(), context, o);
        }
    }

    private ContextNode createContext(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) {
        return ContextNode.of(model::get);
    }

    default public Output.CloseableEncodedOutput<IOException> createOutput(Charset charset, HttpServletResponse response) {
        return new ServletThresholdEncodedOutput(charset, response, 65536);
    }

    default public ContextJStachio jstachio() {
        return ContextJStachio.of((JStachio)JStachio.of());
    }

    default public Object model() {
        return this;
    }

    default public String getContentType() {
        return this.getMediaType().toString();
    }

    default public MediaType getMediaType() {
        return DEFAULT_MEDIA_TYPE;
    }

    public static JStachioModelView of(Object model) {
        return JStachioModelView.of(model, MediaType.TEXT_HTML.toString());
    }

    public static JStachioModelView of(Object model, String contentType) {
        MediaType mediaType = MediaType.parseMediaType((String)contentType);
        return JStachioModelView.of(model, mediaType);
    }

    public static JStachioModelView of(Object model, MediaType mediaType) {
        return JStachioModelView.of(model, mediaType, JStachio.of());
    }

    public static JStachioModelView of(final Object model, final MediaType mediaType, JStachio jstachio) {
        final ContextJStachio contextJStachio = ContextJStachio.of((JStachio)jstachio);
        return new JStachioModelView(){

            @Override
            public Object model() {
                return model;
            }

            @Override
            public MediaType getMediaType() {
                return mediaType;
            }

            @Override
            public ContextJStachio jstachio() {
                return contextJStachio;
            }
        };
    }
}

