/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.opt.spring.webmvc;

import io.jstach.jstachio.JStachio;
import io.jstach.jstachio.Output;
import io.jstach.opt.spring.web.JStachioHttpMessageConverter;
import io.jstach.opt.spring.webmvc.ServletThresholdEncodedOutput;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;

public class ServletJStachioHttpMessageConverter
extends JStachioHttpMessageConverter {
    public ServletJStachioHttpMessageConverter(JStachio jstachio, MediaType mediaType, int bufferLimit) {
        super(jstachio, mediaType, bufferLimit);
    }

    protected Output.CloseableEncodedOutput<IOException> createOutput(HttpOutputMessage message) {
        if (message instanceof ServletServerHttpResponse) {
            ServletServerHttpResponse sr = (ServletServerHttpResponse)message;
            return this.createOutput(sr.getServletResponse());
        }
        return super.createOutput(message);
    }

    protected Output.CloseableEncodedOutput<IOException> createOutput(HttpServletResponse response) {
        return new ServletThresholdEncodedOutput(this.getDefaultCharset(), response, this.bufferLimit);
    }
}

